/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ScopePage.cpp,v 1.2 2004/05/19 04:11:21 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "ScopeView.h"
#include "ScopePage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScopeRange vpeB y[W

IMPLEMENT_DYNCREATE(CScopeRange, CPropertyPage)

CScopeRange::CScopeRange() : CPropertyPage(CScopeRange::IDD)
{
	//{{AFX_DATA_INIT(CScopeRange)
		//  - ClassWizard ͂̈ʒuɃȍǉ܂B
	//}}AFX_DATA_INIT
}

CScopeRange::~CScopeRange()
{
}

void CScopeRange::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CScopeRange)
	DDX_Control(pDX, IDC_SCOPE_YMIN, m_ymin);
	DDX_Control(pDX, IDC_SCOPE_YMAX, m_ymax);
	DDX_Control(pDX, IDC_SCOPE_TIME, m_time);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CScopeRange, CPropertyPage)
	//{{AFX_MSG_MAP(CScopeRange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScopeRange bZ[W nh
BOOL CScopeRange::OnApply() 
{
	//ݒlǂݍ
	char buf[128];
	m_ymax.GetWindowText(buf, 128);
	m_strVmax = _T(buf);
	m_ymin.GetWindowText(buf, 128);
	m_strVmin = _T(buf);
	m_time.GetWindowText(buf, 128);
	m_strTime = _T(buf);
	
	return CPropertyPage::OnApply();
}

BOOL CScopeRange::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	m_ymax.SetWindowText(m_strVmax);
	m_ymin.SetWindowText(m_strVmin);
	m_time.SetWindowText(m_strTime);
	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}


/////////////////////////////////////////////////////////////////////////////
// CScopeGraph vpeB y[W

IMPLEMENT_DYNCREATE(CScopeGraph, CPropertyPage)

CScopeGraph::CScopeGraph() : CPropertyPage(CScopeGraph::IDD)
{
	//{{AFX_DATA_INIT(CScopeGraph)
		//  - ClassWizard ͂̈ʒuɃȍǉ܂B
	//}}AFX_DATA_INIT
}

CScopeGraph::~CScopeGraph()
{
}

void CScopeGraph::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CScopeGraph)
	DDX_Control(pDX, IDC_SCOPE_WIDTH, m_width);
	DDX_Control(pDX, IDC_GRAPH_COLOR, m_color);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CScopeGraph, CPropertyPage)
	//{{AFX_MSG_MAP(CScopeGraph)
	ON_BN_CLICKED(IDC_GRAPH_COLOR_SEL, OnGraphColorSel)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScopeGraph bZ[W nh

BOOL CScopeGraph::OnApply() 
{
	//ݒlǂݍ
	int index;
	index = m_width.GetCurSel();
	m_nWidth = index + 1;
	
	return CPropertyPage::OnApply();
}

BOOL CScopeGraph::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	m_width.SetCurSel(m_nWidth-1);
	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CScopeGraph::OnGraphColorSel() 
{
	CColorDialog dlgColor(0,0,this);
	if(dlgColor.DoModal() == IDOK) {
		m_nColor = dlgColor.GetColor();
		Invalidate();
	}
}

void CScopeGraph::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	CRect rect,rect1,rect2;
	this->GetWindowRect(rect1);
	m_color.GetWindowRect(rect);
	rect2.left = rect.left - rect1.left;
	rect2.top = rect.top - rect1.top;
	rect2.right = rect2.left + rect.Width();
	rect2.bottom = rect2.top + rect.Height();
	CBrush bkBrush( m_nColor );
	dc.FillRect( &rect2, &bkBrush );
	
	// `pbZ[WƂ CPropertyPage::OnPaint() ĂяoĂ͂܂
}
