/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ScopeList.cpp,v 1.3 2004/08/02 07:16:12 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "ScopeView.h"
#include "ScopeWnd.h"
#include "ScopeList.h"
//TODO
#include "ScopeFrame.h"
#include "MoniWnd.h"
extern CMultiDocTemplate* g_pScopeTemplate;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Image indexes
#define		IVAR_ROOT			0
#define		IVAR_ROOT_SEL		1
#define		IVAR_MEMBER			2
#define		IVAR_MEMBER_SEL		3

/////////////////////////////////////////////////////////////////////////////
// CScopeList

IMPLEMENT_DYNCREATE(CScopeList, CTreeView)

CScopeList::CScopeList()
{
	int	i;
	for(i = 0; i < MAX_PARAM; i++) {
		m_strList[i] = _T("");
		m_pScopeWnd[i] = NULL;
	}
}

CScopeList::~CScopeList()
{
}


BEGIN_MESSAGE_MAP(CScopeList, CTreeView)
	//{{AFX_MSG_MAP(CScopeList)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnSelchanged)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_DELETE_SCOPEWND, OnDeleteScopeWnd)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScopeList `

void CScopeList::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: ̈ʒuɕ`p̃R[hǉĂ
}

/////////////////////////////////////////////////////////////////////////////
// CScopeList ff

#ifdef _DEBUG
void CScopeList::AssertValid() const
{
	CTreeView::AssertValid();
}

void CScopeList::Dump(CDumpContext& dc) const
{
	CTreeView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CScopeList bZ[W nh

BOOL CScopeList::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CTreeView::PreCreateWindow (cs))
		return FALSE;

    cs.style |= TVS_HASLINES | TVS_LINESATROOT | TVS_HASBUTTONS |
        TVS_SHOWSELALWAYS;
	return TRUE;
}

void CScopeList::OnInitialUpdate() 
{
	CTreeView::OnInitialUpdate();
	
	BOOL bRet;
	
	// Initialize the image list.
    bRet = m_ilVars.Create (IDB_VARIMAGES, 24, 8, RGB (255, 0, 255));
	CImageList* pImg;
    pImg = GetTreeCtrl ().SetImageList (&m_ilVars, TVSIL_NORMAL);

	// Populate the tree view with scope items.
    AddVars ();	
	
}

void CScopeList::AddVars()
{
	CWidget *pWidget;
	int i,nCount;
	CPtrArray*	p;
	SCOPEINFO *pItem;
	CString str;
	CString name;
	HTREEITEM hChild;

	//TODO
	//pWidget = pDoc->m_pWidget;
	pWidget = ((CScopeFrame*)m_pScopeFrame)->m_pWidget;
	name = pWidget->GetName();
	p = pWidget->GetScopePointer();
	nCount = (int)p->GetSize();
	//TODO
	//if(nCount <= 1)
	//	return;

	//create root item
    m_hVar = GetTreeCtrl ().InsertItem (name, IVAR_ROOT,
            IVAR_ROOT, TVI_ROOT);

	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (SCOPEINFO*) p->GetAt (i);
			//str = _T("<") + name + _T(">") + pItem->strName;
			str = pItem->strName;
			m_strList[i] = str;

			// ŏ́ASăfBZ[u
			//pItem->visible = FALSE;
			pItem->pScopeWnd = NULL;

			// create member item
			if(pItem->visible) {
				hChild = GetTreeCtrl ().InsertItem (str, IVAR_MEMBER_SEL,
				IVAR_MEMBER_SEL, m_hVar);
				//ScopeOpen
				OpenScope(pItem, i);
			}
			else {
				hChild = GetTreeCtrl ().InsertItem (str, IVAR_MEMBER,
				IVAR_MEMBER, m_hVar);
			}
		}
		GetTreeCtrl ().Expand(m_hVar, TVE_EXPAND);
	}

	//OnSelchangeds
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (SCOPEINFO*) p->GetAt (i);
			if(pItem->visible) {
			}
		}
	}
}

void CScopeList::OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
    NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*) pNMHDR;
    HTREEITEM hItem = pNMTreeView->itemNew.hItem;

	//TODO
	//CScopeDoc* pDoc = GetDocument();
	BOOL bRet;
	int nImage,nImageSel;
	CString targetName;
	if(!hItem)
		return;

	if(pNMTreeView->action != TVC_BYMOUSE &&
		pNMTreeView->action != TVC_BYKEYBOARD) {
		GetTreeCtrl ().SelectItem(NULL);
		return;
	}

	bRet = GetTreeCtrl ().GetItemImage(hItem, nImage, nImageSel);
	if(hItem == m_hVar) {
		if(nImage == IVAR_ROOT) {
			//enble
			GetTreeCtrl ().SetItemImage(hItem, IVAR_ROOT_SEL, IVAR_ROOT_SEL);
			//TODO
			//pDoc->UpdateAllViews(this, 0x5D, NULL);
		}
		else {
			//disable
			GetTreeCtrl ().SetItemImage(hItem, IVAR_ROOT, IVAR_ROOT);
			//TODO
			//pDoc->UpdateAllViews(this, 0x5E, NULL);
		}
		GetTreeCtrl ().SelectItem(NULL);
		return;
	}

	if(bRet) {
		if(nImage == IVAR_MEMBER) {
			//enble
			GetTreeCtrl ().SetItemImage(hItem, IVAR_MEMBER_SEL, IVAR_MEMBER_SEL);
		}
		else {
			//disable
			GetTreeCtrl ().SetItemImage(hItem, IVAR_MEMBER, IVAR_MEMBER);
		}
		//getname
		targetName = GetTreeCtrl ().GetItemText(hItem);
	}
	GetTreeCtrl ().SelectItem(NULL);

	//update
	CWidget *pWidget;
	int i,nCount;
	CPtrArray*	p;
	SCOPEINFO* pItem;

	//TODO
	//pWidget = pDoc->m_pWidget;
	pWidget = ((CScopeFrame*)m_pScopeFrame)->m_pWidget;
	p = pWidget->GetScopePointer();
	nCount = (int)p->GetSize();
	for(i = 0; i < nCount; i++) {
		pItem = (SCOPEINFO *)p->GetAt(i);
		if(targetName.Compare(pItem->strName)==0) {
			if(pItem->visible) {
				pItem->visible = FALSE;
				CloseScope( pItem );
			}
			else {
				pItem->visible = TRUE;
				OpenScope( pItem, i );
			}
			//TODO
			//pDoc->UpdateAllViews(this, 0x5C, NULL);
			break;
		}
	}
		
	*pResult = 0;
}

//TODO
int CScopeList::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	CMoniWnd* pWnd = (CMoniWnd*)this->GetParent();
	m_pScopeFrame = (CWnd*)pWnd->m_pScopeFrame;

	return 0;
}

//
// ScopeWndJ
//
void CScopeList::OpenScope(SCOPEINFO* pItem, int varIndex )
{
	//ScopeǗ
	char varname[_MAX_PATH];
	strcpy(varname, pItem->strName);
	int i,index=0;
	for(i = 0; i < MAX_PARAM; i++){
		if(m_pScopeWnd[i]) {
			if(m_strScopeName[i].Compare(_T(varname)) == NULL)
				return;
			index++;
		}
	}

	//Scope
	CScopeWnd *pScopeWnd = new CScopeWnd;
	if(!pScopeWnd->Create( "Scope", WS_OVERLAPPEDWINDOW,
		CRect((index+1)*16, (index+1)*16, (index+1)*16+320, (index+1)*16+240),
			(CWnd*)m_pScopeFrame, (CWnd*)this, (char*)varname, index/*varIndex*/))
	{
		return;
	}
	pScopeWnd->ShowWindow(SW_SHOW);
	pScopeWnd->UpdateWindow();
	//o^
	m_pScopeWnd[index] = (CWnd*)pScopeWnd;
	m_strScopeName[index] = _T(varname);
	//Widgetɂo^
	pItem->pScopeWnd = (CWnd*)pScopeWnd;
	//pItemp[^
	pItem->autoScale = FALSE;
}

//
// ScopeWnd
//
void CScopeList::CloseScope(SCOPEINFO* pItem)
{
	char varname[_MAX_PATH];
	strcpy(varname, pItem->strName);
	int i,j;
	CWnd* pTmpWnd;
	CString strTmpName;

	for(i = 0; i < MAX_PARAM; i++) {
		if(m_strScopeName[i].Compare(_T(varname)) == NULL) {
			((CScopeWnd*)(m_pScopeWnd[i]))->DestroyWindow();
			m_pScopeWnd[i] = NULL;
			m_strScopeName[i] = _T("");
			for(j = i+1; j < MAX_PARAM-1; j++) {
				pTmpWnd = m_pScopeWnd[j];
				strTmpName = m_strScopeName[j];
				m_pScopeWnd[j] = NULL;
				m_strScopeName[j] = _T("");
				m_pScopeWnd[j-1] = pTmpWnd;
				m_strScopeName[j-1] = strTmpName;
			}
			break;
		}
	}
}

void CScopeList::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
}

//Scope폜ꂽꍇAC[WύXKv
//lParaḿAϐ
LRESULT CScopeList::OnDeleteScopeWnd(WPARAM wParam, LPARAM lParam)
{
	CWnd* pTmpWnd;
	CString strTmpName,itemName;
	int i,j,nCount;
	HTREEITEM hItem;
	CWidget *pWidget;
	CPtrArray*	p;
	SCOPEINFO* pItem;

	//폜ꂽEBhEItem
	hItem = GetTreeCtrl().GetFirstVisibleItem();
	while(hItem) {
		itemName = GetTreeCtrl().GetItemText(hItem);
		if(m_strScopeName[wParam].Compare(itemName) == NULL) {
			//C[WύX
			GetTreeCtrl ().SetItemImage(hItem, IVAR_MEMBER, IVAR_MEMBER);
			break;
		}
		hItem = GetTreeCtrl().GetNextVisibleItem(hItem);
	}

	//visibletO
	pWidget = ((CScopeFrame*)m_pScopeFrame)->m_pWidget;
	p = pWidget->GetScopePointer();
	nCount = (int)p->GetSize();
	for(i = 0; i < nCount; i++) {
		pItem = (SCOPEINFO *)p->GetAt(i);
		if(m_strScopeName[wParam].Compare(pItem->strName)==0) {
			if(pItem->visible)
				pItem->visible = FALSE;
			break;
		}
	}

	//폜ꂽEBhE

	m_pScopeWnd[wParam] = NULL;
	m_strScopeName[wParam] = _T("");

	//ȍ~̃EBhEl߂
	for(j = (int)wParam+1; j < MAX_PARAM-1; j++) {
		pTmpWnd = m_pScopeWnd[j];
		strTmpName = m_strScopeName[j];
		m_pScopeWnd[j] = NULL;
		m_strScopeName[j] = _T("");
		m_pScopeWnd[j-1] = pTmpWnd;
		m_strScopeName[j-1] = strTmpName;
	}

	return 0;
}

