/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ModelWnd.cpp,v 1.4 2004/08/02 07:16:12 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"
#include "ModelWnd.h"
#include "ModelDoc.h"
#include "ModelView.h"
#include "BlockView.h"
#include "ExtncsDoc.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"
#include ".\modelwnd.h"
extern CExtncsMain*	g_pExtncsMain;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CModelWnd

IMPLEMENT_DYNCREATE(CModelWnd, CFrameWnd)

CModelWnd::CModelWnd()
{
}

CModelWnd::~CModelWnd()
{
}


BEGIN_MESSAGE_MAP(CModelWnd, CFrameWnd)
	//{{AFX_MSG_MAP(CModelWnd)
	ON_WM_CREATE()
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	//}}AFX_MSG_MAP
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModelWnd bZ[W nh

BOOL CModelWnd::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	//
	// Note: Create the CFileView first so the CDriveView's OnInitialUpdate
	// function can call OnUpdate on the CFileView.
	//
    if (!m_wndSplitter.CreateStatic (this, 1, 2) ||
        !m_wndSplitter.CreateView (0, 1, RUNTIME_CLASS
            (CBlockView), CSize (0, 0), pContext) ||
        !m_wndSplitter.CreateView (0, 0, RUNTIME_CLASS (CModelView),
            CSize (144/*192*/, 0), pContext))
        return FALSE;

    return TRUE;
}

BOOL CModelWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
	cs.style &= ~FWS_ADDTOTITLE;
	cs.style &= ~WS_MAXIMIZEBOX;
	cs.style &= ~WS_MINIMIZEBOX;
	cs.x = 0;
	cs.y = 0;
	cs.cx = 320;
	cs.cy = 480;
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	return TRUE;
}

int CModelWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	// ACR\[X[h
	HICON hIcon = AfxGetApp()->LoadIcon(IDI_EXTNCS);
	ASSERT(hIcon);
	// EBhEɐVACRw肷
	this->SendMessage(WM_SETICON, TRUE, (LPARAM)hIcon);

	//^Cg
	char title[_MAX_PATH];
	strcpy(title, "Module Viewer");
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);

	// SC_CLOSE{^֎~
	CMenu*	pMenu;
	pMenu = this->GetSystemMenu( NULL );
	pMenu->EnableMenuItem( SC_CLOSE, MF_DISABLED );

	return 0;
}


void CModelWnd::OnAppExit() 
{
	//SATELLITEIAExitj[
	char cmdline[_MAX_PATH];
	strcpy(cmdline, "exit\n");
	int i,ch,len;
	DWORD size;

	//A command is transmitted. 
	len = (int)strlen(cmdline);
	for(i=0; i<len; i++){
		ch = (unsigned char)cmdline[i];
		WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
	}
	
}

BOOL CModelWnd::OnHelpInfo(HELPINFO* pHelpInfo)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	//return CFrameWnd::OnHelpInfo(pHelpInfo);
	return TRUE;
}
