/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: LineProp.cpp,v 1.3 2004/08/02 07:16:12 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "SubsysDoc.h"
#include "ExtncsDoc.h"
#include "ParamWnd.h"
#include "LineProp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ParamWnd
typedef struct tagPARAMWNDINFO {
	//Window
	CParamWnd*	pWnd;
	//id
	CWidget*	pWidget;
} PARAMWNDINFO;

/////////////////////////////////////////////////////////////////////////////
// CLineProp _CAO

#if 0
CLineProp::CLineProp(CWnd* pParent /*=NULL*/)
	: CDialog(CLineProp::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLineProp)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}
#endif

CLineProp::CLineProp()	// [hXpRXgN^[
	: CDialog()
{
}

CLineProp::~CLineProp()
{
}

CLineProp::Create(CView* pView)
{
	m_pView = pView;
	return CDialog::Create(CLineProp::IDD, pView);
}

void CLineProp::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLineProp)
	DDX_Control(pDX, IDC_LINE_OBS, m_obs);
	DDX_Control(pDX, IDC_LINE_NAME, m_name);
	DDX_Control(pDX, IDC_LINE_JUNC, m_junc);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLineProp, CDialog)
	//{{AFX_MSG_MAP(CLineProp)
	ON_WM_SETCURSOR()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLineProp bZ[W nh

BOOL CLineProp::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// Rg[̃TuNX
	VERIFY(m_style.SubclassDlgItem(IDC_LINE_STYLE, this));

	// TODO: ̈ʒuɏ̕⑫ǉĂ
	for(int i = 0; i < 3; i++)
		m_style.AddLineItem(i);
	m_style.SetCurSel(m_nLineStyle);
	
	// Junction
	if(m_id != -1) {
		CRect rect;
		CWidget *pWidget;
		int id;
		CExtncsDoc* pExtncsDoc = (CExtncsDoc *)m_pExtncsDoc;

		m_junc.GetClientRect(rect);
		CPoint point = rect.CenterPoint();
		pWidget = pExtncsDoc->GetWidget(m_id);
		id = pWidget->GetId();
		//{Ap[^tŐKv
		AddWidget(CPoint(point.x-16,point.y-16), id, 32, 32);
		//q̕ύXɑΉ邽
		m_id = -1;
	}
	//TODO:ǉ̕Kv
	m_name.EnableWindow(FALSE);
	m_obs.EnableWindow(FALSE);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CLineProp::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	//Style
	m_nLineStyle = m_style.GetCurSel();
	//Junction
	//Drag&Dropꂽꍇ́Am_id = -1ύXĂ

	m_pView->PostMessage(WM_DELETE_LINEPROP, 1, 0L);
	//CDialog::OnOK();
}

BOOL CLineProp::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	BOOL flag;
	CExtncsDoc* pExtncsDoc = (CExtncsDoc *)m_pExtncsDoc;

	if(pExtncsDoc->m_DragImageFile) {
		//ShowCursor(FALSE);
		m_pDragImage = pExtncsDoc->m_DragImageFile;
		flag = m_pDragImage->BeginDrag(0, CPoint(0, 0));
		flag = m_pDragImage->DragEnter(NULL/*this*/, CPoint(0,0));
		//::SetCapture(this->GetSafeHwnd());
		return TRUE;
	}
	
	return CDialog::OnSetCursor(pWnd, nHitTest, message);
}

void CLineProp::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	CPoint newpos;
	CRect rect;
	CExtncsDoc* pExtncsDoc = (CExtncsDoc *)m_pExtncsDoc;

	if(pExtncsDoc->m_DragImageFile) {
		//BlockViewhbO
		GetWindowRect(&rect);
		newpos.x = rect.left + point.x;
		newpos.y = rect.top + point.y;
		m_pDragImage->DragEnter(NULL, newpos/*point*/);
		m_pDragImage->DragMove(newpos/*point*/);
	}
	
	CDialog::OnMouseMove(nFlags, point);
}

void CLineProp::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	CExtncsDoc* pExtncsDoc = (CExtncsDoc *)m_pExtncsDoc;
	if(pExtncsDoc->m_DragImageFile) {
		m_pDragImage->EndDrag();
		//::ReleaseCapture();
		//ShowCursor(TRUE);
		delete m_pDragImage;
		//Widget쐬
		CRect rect;
		m_junc.GetClientRect(rect);
		CPoint point = rect.CenterPoint();
		AddWidget(CPoint(point.x-16,point.y-16), pExtncsDoc->m_DragItemIndex, 32, 32);
		//qύXꂽ
		m_id = pExtncsDoc->m_DragItemIndex;

		//m_juncɒڕ`
		CDC* pDC = m_junc.GetWindowDC();
		int nCount = (int)m_arrWidgets.GetSize();
		CWidget* pWidget;

		if (nCount) {
			for (int i=0; i<nCount; i++) {
				pWidget = m_arrWidgets.GetAt(i);
				pWidget->Draw (pDC);
			}
		}
		//
		pExtncsDoc->m_DragImageFile = NULL;
	}
	
	CDialog::OnLButtonUp(nFlags, point);
}

// AddWidget 1
int CLineProp::AddWidget(CPoint point, int id, int cx, int cy)
{
	int nIndex = -1;
	CWidget* pWidget = NULL;

	try {
		pWidget = new CWidget (point, id, cx, cy);
		nIndex = (int)m_arrWidgets.Add (pWidget);	
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

void CLineProp::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	CRect rect;
	m_junc.GetWindowRect(rect);
	ClientToScreen(&point);
	if(!rect.PtInRect(point))
		return;
	
	CWidget* pWidget;
	int nCount;

	nCount = (int)m_arrWidgets.GetSize();
	if(nCount > 0) {
		ScreenToClient(&point);
		pWidget = m_arrWidgets.GetAt(0);
		OpenParam( pWidget, point );
	}

	CDialog::OnLButtonDblClk(nFlags, point);
}

void CLineProp::OpenParam(CWidget* pWidget, CPoint point)
{
	int nCount;
	PARAMWNDINFO *pItem;
	CPtrArray*	p;

	p = pWidget->GetParamPointer();
	nCount = (int)p->GetSize();
	if(nCount == 0)
		return;		//݂Ȃ

	//
	ClientToScreen(&point);
	CParamWnd *pParamWnd = new CParamWnd;
	if(!pParamWnd->Create( "Setting parameters", WS_OVERLAPPEDWINDOW,
		CRect(point.x, point.y, 640, 480), this, pWidget))
	{
		return;
	}
	pParamWnd->ShowWindow(SW_SHOW);
	//ClientToScreen(&point);
	//pParamWnd->MoveWindow(point.x, point.y, 320, 240, TRUE);

	//p[^[EBhEǗ̂ߓo^
	try {
		pItem = new PARAMWNDINFO;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return;
	}
	//@ݒ
	pItem->pWnd = pParamWnd;
	pItem->pWidget = pWidget;
	//CfbNX
	nCount = (int)m_paramArray.GetSize();
	//o^
	m_paramArray.InsertAt( nCount, pItem );
	nCount++;
}

void CLineProp::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	CDC* pDC = m_junc.GetWindowDC();
	int nCount = (int)m_arrWidgets.GetSize();
	CWidget* pWidget;

	if (nCount) {
		for (int i=0; i<nCount; i++) {
			pWidget = m_arrWidgets.GetAt(i);
			pWidget->Draw (pDC);
		}
	}
	
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

/////////////////////////////////////////////////////////////////////////////
// CLineStyle

CLineStyle::CLineStyle()
{
}

CLineStyle::~CLineStyle()
{
}


BEGIN_MESSAGE_MAP(CLineStyle, CListBox)
	//{{AFX_MSG_MAP(CLineStyle)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLineStyle bZ[W nh

#define COLOR_ITEM_HEIGHT   20

void CLineStyle::MeasureItem(LPMEASUREITEMSTRUCT lpMIS) 
{
	// ׂẴACe͌ŒTCYłB
	// ̏s߂ LBS_OWNERDRAWVARIABLE gȂ΂Ȃ܂B
	lpMIS->itemHeight = COLOR_ITEM_HEIGHT;
	
}

void CLineStyle::Draw(CDC* pDC, RECT rc, int index)
{
	int xs,ys,xe,ye,width,height;
	CPen pen;
	CPen* pOldPen;
	CPoint pts[5];
	CBrush	arrowBrs(RGB(0, 0, 0));
	CBrush	*oldBrs;

	oldBrs = pDC->SelectObject(&arrowBrs);
	pen.CreatePen(PS_SOLID, 1, RGB(0,0,0));
	pOldPen = pDC->SelectObject(&pen);
	width = rc.right - rc.left;
	height = rc.bottom - rc.top;

	//g
	pts[0].x = rc.left; pts[0].y = rc.top;
	pts[1].x = rc.left; pts[1].y = rc.bottom;
	pts[2].x = rc.right; pts[2].y = rc.bottom;
	pts[3].x = rc.right; pts[3].y = rc.top;
	pts[4].x = rc.left; pts[4].y = rc.top;
	pDC->Polyline(pts, 5);

	xs = rc.left + (int)(width * 0.2);
	ys = rc.top + (int)(height / 2.0);
	xe = rc.left + (int)(width * 0.8);
	ye = rc.top + (int)(height / 2.0);
	pDC->MoveTo(CPoint(xs,ys));
	pDC->LineTo(CPoint(xe,ye));
	//[
	//pDC->SetPolyFillMode(WINDING);
	switch(index) {
	case 0:
		pts[0].x = xe; pts[0].y = ye;
		pts[1].x = xe - 5; pts[1].y = ye - 4;
		pts[2].x = xe - 5; pts[2].y = ye + 4;
		pDC->Polygon(pts, 3);
		break;
	case 1:
		pts[0].x = xs; pts[0].y = ys;
		pts[1].x = xs + 5; pts[1].y = ys + 4;
		pts[2].x = xs + 5; pts[2].y = ys - 4;
		pDC->Polygon(pts, 3);
		break;
	case 2:
		pts[0].x = xe; pts[0].y = ye;
		pts[1].x = xe - 5; pts[1].y = ye - 4;
		pts[2].x = xe - 5; pts[2].y = ye + 4;
		pDC->Polygon(pts, 3);
		pts[0].x = xs; pts[0].y = ys;
		pts[1].x = xs + 5; pts[1].y = ys + 4;
		pts[2].x = xs + 5; pts[2].y = ys - 4;
		pDC->Polygon(pts, 3);
		break;
	}
	//pDC->SetPolyFillMode(ALTERNATE);
	pDC->SelectObject(oldBrs);
	pDC->SelectObject(pOldPen);
	pen.DeleteObject();
}

void CLineStyle::DrawItem(LPDRAWITEMSTRUCT lpDIS) 
{
	CDC* pDC = CDC::FromHandle(lpDIS->hDC);
	int index = (int)lpDIS->itemData; // ACe CfbNX

	if (lpDIS->itemAction & ODA_DRAWENTIRE)
	{
		// vꂽFŃJ[ ACeyCg܂B
		CBrush br(RGB(192, 255, 255));
		pDC->FillRect(&lpDIS->rcItem, &br);
		// `
		Draw(pDC, lpDIS->rcItem, index);
	}

	if ((lpDIS->itemState & ODS_SELECTED) &&
		(lpDIS->itemAction & (ODA_SELECT | ODA_DRAWENTIRE)))
	{
		// ACe͑IĂ܂ - t[nCCg
		COLORREF crHilite = RGB(255, 0, 0);
		CBrush br(crHilite);
		pDC->FrameRect(&lpDIS->rcItem, &br);
	}

	if (!(lpDIS->itemState & ODS_SELECTED) &&
		(lpDIS->itemAction & ODA_SELECT))
	{
		// ACȇI͎܂ -- t[폜
		CBrush br(RGB(192, 255, 255));
		pDC->FrameRect(&lpDIS->rcItem, &br);
	}
	
}

int CLineStyle::CompareItem(LPCOMPAREITEMSTRUCT lpCIS) 
{
	COLORREF cr1 = (COLORREF)lpCIS->itemData1;
	COLORREF cr2 = (COLORREF)lpCIS->itemData2;
	if (cr1 == cr2)
		return 0;       // mɃ}b`

	// ŏɖÓx(ʓx)Ń\[g܂AÓx(ʓx)Ⴂł
	int intensity1 = GetRValue(cr1) + GetGValue(cr1) + GetBValue(cr1);
	int intensity2 = GetRValue(cr2) + GetGValue(cr2) + GetBValue(cr2);
	if (intensity1 < intensity2)
		return -1;      // Óx(ʓx)Ⴂł
	else if (intensity1 > intensity2)
		return 1;       // Óxiʓxj 2 Ԃ߂ł

	// Óx(ʓx)̏ꍇAFŃ\[g܂ (ŏŁAԂŌł)
	if (GetBValue(cr1) > GetBValue(cr2))
		return -1;
	else if (GetGValue(cr1) > GetGValue(cr2))
		return -1;
	else if (GetRValue(cr1) > GetRValue(cr2))
		return -1;
	else
		return 1;
	

}

void CLineStyle::AddLineItem(int index)
{
	// Xg {bNX̃ACeǉ
	AddString((LPCTSTR) index);

}


void CLineProp::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	
	m_pView->PostMessage(WM_DELETE_LINEPROP, 0, 0L);
	//CDialog::OnCancel();
}
