/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ExtncsMain.h,v 1.2 2004/05/19 04:11:21 yoshihiko Exp $ */

#if !defined(AFX_SIGMAMAIN_H__98826A88_921C_4302_8C86_27667E65D7A8__INCLUDED_)
#define AFX_SIGMAMAIN_H__98826A88_921C_4302_8C86_27667E65D7A8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CExtncsMain  
{
public:
	int GetModuleIndex();
	void UpdateBlockFile();
	BOOL DelBlockData(int index);
	int m_nDefaultSize;
	int GetModelInInfo(char *line, BLOCKINFO *pItem);
	int GetModelOutInfo(char *line, BLOCKINFO *pItem);
	BOOL GetModelInOut(char *fname, BLOCKINFO *pItem);
	HANDLE    m_hStdinW;   /* write side PIPE of standard input handle for Shell interface */
	int SetBlockDataAppend(char *path, char *name, int group, int nBitmap);
	CWinApp* m_pApp;
	CView* m_pConsoleView;
	CExtncsWnd* m_pExtncsWnd;
	CExtncsDoc* m_pExtncsDoc;
	CModelDoc* m_pModelDoc;
	UINT GetClipboardFormat();
	CPtrArray m_varArray;
	CPtrArray m_blockArray;
	int GetModelInfo(char *name, CString info[]);
	BOOL GetPortInfo(const char *name, BLOCKINFO* pItem);
	void SetBlockClear();
	BOOL SetBlockData();
	CExtncsMain();
	virtual ~CExtncsMain();
protected:
	UINT m_nFormat;

};

#endif // !defined(AFX_SIGMAMAIN_H__98826A88_921C_4302_8C86_27667E65D7A8__INCLUDED_)
