/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ExtncsDoc.h,v 1.7 2004/09/03 10:11:05 yoshihiko Exp $ */

#if !defined(AFX_SIGMADOC_H__6F26A7BC_816D_46B2_80B6_492F54B8D5A7__INCLUDED_)
#define AFX_SIGMADOC_H__6F26A7BC_816D_46B2_80B6_492F54B8D5A7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "WidgetObj.h"
typedef CTypedPtrArray<CObArray, CWidget*> CWidgetArray;
typedef CTypedPtrArray<CObArray, CLine*> CLineArray;

/////////////////////////////////////////////////////////////////////////////
// CExtncsDoc hLg

class CExtncsDoc : public CDocument
{
protected:
	CExtncsDoc();           // IɎgpveNg RXgN^B
	DECLARE_DYNCREATE(CExtncsDoc)

// Agr[g
public:
	CView* m_pExtncsTree;

// Iy[V
public:
//method
	//ExtncsDoc.cpp
	BOOL GetWidgetPath(CWidget* pTargetWidget, char* pathbuf);
	BOOL GetWidgetPathSubsystem(CWidget* pSubWidget, CWidget* pTargetWidget, char* pathbuf);
	void SubDeleteContents(CWidget *pTargetWidget);
	void InitSubsystem(CWidget* pWidget, int inpnum, int outpnum);
	void ChangeName(char* name);
	void SubChangeName(CWidget* pTargetWidget, char* name);
	UINT m_nFormat;
	BOOL RemoveWidget (int nIndex);
	int AddWidget (int id, int x, int y, int width, int height, COLORREF color, char *name);
	int AddWidget (int id, CPoint point, char *name, int direction, CString matrix,
		int width, int height);
	int AddSubWidget(CWidget* pTargetWidget, int id, CPoint point, char *name,
							 int direction, CString matrix, int cx, int cy);
	int AddWidget2(int id, CPoint point, char *name,
		int direction, CString matrix, int nParam, char strValue[][16], int width, int height);
	int AddSubWidget2(CWidget* pTargetWidget, int id, CPoint point, char *name,
		int direction, CString matrix, int nParam, char strValue[][16], int width, int height);
	CWidget* GetWidget (int nIndex);
	int GetWidgetCount ();
	BOOL RemoveLine (int nIndex);
	BOOL RemoveLineAt (int nIndex);
	int AddLine (CPoint spt, CPoint ept, int sidx, int eidx, COLORREF color, int arrow, int idx,
		int inport, int outport, int type, int junc);
	int AtLine(int index, CPoint spt, CPoint ept, int sidx, int eidx, COLORREF color, int arrow, int idx,
					   int inport, int outport, int type, int junc);
	CLine* GetLine (int nIndex);
	int GetLineCount ();
	BOOL InsertWidget(int id, CPoint point);
	void InsertWidgetJunc(int id, CPoint point, int index, int group);
	void InsertLine(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	// Right->
	void InsertLineRR(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineRU(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineRL(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineRD(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	// Up->
	void InsertLineUR(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineUU(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineUL(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineUD(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	// Left->
	void InsertLineLR(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineLU(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineLL(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineLD(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	// Down->
	void InsertLineDR(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineDU(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineDL(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineDD(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	//Line->WidgetԐڑ
	void InsertDivide(CRect rect, int lSel, int sidx, int eidx, int inport, int junc);
	//Horz->
	void InsertDivideHR(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideHU(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideHL(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideHD(CRect rect, int sidx, int eidx, int inport, int junc);
	// Vert->
	void InsertDivideVR(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideVU(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideVL(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideVD(CRect rect, int sidx, int eidx, int inport, int junc);
	// CύX
	void ChangeLine(int lSel, int style);
	//t@C
	int LoadNcsModel(char *openfile, char *modelfile);
	BOOL LoadExtncsModel(char *openfile);
	BOOL SaveExtncsModel(char *openfile);
	void SaveExtncsModelScope(FILE *fp, CWidget *pWidget);
	void SaveExtncsModelSubsystem(FILE *fp, CWidget *pWidget);
//TODO:
	//void SaveModelSubsystemDoc(FILE *fp, CSubsysDoc *pDoc);
	void SaveModelSubsystemDoc(FILE *fp, CDocument *pDoc);
	void SaveModelSubsystemWidget(FILE *fp, CWidget *pWidget);
	BOOL LoadExtncsModelScope(FILE *fp, CWidget *pWidget);
	void LoadExtncsModelSubsystem(FILE *fp, CWidget *pWidget);
	void SetLine(CWidget *pWidegt, CString list);

	//CodeGene.cpp
	void*		GetExtncsView();
	BOOL		CodeGenerate();
	int			CodeGenerateLineList(CPtrArray* pCodeArray);
	int			CodeGenerateLineListSubsystem(CWidget* pTargetWidget, int baseaddr);
	BOOL		CodeGenerateConnection(CPtrArray* pCodeArray);
	BOOL		CodeGenerateConnectionSubsystem(CWidget *pTargetWidget, CPtrArray* pCodeArray);
	int			SetConnection(CWidget* pTargetWidget, int con, CPtrArray* pCodeArray);
	int			SetConnectionExpand(CWidget* tWidget, int level, int nSubsystem, int con, CPtrArray* pCodeArray);
	int			SetConnectionExpandCell(CWidget* pWidget, CString strCell[], int iCount, int order);
	int			SetSubsystemConnection(CString name, int level, CWidget* pWidget, int con, CPtrArray* pCodeArray);
	int			SetConnectionInport( CString name, int level, int nSubsystem, int con, CPtrArray* pCodeArray );
	//int			SetConnectionSubsystem(CWidget* pWidget, int level);
	int			SetConnectionSubsystem(CWidget* pTargetWidget, int id, CString name, int con, CPtrArray* pCodeArray);
	void		SetWidgetOrder(CPtrArray* pCodeArray);
	int			SetWidgetOrderSearch(CString name, int order);
	void		CodeGeneratePrint();
	void		CodeGenerateModule(CPtrArray* pCodeArray);
	BOOL		CodeGenerateCell(CPtrArray* pCodeArray);
	BOOL		CodeGenerateCellSubsystem(CWidget* pWidget, CPtrArray* pCellArray);
	void		CodeGenerateGap(CPtrArray* pCodeArray);
	void		CodeGenerateGapSubsystem(CWidget* pTargetWidget,
		CPtrArray* pCellArray, CPtrArray* pCodeArray);
	void		CodeGenerateTransferModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateTransferParam(CWidget* pWidget, int *nord, double num[],
						int *dord, double den[], CPtrArray* pCodeArray);
	int			GetTransferParam(CString prm, double val[]);
	void		CodeGenerateTransferFunc(int nnum, double num[],
						int dnum, double den[], CPtrArray* pCodeArray);
	void		CodeGenerateModuleModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateSumModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateProductModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateDelayModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateMathModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateSelectModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateShellModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateXyModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateName(CPtrArray* pCodeArray);
	void		CodeGenerateModuleGap(CPtrArray* pCodeArray);
	void		CodeGenerateModuleParameter(CWidget* pWidget, char* linebuf);
	int			GetCellStyle(int row, int column);
	void		AddSubsysWidget(CWidget* pWidget, int xs, int ys, int id, CString name,
				int direction, CString matrix, int inport, int outport, int nparam, CString pparam[]);
	void		AddSubsysLine(CWidget* pWidget, CPoint spos, CPoint epos, int sblk, int eblk,
				COLORREF color, int arrow, int idx, int inport, int outport,
				int type, int junc);
	int			GetMatrixRow(CString matrix);
	int			GetMatrixColumn(CString matrix);
	BOOL		CodeGenerateInit();
	int			CodeGenerateInitSubsystem(CWidget* pWidget, int level);
	BOOL		CheckLatest(char *openfile);
	void		SetSubsystemOrder(CWidget* pTargetWidget, CPtrArray* pCodeArray);
	int			SetSubsystemOrderSearch(CWidget* pWidget, int level, CString name, int origin);
	void		CodeGenerateModuleSubsystem(CWidget* pTargetWidget, CPtrArray* pCodeArray);
	void		CodeGenerateSubsystemParameter(SUBSYSWIDGET* wItem, char* linebuf);
	void		CodeGenerateSubsystemOthers(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateSubsystemTransfer(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateSubsystemDelay(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateSubsystemSum(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateSubsystemProduct(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateTransferParamSub(SUBSYSWIDGET* wItem, int *nord, double num[],
						int *dord, double den[], CPtrArray* pCodeArray);
	void		CodeGenerateSubsystemGap(CWidget* pTargetWidget, CPtrArray* pCodeArray);
	void		CodeGenerateSubsystemMath(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateSubsystemSelect(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray);
	void		CodeGenerateModuleGapExpand(CString name, int id, CPtrArray* pCodeArray);
	BOOL		CheckJunction(int id);
	int			GetLineStyle(int lSel);
	BOOL		SaveAsModel(char* modelname);
	BOOL		Print(CPtrArray* pCodeArray, CString str);
	CString		SetConnectionOutport(CWidget* pTargetWidget, int port);
	CString		SetConnectionInport(CWidget* pTargetWidget, int port);
	BOOL		SetGapBuffer(CPtrArray* pGapArray, CString str);
	void		FileSave();
	void		FileSaveAs();
	void		ExtncsCode();
	void		ExtncsCompile();

	//CodeComp.cpp
	BOOL		CodeCompile();
	void		ModifyTableModule(FILE* fp);
	void		ModifyTableModuleSubsystem(FILE* fp, CWidget* pTargetWidget);

//data
	CWidget*		m_pTargetWidget;	//JgVXe
	CImageList		*m_DragImageFile;
	int				m_DragItemIndex;
	int				m_DragItemGroup;
	CString			m_ExtncsName;		//fullpathf
	CString			m_ModelName;		//Sigf
	//connectionp[N̈
	CString			m_strList[MAX_CONNECTION];
	int				m_lineLevel[MAX_CONNECTION];
	int				m_desRow[MAX_CONNECTION];
	int				m_desColumn[MAX_CONNECTION];
	int				m_desArrow[MAX_CONNECTION];
	int				m_desId[MAX_CONNECTION];
	int				m_srcRow[MAX_CONNECTION];
	int				m_srcColumn[MAX_CONNECTION];
	int				m_srcArrow[MAX_CONNECTION];
	int				m_srcId[MAX_CONNECTION];
	CString			m_srcName[MAX_CONNECTION];
	CString			m_desName[MAX_CONNECTION];
	int				m_srcBlk[MAX_CONNECTION];
	int				m_desBlk[MAX_CONNECTION];
	int				m_srcPort[MAX_CONNECTION];
	int				m_desPort[MAX_CONNECTION];
	int				m_nList;
	CString			m_strJunc[MAX_CONNECTION];
	int				m_nJunc[MAX_CONNECTION];
	int				m_nDefaultJunc[MAX_CONNECTION];
	BOOL			m_bCodeGen;			//CodetO
	BOOL			m_bCodeCompile;		//CompiletO
	FILE*			m_defaultFp;		//ftHg
	//V~[V
	CString			m_strTime;
	CString			m_strStep;
	CString			m_strSave;
	int				m_nInteg;
	BOOL			m_bRtmode;
	//CCfbNX
	int				m_nLineIndex;
	//EBhEǗptO
	BOOL			m_bSubsysWnd[MAX_SUBSYSTEM];
	BOOL			m_bScopeWnd[MAX_SCOPE];

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CExtncsDoc)
	public:
	virtual void Serialize(CArchive& ar);   // hLg I/O ɑ΂ăI[o[Ch܂B
	virtual void DeleteContents();
	protected:
	virtual BOOL OnNewDocument();
	virtual BOOL SaveModified();
	//}}AFX_VIRTUAL

// Cve[V
public:
	virtual ~CExtncsDoc();

protected:
	CWidgetArray m_arrWidgets;
	CLineArray m_arrLines;
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// bZ[W }bv֐̐
protected:
	//{{AFX_MSG(CExtncsDoc)
	afx_msg void OnFileNew();
	afx_msg void OnUpdateFileNew(CCmdUI* pCmdUI);
	afx_msg void OnFileOpen();
	afx_msg void OnUpdateFileOpen(CCmdUI* pCmdUI);
	afx_msg void OnFileSave();
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnFileSaveAs();
	afx_msg void OnUpdateFileSaveAs(CCmdUI* pCmdUI);
	afx_msg void OnExtncsCode();
	afx_msg void OnUpdateExtncsCode(CCmdUI* pCmdUI);
	afx_msg void OnExtncsCompile();
	afx_msg void OnUpdateExtncsCompile(CCmdUI* pCmdUI);
	afx_msg void OnExtncsNcs();
	afx_msg void OnUpdateExtncsNcs(CCmdUI* pCmdUI);
	afx_msg void OnFileClose();
	afx_msg void OnNcsExtncs();
	afx_msg void OnUpdateNcsExtncs(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_SIGMADOC_H__6F26A7BC_816D_46B2_80B6_492F54B8D5A7__INCLUDED_)
