/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ExtncsDoc.cpp,v 1.8 2004/09/07 08:14:35 yoshihiko Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "SubsysDoc.h"
#include "SubsysWnd.h"
#include "ExtncsDoc.h"
#include "ExtncsView.h"

#include "ExtncsWnd.h"
#include "ModelDoc.h"
#include "ExtncsMain.h"
#include <direct.h>
#include "ScopeFrame.h"
#include "libsatellite.h"
extern CExtncsMain*	g_pExtncsMain;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExtncsDoc

IMPLEMENT_DYNCREATE(CExtncsDoc, CDocument)

CExtncsDoc::CExtncsDoc()
{
	m_DragImageFile = NULL;
	m_bCodeGen = FALSE;
	m_bCodeCompile = FALSE;
	m_ExtncsName = _T("untitled.sig");
	m_ModelName = _T("untitled.sig");
	m_defaultFp = NULL;
	//V~[V
	m_strTime = _T("10.0");
	m_strStep = _T("0.01");
	m_strSave = _T("0.01");
	m_nInteg = 0;
	m_bRtmode = FALSE;
	m_nLineIndex = 0;
	//EBhEǗ̈
	int i;
	for(i = 0; i < MAX_SUBSYSTEM; i++)
		m_bSubsysWnd[i] = FALSE;
	for(i = 0; i < MAX_SCOPE; i++)
		m_bScopeWnd[i] = FALSE;
	//JgVXe
	m_pTargetWidget = NULL;		// NULĹArootw
}

BOOL CExtncsDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

CExtncsDoc::~CExtncsDoc()
{
}


BEGIN_MESSAGE_MAP(CExtncsDoc, CDocument)
	//{{AFX_MSG_MAP(CExtncsDoc)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_UPDATE_COMMAND_UI(ID_FILE_NEW, OnUpdateFileNew)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, OnUpdateFileSaveAs)
	ON_COMMAND(ID_EXTNCS_CODE, OnExtncsCode)
	ON_UPDATE_COMMAND_UI(ID_EXTNCS_CODE, OnUpdateExtncsCode)
	ON_COMMAND(ID_EXTNCS_COMPILE, OnExtncsCompile)
	ON_UPDATE_COMMAND_UI(ID_EXTNCS_COMPILE, OnUpdateExtncsCompile)
	ON_COMMAND(ID_EXTNCS_NCS, OnExtncsNcs)
	ON_UPDATE_COMMAND_UI(ID_EXTNCS_NCS, OnUpdateExtncsNcs)
	ON_COMMAND(ID_FILE_CLOSE, OnFileClose)
	ON_COMMAND(ID_NCS_EXTNCS, OnNcsExtncs)
	ON_UPDATE_COMMAND_UI(ID_NCS_EXTNCS, OnUpdateNcsExtncs)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExtncsDoc ff

#ifdef _DEBUG
void CExtncsDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CExtncsDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CExtncsDoc VACY

void CExtncsDoc::Serialize(CArchive& ar)
{
	m_arrWidgets.Serialize (ar);
	m_arrLines.Serialize (ar);
}

/////////////////////////////////////////////////////////////////////////////
// CExtncsDoc R}h

void CExtncsDoc::DeleteContents() 
{
	int i;
	CWidget* pWidget;

	// Widget
	i = (int)m_arrWidgets.GetSize ();
	while (i) {
		pWidget =  m_arrWidgets[--i];
		if(pWidget->GetId() == M_SUBSYSTEM)
			SubDeleteContents(pWidget);
		delete pWidget;
	}
	m_arrWidgets.RemoveAll ();
	// Line
	i = (int)m_arrLines.GetSize ();
	while (i)
		delete m_arrLines[--i];
	m_arrLines.RemoveAll ();
	// gW[
	
	CDocument::DeleteContents();
}

// SubsystemAWidgetLine폜
void CExtncsDoc::SubDeleteContents(CWidget *pTargetWidget) 
{
	if(!pTargetWidget)
		return;

	int i;
	CWidget* pWidget;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();
	CLine* pLine;
	CPtrArray* pArrLines = pTargetWidget->GetLinesPointer();

	// Widget
	i = (int)pArrWidgets->GetSize ();
	while (i) {
		pWidget =  (CWidget*)pArrWidgets->GetAt(--i);
		if(pWidget->GetId() == M_SUBSYSTEM)
			SubDeleteContents(pWidget);
		delete pWidget;
	}
	pArrWidgets->RemoveAll ();
	// Line
	i = (int)pArrLines->GetSize ();
	while (i) {
		pLine = (CLine*)pArrLines->GetAt(--i);
		delete pLine;
	}
	pArrLines->RemoveAll ();

	//ŁASubsystemWidgetsLines͍폜Ă
	//CSubsysDoc* pDoc = (CSubsysDoc*)pTargetWidget->GetDocument();
	//if(pDoc)
	//	pDoc->m_pWidget = NULL;
}

int CExtncsDoc::GetWidgetCount()
{
	if(!m_pTargetWidget)
		return (int)m_arrWidgets.GetSize ();
	else {
		CPtrArray* p;
		p = m_pTargetWidget->GetWidgetsPointer();
		return (int)p->GetSize();
	}
}

CWidget* CExtncsDoc::GetWidget(int nIndex)
{
	if(!m_pTargetWidget) {
		if (nIndex >= m_arrWidgets.GetSize ())
			return NULL;
		return (CWidget*) m_arrWidgets[nIndex];
	}
	else {
		CPtrArray* p;
		p = m_pTargetWidget->GetWidgetsPointer();
		if (nIndex >= p->GetSize ())
			return NULL;
		return (CWidget*) p->GetAt(nIndex);
	}
}

// AddWidget 1
int CExtncsDoc::AddWidget(int id, int x, int y, int cx, int cy, COLORREF color, char *name)
{
	int nIndex = -1;
	CWidget* pWidget = NULL;

	try {
		pWidget = new CWidget (id, x, y, cx, cy, color, name);
		nIndex = (int)m_arrWidgets.Add (pWidget);	
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}
// AddWidget 2
// mode = 1̏ꍇ͈ړ
int CExtncsDoc::AddWidget(int id, CPoint point, char *name, int direction, CString matrix, int cx, int cy)
{
	int nIndex = -1;
	CWidget* pWidget;
	int i,nCount,index;
	char blkname[128];
	char idname[16];
	BLOCKINFO *pItem;

	//OύXAidւ̑Ώ
	nCount = (int)m_arrWidgets.GetSize ();
	index = 0;
	if(!name) {
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) m_arrWidgets[i];
			if(id == pWidget->GetId()) {
				index++;
			}
		}
	}

	//Widget̐
	pWidget = NULL;
	try {
		pWidget = new CWidget (point, id, cx, cy);
		pItem = pWidget->GetPitem();
		if(!name) {
			strcpy(blkname, pItem->name);
			if(index > 0) {
				sprintf(idname,"%d",index);
				strcat(blkname, idname);
			}
			pWidget->SetName(CString(blkname));
		}
		else
			pWidget->SetName(CString(name));
		// direction
		pWidget->SetDirection( direction );
		// matrix
		pWidget->SetMatrix( matrix );
		// inport name
		if(pItem->inport != 0)
			pWidget->SetInportName(&(pItem->inpname));
		// outport name
		if(pItem->outport != 0)
			pWidget->SetOutportName(&(pItem->outpname));
		// Subsystemǉ
		if(id == M_SUBSYSTEM) {
			InitSubsystem(pWidget, pItem->inport, pItem->outport);
		}
		//m_arrWidgetsɃW[ǉ
		nIndex = (int)m_arrWidgets.Add (pWidget);	
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("AddWidget function:Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

//AddSubWidget
//Subsystem\Widgeto^
int CExtncsDoc::AddSubWidget(CWidget* pTargetWidget, int id, CPoint point, char *name,
							 int direction, CString matrix, int cx, int cy)
{
	int nIndex = -1;
	CWidget* pWidget;
	int i,nCount,index;
	char blkname[128];
	char idname[16];
	BLOCKINFO *pItem;
	CPtrArray* pArrWidgets;

	//pTargetWidgetm_arrWidgets擾
	pArrWidgets = pTargetWidget->GetWidgetsPointer();
	//OύXAidւ̑Ώ
	nCount = (int)pArrWidgets->GetSize ();
	index = 0;
	if(!name) {
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) pArrWidgets->GetAt(i);
			if(id == pWidget->GetId()) {
				index++;
			}
		}
	}

	//Widget̐
	pWidget = NULL;
	try {
		pWidget = new CWidget (point, id, cx, cy);
		pItem = pWidget->GetPitem();
		if(!name) {
			strcpy(blkname, pItem->name);
			if(index > 0) {
				sprintf(idname,"%d",index);
				strcat(blkname, idname);
			}
			pWidget->SetName(CString(blkname));
		}
		else
			pWidget->SetName(CString(name));
		// direction
		pWidget->SetDirection( direction );
		// matrix
		pWidget->SetMatrix( matrix );
		// inport name
		if(pItem->inport != 0)
			pWidget->SetInportName(&(pItem->inpname));
		// outport name
		if(pItem->outport != 0)
			pWidget->SetOutportName(&(pItem->outpname));
		// Subsystemǉ
		if(id == M_SUBSYSTEM) {
			InitSubsystem(pWidget, pItem->inport, pItem->outport);
		}
		//m_arrWidgetsɃW[ǉ
		nIndex = (int)pArrWidgets->Add (pWidget);	
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("AddWidget function:Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

// CWidgetm_arrWidgetsm_arrLines
void CExtncsDoc::InitSubsystem(CWidget* pWidget, int inpnum, int outpnum)
{
	int i,x,y,index;
	CRect rect;
	CPoint pos;
	CString strName;
	char name[_MAX_PATH];

	x = 32;
	y = 32;
	strName = _T("Inport");
	for(i = 0; i < inpnum; i++) {
		pos = CPoint(x, y);
		strcpy(name, strName);
		if(i > 0) {
			strcat(name, "_");
			SubChangeName(pWidget, name);
		}
		index = AddSubWidget (pWidget, M_INPORT, pos, name, DIR_RIGHT, _T("1:1"), 32, 32);
		y = y + 64;
	}
	x += 64;
	y = 32;
	strName = _T("Outport");
	for(i = 0; i < outpnum; i++) {
		pos = CPoint(x, y);
		strcpy(name, strName);
		if(i > 0) {
			strcat(name, "_");
			SubChangeName(pWidget, name);
		}
		index = AddSubWidget (pWidget, M_OUTPORT, pos, name, DIR_RIGHT, _T("1:1"), 32, 32);
		y = y + 64;
	}

	//LineIndex
	pWidget->SetLineIndex(0);

}

// AddWidget
// p[^[܂
int CExtncsDoc::AddWidget2(int id, CPoint point, char *name,
		int direction, CString matrix, int nParam, char strValue[][16], int width, int height)
{
	int nIndex = -1;
	CWidget* pWidget;
	int i,nCount,index;
	char blkname[128];
	char idname[16];
	BLOCKINFO *pItem;
	CPtrArray*	prm;
	PARAMINFO *prmItem;
	SCOPEINFO *scopeItem;
	int prmCount;

	//OύXAidւ̑Ώ
	nCount = (int)m_arrWidgets.GetSize ();
	index = 0;
	if(!name) {
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) m_arrWidgets[i];
			if(id == pWidget->GetId()) {
				index++;
			}
		}
	}

	//Widget̐
	pWidget = NULL;
	try {
		pWidget = new CWidget (point, id, width, height);
		pItem = pWidget->GetPitem();
		if(!name) {
			pItem = pWidget->GetPitem();
			strcpy(blkname, pItem->name);
			if(index > 0) {
				sprintf(idname,"%d",index);
				strcat(blkname, idname);
			}
			pWidget->SetName(CString(blkname));
		}
		else
			pWidget->SetName(CString(name));
		pWidget->SetDirection( direction );
		pWidget->SetMatrix(matrix);
		if(pItem->inport != 0)
			pWidget->SetInportName(&(pItem->inpname));
		if(pItem->outport != 0)
			pWidget->SetOutportName(&(pItem->outpname));
		//p[^[
		prm = pWidget->GetParamPointer();
		prmCount = (int)prm->GetSize();
		for (i=0; i<prmCount; i++) {
			//PARAMINFO
			prmItem = (PARAMINFO*) prm->GetAt (i);
			prmItem->strValue = _T(strValue[i]);
		}
		//ScopeɃTCYݒ
		prm = pWidget->GetScopePointer();
		prmCount = (int)prm->GetSize();
		for (i=0; i<prmCount; i++) {
			//PARAMINFO
			scopeItem = (SCOPEINFO*) prm->GetAt (i);
			scopeItem->size = pWidget->GetCellRow() * pWidget->GetCellColumn();
		}

		//Widgetǉ
		nIndex = (int)m_arrWidgets.Add (pWidget);	
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("AddWidget function:Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

// AddSubWidget2
// p[^[܂
int CExtncsDoc::AddSubWidget2(CWidget* pTargetWidget, int id, CPoint point, char *name,
		int direction, CString matrix, int nParam, char strValue[][16], int width, int height)
{
	int nIndex = -1;
	CWidget* pWidget;
	int i,nCount,index;
	char blkname[128];
	char idname[16];
	BLOCKINFO *pItem;
	CPtrArray*	prm;
	PARAMINFO *prmItem;
	SCOPEINFO *scopeItem;
	int prmCount;
	CPtrArray* pArrWidgets;

	//pTargetWidgetm_arrWidgets擾
	pArrWidgets = pTargetWidget->GetWidgetsPointer();
	//OύXAidւ̑Ώ
	nCount = (int)pArrWidgets->GetSize ();
	index = 0;
	if(!name) {
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) pArrWidgets->GetAt(i);
			if(id == pWidget->GetId()) {
				index++;
			}
		}
	}

	//Widget̐
	pWidget = NULL;
	try {
		pWidget = new CWidget (point, id, width, height);
		pItem = pWidget->GetPitem();
		if(!name) {
			pItem = pWidget->GetPitem();
			strcpy(blkname, pItem->name);
			if(index > 0) {
				sprintf(idname,"%d",index);
				strcat(blkname, idname);
			}
			pWidget->SetName(CString(blkname));
		}
		else
			pWidget->SetName(CString(name));
		pWidget->SetDirection( direction );
		pWidget->SetMatrix(matrix);
		if(pItem->inport != 0)
			pWidget->SetInportName(&(pItem->inpname));
		if(pItem->outport != 0)
			pWidget->SetOutportName(&(pItem->outpname));
		//p[^[
		prm = pWidget->GetParamPointer();
		prmCount = (int)prm->GetSize();
		for (i=0; i<prmCount; i++) {
			//PARAMINFO
			prmItem = (PARAMINFO*) prm->GetAt (i);
			prmItem->strValue = _T(strValue[i]);
		}
		//ScopeɃTCYݒ
		prm = pWidget->GetScopePointer();
		prmCount = (int)prm->GetSize();
		for (i=0; i<prmCount; i++) {
			//PARAMINFO
			scopeItem = (SCOPEINFO*) prm->GetAt (i);
			scopeItem->size = pWidget->GetCellRow() * pWidget->GetCellColumn();
		}

		// Widgetǉ
		// Subsystemǉ́At@Cǂݍ݂̏ꍇ͕KvȂ
		//if(id == M_SUBSYSTEM) {
		//	InitSubsystem(pWidget, pItem->inport, pItem->outport);
		//}

		//m_arrWidgetsɃW[ǉ
		nIndex = (int)pArrWidgets->Add (pWidget);	
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("AddWidget function:Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

BOOL CExtncsDoc::RemoveWidget(int nIndex)
{
	CLine* pLine;
	int i,nLine,sblk,eblk,junc;
	CPtrArray* pArrWidgets;
	CPtrArray* pArrLines;
	CWidget* pWidget;

	if(!m_pTargetWidget) {
		//rootVXe
		if (nIndex >= m_arrWidgets.GetSize ())
			return FALSE;

		// nIndexC݂΁Aɍ폜Ă
		nLine = (int)m_arrLines.GetSize();
		for (i=nLine - 1; i>=0 ; i--) {
			pLine = (CLine*) m_arrLines[i];
			if(pLine->GetSblk() == nIndex) {
				RemoveLine(i);
			}
			if(pLine->GetEblk() == nIndex) {
				RemoveLine(i);
			}
		}
		// nIndexȍ~sblkAeblkC͏C
		nLine = (int)m_arrLines.GetSize();
		for (i=0; i<nLine ; i++) {
			pLine = (CLine*) m_arrLines[i];
			if((sblk = pLine->GetSblk()) > nIndex) {
				pLine->SetSblk(sblk-1);
			}
			if((eblk = pLine->GetEblk()) > nIndex) {
				pLine->SetEblk(eblk-1);
			}
			//junction
			junc = pLine->GetJunction();
			if(junc != -1) {
				if(junc > nIndex)
					pLine->SetJunction(junc-1);
			}
		}


		//Ώۂ폜
		pWidget = m_arrWidgets[nIndex];
		if(pWidget->GetId() == M_SUBSYSTEM)
			SubDeleteContents(pWidget);
		delete m_arrWidgets[nIndex];
		m_arrWidgets.RemoveAt (nIndex);
	}
	else {
		//Subsystem
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();
		if (nIndex >= pArrWidgets->GetSize ())
			return FALSE;

		// nIndexC݂΁Aɍ폜Ă
		pArrLines = m_pTargetWidget->GetLinesPointer();
		nLine = (int)pArrLines->GetSize();
		for (i=nLine - 1; i>=0 ; i--) {
			pLine = (CLine*) pArrLines->GetAt(i);
			if(pLine->GetSblk() == nIndex) {
				RemoveLine(i);
			}
			if(pLine->GetEblk() == nIndex) {
				RemoveLine(i);
			}
		}
		// nIndexȍ~sblkAeblkC͏C
		nLine = (int)pArrLines->GetSize();
		for (i=0; i<nLine ; i++) {
			pLine = (CLine*) pArrLines->GetAt(i);
			if((sblk = pLine->GetSblk()) > nIndex) {
				pLine->SetSblk(sblk-1);
			}
			if((eblk = pLine->GetEblk()) > nIndex) {
				pLine->SetEblk(eblk-1);
			}
			//junction
			junc = pLine->GetJunction();
			if(junc != -1) {
				if(junc > nIndex)
					pLine->SetJunction(junc-1);
			}
		}


		//Ώۂ폜
		pWidget = (CWidget*)(pArrWidgets->GetAt(nIndex));
		if(pWidget->GetId() == M_SUBSYSTEM)
			SubDeleteContents(pWidget);
		delete (CWidget*)(pArrWidgets->GetAt(nIndex));
		pArrWidgets->RemoveAt (nIndex);
	}

	return TRUE;
}

// LineɊւ郁\bh
int CExtncsDoc::GetLineCount()
{
	if(!m_pTargetWidget)
		return (int)m_arrLines.GetSize ();
	else {
		CPtrArray* p;
		p = m_pTargetWidget->GetLinesPointer();
		return (int)p->GetSize();
	}
}

CLine* CExtncsDoc::GetLine(int nIndex)
{
	if(!m_pTargetWidget) {
		if (nIndex >= m_arrLines.GetSize ())
			return NULL;
		return (CLine*) m_arrLines[nIndex];
	}
	else {
		CPtrArray* p;
		p = m_pTargetWidget->GetLinesPointer();
		if (nIndex >= p->GetSize ())
			return NULL;
		return (CLine*) p->GetAt(nIndex);
	}
}

// Lineǉ
// type:`悷郉C̎
//		LINE_START,LINE_MID,LINE_END\
int CExtncsDoc::AddLine(CPoint spt, CPoint ept, int sidx, int eidx, COLORREF color, int arrow, int idx,
					   int inport, int outport, int type, int junc)
{
	int nIndex = -1,row;
	CLine* pLine = NULL;
	CWidget* pWidget;
	CPtrArray* pArrLines;

	//|[gݒ
	pWidget = GetWidget(sidx);
	pWidget->SetOutportLine(outport);
	pWidget = GetWidget(eidx);
	pWidget->SetInportLine(inport);
	// CLine쐬
	try {
		pLine = new CLine (spt, ept, sidx, eidx, color, arrow, idx,
			inport, outport, type, junc);
		if(!m_pTargetWidget) {
			//rootVXe
			nIndex = (int)m_arrLines.Add (pLine);
		}
		else {
			//Subsystem
			pArrLines = m_pTargetWidget->GetLinesPointer();
			nIndex = (int)pArrLines->Add(pLine);
		}
		//Line̓͐Widget𒲂ׂĕݒ
		pWidget = GetWidget(eidx);
		row = pWidget->GetCellRow();
		//column = pWidget->GetCellColumn();
		if(row > 1) {
			//gCELL̈̏ꍇ
			if(inport > 1)
				pLine->SetThickness( 1 );
			else
				pLine->SetThickness( 2 );
		}
		else
			pLine->SetThickness( 1 );
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("Out of memory"));
		if (pLine != NULL)
			delete pLine;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

// LinẽhbvɎgp
int CExtncsDoc::AtLine(int index, CPoint spt, CPoint ept, int sidx, int eidx, COLORREF color, int arrow, int idx,
					   int inport, int outport, int type, int junc)
{
	int row;
	CLine* pLine = NULL;
	CWidget* pWidget;
	CPtrArray* pArrLines;

	// CLine쐬
	try {
		pLine = new CLine (spt, ept, sidx, eidx, color, arrow, idx,
			inport, outport, type, junc);
		if(!m_pTargetWidget) {
			//rootVXe
			m_arrLines.InsertAt (index, pLine);
		}
		else {
			//Subsystem
			pArrLines = m_pTargetWidget->GetLinesPointer();
			pArrLines->InsertAt(index, pLine);
		}
		//Line̓͐Widget𒲂ׂĕݒ
		pWidget = GetWidget(eidx);
		row = pWidget->GetCellRow();
		//column = pWidget->GetCellColumn();
		if(row > 1) {
			//gCELL̈̏ꍇ
			if(inport > 1)
				pLine->SetThickness( 1 );
			else
				pLine->SetThickness( 2 );
		}
		else
			pLine->SetThickness( 1 );
		pLine->SetSel(TRUE);
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("Out of memory"));
		if (pLine != NULL)
			delete pLine;
		e->Delete ();
		return -1;
	}
	return index;
}

BOOL CExtncsDoc::RemoveLine(int nIndex)
{
	int widx,inport,outport;
	CWidget* pWidget;
	CLine* pLine;
	CPtrArray* pArrWidgets;
	CPtrArray* pArrLines;

	if(!m_pTargetWidget) {
		//rootVXe
		if (nIndex >= m_arrLines.GetSize ())
			return FALSE;

		//nIndexɊ֌WĂ郉CWidget̐ڑtONA
		pLine = (CLine*) m_arrLines[nIndex];
		//\[X
		widx = pLine->GetSblk();
		pWidget = (CWidget*) m_arrWidgets[widx];
		outport = pLine->GetOutport();
		if(outport != -1)
			pWidget->ResetOutportLine(outport);
		//fBXeBl[V
		widx = pLine->GetEblk();
		pWidget = (CWidget*) m_arrWidgets[widx];
		inport = pLine->GetInport();
		pWidget->ResetInportLine(inport);
		delete m_arrLines[nIndex];
		m_arrLines.RemoveAt (nIndex);
	}
	else {
		//Subsystem
		//|C^[ݒ
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();
		pArrLines = m_pTargetWidget->GetLinesPointer();
		//CfbNXmF
		if (nIndex >= pArrLines->GetSize ())
			return FALSE;

		//nIndexɊ֌WĂ郉CWidget̐ڑtONA
		pLine = (CLine*) pArrLines->GetAt(nIndex);
		//\[X
		widx = pLine->GetSblk();
		pWidget = (CWidget*) pArrWidgets->GetAt(widx);
		outport = pLine->GetOutport();
		if(outport != -1)
			pWidget->ResetOutportLine(outport);
		//fBXeBl[V
		widx = pLine->GetEblk();
		pWidget = (CWidget*) pArrWidgets->GetAt(widx);
		inport = pLine->GetInport();
		pWidget->ResetInportLine(inport);
		//폜
		delete (CLine*)(pArrLines->GetAt(nIndex));
		pArrLines->RemoveAt (nIndex);
	}
	return TRUE;
}

BOOL CExtncsDoc::RemoveLineAt(int nIndex)
{
	CLine* pLine;
	CPtrArray* pArrLines;

	if(!m_pTargetWidget) {
		//rootVXe
		if (nIndex >= m_arrLines.GetSize ())
			return FALSE;

		//nIndexɊ֌WĂ郉CWidget̐ڑtONA
		pLine = (CLine*) m_arrLines[nIndex];

		delete m_arrLines[nIndex];
		m_arrLines.RemoveAt (nIndex);
	}
	else {
		//Subsystem
		if (nIndex >= m_arrLines.GetSize ())
			return FALSE;

		//nIndexɊ֌WĂ郉CWidget̐ڑtONA
		pArrLines = m_pTargetWidget->GetLinesPointer();
		pLine = (CLine*) pArrLines->GetAt(nIndex);

		delete (CLine*)(pArrLines->GetAt(nIndex));
		pArrLines->RemoveAt (nIndex);
	}
	return TRUE;
}

// CExtncsViewĂ΂
BOOL CExtncsDoc::InsertWidget(int id, CPoint point) 
{
	//idŎw肳ꂽW[͐
	BLOCKINFO* pInfo;
	char path[_MAX_PATH],fname[_MAX_PATH];
	if(id > M_DA3305) {
		pInfo =  (BLOCKINFO*) g_pExtncsMain->m_blockArray.GetAt (id);
		if(pInfo->model.GetLength() == 0)
			return FALSE;
		if(Access(pInfo->model, SL_FATTR_FOK) != 0){
			return FALSE;
		}
		if(pInfo->fBitmap.GetLength() == 0)
			return FALSE;
		GetModuleDirectory(path, _MAX_PATH);
		sprintf(fname, "%s\\ncs\\bmp\\%s", path,pInfo->fBitmap);
		if(Access(fname, SL_FATTR_FOK) != 0){
			return FALSE;
		}
	}

	if(!m_pTargetWidget) {
		//rootVXe
		AddWidget(id, point, NULL, DIR_RIGHT, CString(_T("1:1")), 32, 32);
	}
	else {
		//Subsystem
		AddSubWidget(m_pTargetWidget, id, point, NULL, DIR_RIGHT, CString(_T("1:1")), 32, 32);
	}

	UpdateAllViews (NULL);
	return TRUE;
}

// CExtncsViewĂ΂
// M_GAPM_SYNAPSEindexŎw肵Lineɐݒ肷
void CExtncsDoc::InsertWidgetJunc(int id, CPoint point, int index, int type) 
{
	int nCount,i,ncell,eblk;
	CLine* pLine;
	CPoint mpt,spt,ept;
	CWidget* pWidget;
	CPtrArray* pArrWidgets;
	CPtrArray* pArrLines;

	//Subsystemŏ
	if(m_pTargetWidget) {
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();
		pArrLines = m_pTargetWidget->GetLinesPointer();
	}

	mpt = point;
	if(!m_pTargetWidget)
		nCount = (int)m_arrLines.GetSize();
	else
		nCount = (int)pArrLines->GetSize();

	for(i = 0; i < nCount; i++) {
		if(!m_pTargetWidget)
			pLine = m_arrLines.GetAt(i);
		else
			pLine = (CLine*)pArrLines->GetAt(i);
		if(index == pLine->GetIndex()) {
			//W[̏oɔzu
			//if(pLine->GetType() == LINE_START) {
			//	spt = pLine->GetSpos();
			//	ept = pLine->GetEpos();
			//	if(spt.x == ept.x)
			//		mpt = CPoint(spt.x-8, spt.y+(ept.y-spt.y)/2-8);
			//	else
			//		mpt = CPoint(spt.x+(ept.x-spt.x)/2-8, spt.y);
			//}
			//W[̓ɔzu
			if(pLine->GetType() == LINE_STOP) {
				spt = pLine->GetSpos();
				ept = pLine->GetEpos();
				if(spt.x == ept.x)
					mpt = CPoint(ept.x-8, ept.y-8);
				else
					mpt = CPoint(spt.x+(ept.x-spt.x)/2-8, ept.y);
			}
		}
	}
	if(!m_pTargetWidget) {
		ncell = AddWidget(id, mpt/*point*/, NULL, DIR_RIGHT, CString(_T("1:1")), 16, 16/*32, 32*/);
		pWidget = (CWidget*) m_arrWidgets[ncell];
		pWidget->SetType(type);
	}
	else {
		ncell = AddSubWidget(m_pTargetWidget, id, mpt/*point*/, NULL, DIR_RIGHT, CString(_T("1:1")), 16, 16/*32, 32*/);
		pWidget = (CWidget*) pArrWidgets->GetAt(ncell);
		pWidget->SetType(type);
	}

	//desLinejunctionݒ
	//1 indexCeblk𓾂
	eblk = -1;
	for(i = 0; i < nCount; i++) {
		if(!m_pTargetWidget)
			pLine = m_arrLines.GetAt(i);
		else
			pLine = (CLine*)pArrLines->GetAt(i);
		if(index == pLine->GetIndex()) {
			eblk = pLine->GetEblk();
			break;
		}
	}

	if(eblk == -1) {
		// Error
	}
	else {
		for(i = 0; i < nCount; i++) {
			if(!m_pTargetWidget)
				pLine = m_arrLines.GetAt(i);
			else
				pLine = (CLine*)pArrLines->GetAt(i);
			if(eblk == pLine->GetEblk()) {
				pLine->SetJunction(ncell);
			}
		}
	}

	//XV
	UpdateAllViews (NULL);

}

// Line->WidgetԐڑ̂CExtncsViewĂ΂
// CRect\̂nĕ`悷
// gݍ킹ɑΉ
// juncInit́A-1ŌĂяo
void CExtncsDoc::InsertDivide(CRect rect, int sel, int sidx, int eidx, int inport, int juncInit/*-1*/) 
{
	CPoint spos,epos;
	int type,junc;
	CWidget *pEWidget/*,*pSWidget*/;
	int	edir;
	CLine *pLine;
	CPtrArray* pArrWidgets;
	CPtrArray* pArrLines;

	//Subsystemŏ邽
	if(m_pTargetWidget) {
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();
		pArrLines = m_pTargetWidget->GetLinesPointer();
	}

	//1.junc𐶐
	//sidxCjuncĂ
	junc = juncInit;

	//junćAeidxɕt̂ō폜
	//nLine = GetLineCount();
	//for(i = 0; i < nLine; i++) {
	//	pLine = GetLine(i);
	//	if(sidx == pLine->GetSblk()) {
	//		junc = pLine->GetJunction();
	//		break;
	//	}
	//}

	//2.
	if(sel == VERT_LINE || sel == HORZ_LINE) {
		//Widgetړ̏
		type = sel;
		if(!m_pTargetWidget)
			pEWidget = (CWidget*) m_arrWidgets[eidx];
		else
			pEWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		//|[g
		pEWidget->SetInportLine(inport);
		edir = pEWidget->GetDirection();
	}
	else {
		if(!m_pTargetWidget) {
			pLine = (CLine*) m_arrLines[sel];
			pEWidget = (CWidget*) m_arrWidgets[eidx];
		}
		else {
			pLine = (CLine*) pArrLines->GetAt(sel);
			pEWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		}
		//|[g
		pEWidget->SetInportLine(inport);
		edir = pEWidget->GetDirection();
		spos = pLine->GetSpos();
		epos = pLine->GetEpos();
		//CC̔
		if(spos.x == epos.x)
			type = VERT_LINE;
		else
			type = HORZ_LINE;
	}
	if(type == HORZ_LINE) {	//CJn
		switch(edir) {
		case	DIR_RIGHT:
			InsertDivideHR(rect, sidx, eidx, inport, junc);	break;
		case	DIR_UP:
			InsertDivideHU(rect, sidx, eidx, inport, junc);	break;
		case	DIR_LEFT:
			InsertDivideHL(rect, sidx, eidx, inport, junc);	break;
		case	DIR_DOWN:
			InsertDivideHD(rect, sidx, eidx, inport, junc);	break;
		}
	}
	else {
		switch(edir) {
		case	DIR_RIGHT:
			InsertDivideVR(rect, sidx, eidx, inport, junc);	break;
		case	DIR_UP:
			InsertDivideVU(rect, sidx, eidx, inport, junc);	break;
		case	DIR_LEFT:
			InsertDivideVL(rect, sidx, eidx, inport, junc);	break;
		case	DIR_DOWN:
			InsertDivideVD(rect, sidx, eidx, inport, junc);	break;
		}
	}

}

// Widget->WidgetԐڑ̂CExtncsViewĂ΂
// CRect\̂nĕ`悷
// sidx:	oWidget
// eidx:	Widget
// inport:	Widget|[gԍ
// outport: oWidget|[gԍ
// gݍ킹ɑΉ
void CExtncsDoc::InsertLine(CRect rect, int sidx, int eidx, int inport, int outport, int junc) 
{
	CWidget *pWidget;
	int	sdir,edir,sypos,dypos,srow,scolumn,drow,dcolumn;
	CRect mrect;
	BOOL flag;
	int src_style,des_style;
	CPtrArray* pArrWidgets;

	if(!m_pTargetWidget) {
		//rootVXe
		// Source
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sdir = pWidget->GetDirection();
		mrect = pWidget->GetRect();
		sypos = mrect.top + mrect.Height()/2;
		srow = pWidget->GetCellRow();
		scolumn = pWidget->GetCellColumn();
		// Destination
		pWidget = (CWidget*) m_arrWidgets[eidx];
		edir = pWidget->GetDirection();
		mrect = pWidget->GetRect();
		dypos = mrect.top + mrect.Height()/2;
		drow = pWidget->GetCellRow();
		dcolumn = pWidget->GetCellColumn();
	}
	else {
		//Subsystem
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();
		// Source
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sdir = pWidget->GetDirection();
		mrect = pWidget->GetRect();
		sypos = mrect.top + mrect.Height()/2;
		srow = pWidget->GetCellRow();
		scolumn = pWidget->GetCellColumn();
		// Destination
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		edir = pWidget->GetDirection();
		mrect = pWidget->GetRect();
		dypos = mrect.top + mrect.Height()/2;
		drow = pWidget->GetCellRow();
		dcolumn = pWidget->GetCellColumn();
	}

	//Line`FbN
	src_style =	GetCellStyle(srow, scolumn); 
	des_style =	GetCellStyle(drow, dcolumn);
	//ڑ`FbN
	flag = TRUE;
	switch(src_style) {
	case	SINGLE_CELL:
		// singleZ͂SẴZɓ̂ŖȂ
		break;
	case	COLUMN_CELL:	// columnZ
		if(outport == 1) {
			//ŏIZSẴZɌ
		}
		else {
			//CELLSẴZɌ
		}
		break;
	case	ROW_CELL:	// rowZ
		if(outport == 1) {
			switch(des_style) {
			case	SINGLE_CELL:
				flag = FALSE;	//֎~
				break;
			case	COLUMN_CELL:
				flag = FALSE;	//֎~
				return;
			case	ROW_CELL:
				//cellv΂悢
				if(inport == 1) {
					if(srow != drow)
						flag = FALSE;
				}
				else
					flag = FALSE;
				break;
			case	MATRIX_CELL:
				flag = FALSE;
				break;
			}
		}
		else {
			//ZSẴZɌ
		}
		break;
	case	MATRIX_CELL:	// matrixZ
		if(outport == 1) {
			switch(des_style) {
			case	SINGLE_CELL:
				flag = FALSE;
				break;
			case	COLUMN_CELL:
				flag = FALSE;
				break;
			case	ROW_CELL:
				flag = FALSE;
				break;
			case	MATRIX_CELL:
				if(inport == 1) {
					if(srow != drow || scolumn != dcolumn)
						flag = FALSE;
				}
				else
					flag = FALSE;
				break;
			}
		}
		else {
			//ZSẴZɌ
		}
		break;
	}
	//bZ[W
	if(!flag) {
		//AfxMessageBox("Connection inhibited.", MB_OK, NULL);
		CExtncsView* pView = (CExtncsView*)GetExtncsView();
		pView->MessageBox("Connection inhibited.", "Extncs", MB_OK | MB_ICONERROR);
		return;
	}


	//directionɉLine`
	switch(sdir) {
	case	DIR_RIGHT:
		switch(edir) {
		case	DIR_RIGHT:
			// Right -> Right
			if(src_style == SINGLE_CELL && des_style == SINGLE_CELL)
				InsertLineRR(rect, sidx, eidx, inport, outport, junc);
			else if(src_style == SINGLE_CELL && des_style > SINGLE_CELL) {
				//des_styleɂ
				if(des_style == COLUMN_CELL) {
					if(inport > 1) {
						if(sypos > dypos)
							InsertLineRU(rect, sidx, eidx, inport, outport, junc);
						else
							InsertLineRD(rect, sidx, eidx, inport, outport, junc);
					}
					else
						InsertLineRR(rect, sidx, eidx, inport, outport, junc);
				}
				else
					InsertLineRR(rect, sidx, eidx, inport, outport, junc);
			}
			else if(src_style > SINGLE_CELL && des_style == SINGLE_CELL) {
				if(srow == 1 && outport > 1) {
					//Column->Single
					if(sypos > dypos)
						InsertLineUR(rect, sidx, eidx, inport, outport, junc);
					else
						InsertLineDR(rect, sidx, eidx, inport, outport, junc);
				}
				else
					InsertLineRR(rect, sidx, eidx, inport, outport, junc);
			}
			else {
				InsertLineRR(rect, sidx, eidx, inport, outport, junc);
			}
			break;
		case	DIR_UP:
			InsertLineRU(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_LEFT:
			InsertLineRL(rect, sidx, eidx, inport, outport, junc);	break;
		case	DIR_DOWN:
			InsertLineRD(rect, sidx, eidx, inport, outport, junc);	break;
		}
		break;
	case	DIR_UP:
		switch(edir) {
		case	DIR_RIGHT:
			InsertLineUR(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_UP:
			InsertLineUU(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_LEFT:
			InsertLineUL(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_DOWN:
			InsertLineUD(rect, sidx, eidx, inport, outport, junc);
			break;
		}
		break;
	case	DIR_LEFT:
		switch(edir) {
		case	DIR_RIGHT:
			InsertLineLR(rect, sidx, eidx, inport, outport, junc);	break;
		case	DIR_UP:
			InsertLineLU(rect, sidx, eidx, inport, outport, junc);	break;
		case	DIR_LEFT:
			InsertLineLL(rect, sidx, eidx, inport, outport, junc);	break;
		case	DIR_DOWN:
			InsertLineLD(rect, sidx, eidx, inport, outport, junc);	break;
		}
		break;
	case	DIR_DOWN:
		switch(edir) {
		case	DIR_RIGHT:
			InsertLineDR(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_UP:
			InsertLineDU(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_LEFT:
			InsertLineDL(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_DOWN:
			InsertLineDD(rect, sidx, eidx, inport, outport, junc);
			break;
		}
		break;
	}
}

void CExtncsDoc::OnFileNew() 
{
	int i,siz,j,nCount;
	BLOCKINFO* pInfo;
	NAMEINFO* nInfo;

	// JĂEBhE
	CExtncsView* pView = (CExtncsView*)GetExtncsView();
	pView->AllDestroyWindow();

	// WidgetsLines폜
	DeleteContents();
	// WubNȊO͍폜
	nCount = (int)g_pExtncsMain->m_blockArray.GetSize();
	for(i = g_pExtncsMain->m_nDefaultSize; i < nCount; i++) {
		pInfo =  (BLOCKINFO*) g_pExtncsMain->m_blockArray.GetAt (i);
		siz = (int)pInfo->inpname.GetSize();
		if(siz) {
			for(j = 0; j < siz; j++) {
				nInfo =  (NAMEINFO*) pInfo->inpname.GetAt (j);
				delete nInfo;
			}
			pInfo->inpname.RemoveAll();
		}
		siz = (int)pInfo->outpname.GetSize();
		if(siz) {
			for(j = 0; j < siz; j++) {
				nInfo =  (NAMEINFO*) pInfo->outpname.GetAt (j);
				delete nInfo;
			}
			pInfo->outpname.RemoveAll();
		}
		delete pInfo;
		g_pExtncsMain->m_blockArray.RemoveAt (i);
	}
	nCount = (int)g_pExtncsMain->m_blockArray.GetSize();
	//ĕ`
	UpdateAllViews (NULL);
	//Title
	char title[_MAX_PATH];
	strcpy(title, "Extncs : untitled.sig");
	g_pExtncsMain->m_pExtncsWnd->SendMessage(WM_SETTEXT,0,(LPARAM)title);
	//COutViewConsoleView
	//g_pExtncsMain->m_pOutView->AllClear();
	m_bCodeGen = FALSE;
	m_bCodeCompile = FALSE;
	//LineJEglNA
	m_nLineIndex = 0;

}

void CExtncsDoc::OnUpdateFileNew(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CExtncsDoc::OnFileOpen() 
{
	//sigf݂ꍇ
	//if(m_arrWidgets.GetSize () > 0) {
	//	OnFileNew();
	//}

	//CString ExtncsName;
	char	ExtncsPathName[_MAX_PATH];
	LPCSTR	lpszFilter;
	CString fileName;

	strcpy(ExtncsPathName, "");
	lpszFilter = "Extncs model (*.sig) | *.sig||";
	CFileDialog	dlgFile(TRUE, ".sig",ExtncsPathName,OFN_HIDEREADONLY,lpszFilter);
	dlgFile.m_ofn.lpstrTitle = "fI";
	dlgFile.m_ofn.lpstrInitialDir = _getcwd(ExtncsPathName, _MAX_PATH);
	if(dlgFile.DoModal() == IDOK) {
		//sigf݂ꍇ
		if(m_arrWidgets.GetSize () > 0) {
			OnFileNew();
		}
		// Model path
		m_ExtncsName = dlgFile.GetPathName();
		// Sigf
		fileName = dlgFile.GetFileName();
		m_ModelName = fileName;
		strcpy(ExtncsPathName, m_ExtncsName);
		// Load
		DeleteContents();
		LoadExtncsModel(ExtncsPathName);
		//[hCodeCompiletOZbgł邪A
		//ÃfexeŐV̏ꍇ́ARpCς݂Ƃď
		if(CheckLatest(ExtncsPathName)) {
			m_bCodeGen = TRUE;
			m_bCodeCompile = TRUE;
		}
		else {
			m_bCodeGen = FALSE;
			m_bCodeCompile = FALSE;
		}
		//^CgύX
//TODO:΍
		char title[_MAX_PATH];
		sprintf(title, "Extncs : %s", fileName);
		g_pExtncsMain->m_pExtncsWnd->SendMessage(WM_SETTEXT,0,(LPARAM)title);
		//TreẽgbvύX
		UpdateAllViews(NULL, 0x6B, (CObject*) (LPCTSTR)m_ModelName);
		//ύXȂ
		SetModifiedFlag(FALSE);
	}
}

void CExtncsDoc::OnUpdateFileOpen(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

BOOL CExtncsDoc::CheckLatest(char *openfile)
{
	CString model,target;
	//CFile cfile;
	CFileStatus status;
	int pos;
	CTime exeTime, targetTime;

	model = _T(openfile);
	pos = model.Find(".sig");
	if(pos == -1)
		return FALSE;
	model = model.Left(pos);

	//exet@C
	target = model + _T(".exe");
	if(!CFile::GetStatus( target, status )) {
		//exe݂Ȃ
		return FALSE;
	}
	exeTime = status.m_mtime;

	//sigt@Ccheck
	target = model + _T(".sig");
	if(!CFile::GetStatus( target, status ))
		return FALSE;
	targetTime = status.m_mtime;
	if(exeTime.GetTime() < targetTime.GetTime()) {
		//exesiĝقV
		return FALSE;
	}

	//mdlt@Ccheck
	target = model + _T(".mdl");
	if(!CFile::GetStatus( target, status ))
		return FALSE;
	targetTime = status.m_mtime;
	if(exeTime.GetTime() < targetTime.GetTime()) {
		//exemdl̂قV
		return FALSE;
	}


	return TRUE;
}

// Sigf[h
BOOL CExtncsDoc::LoadExtncsModel(char *openfile)
{
	FILE *fp;
	int	xs,ys,xe,ye,sblk,eblk,arrow,id,idx,cx,cy;
	CPoint spos,epos;
	char linebuf[_MAX_PATH],modelpath[_MAX_PATH];
	long color;
	char name[128];
	char tmp[128];
	int direction,inport,outport,type,connect,junction;
	int i,j,nParam;
	char strValue[100][16];
	int pos;
	CString matrix,str,strRight;
	int nIndex,row,column,nSize,nWidget,nLine;
	CWidget* pWidget;
	CExtncsView* pView;
	CWidget* pSaveWidget;

	if((fp = fopen(openfile, "r")) == NULL)
		return FALSE;
	// root
	fgets(linebuf, _MAX_PATH, fp);	//{ /* Begin root */
	fgets(linebuf, _MAX_PATH, fp);	//{ /* Begin widget */
	fgets(linebuf, _MAX_PATH, fp);
	sscanf(linebuf, "%d", &nWidget);	// widgets
	for(i = 0; i < nWidget; i++) {	// nSizewidgetǂ
		fgets(linebuf, _MAX_PATH, fp); //{ /* Begin widget */
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d %d %d %d", &xs, &ys, &cx, &cy);
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d", &id);
		//idgW[̏ꍇւ̑ΉAnSizéAWW[
		nSize = (int)g_pExtncsMain->m_blockArray.GetSize();
		if(id >= nSize) {
			//NCSfpX̎擾
			fgets(linebuf, _MAX_PATH, fp);
			linebuf[strlen(linebuf)-1] = '\0';
			strcpy(modelpath, linebuf);
		}
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%s", name);
		if(id >= nSize) {
			//m_blockArrayɊgW[o^
			id = g_pExtncsMain->SetBlockDataAppend(modelpath, name, MODULE_NCS, -1);
		}
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d", &direction);
		fgets(linebuf, _MAX_PATH, fp);
		linebuf[strlen(linebuf)-1] = '\0';
		matrix = _T(linebuf);
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d %d", &inport, &outport);
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d %d", &connect, &junction);
		spos.x = xs; spos.y = ys;
		//p[^[
		fgets(linebuf, _MAX_PATH, fp);	// { Begin parameter
		fgets(linebuf, _MAX_PATH, fp);	// p[^[
		sscanf(linebuf, "%d", &nParam);
		if(nParam > 0) {
			for(j = 0; j < nParam; j++) {
				fgets(linebuf, _MAX_PATH, fp);
				linebuf[strlen(linebuf)-1] = '\0';
				//lo
				str = _T(linebuf);
				pos = str.Find(_T("= "));
				strRight = str.Mid(pos+2);
				strcpy(strValue[j], strRight);
			}
		}
		fgets(linebuf, _MAX_PATH, fp);	// } End parameter
		//Widget
		//gCELLɑΉ邽߁Amatrixl傫ɂ
		row = GetMatrixRow(matrix);
		column = GetMatrixColumn(matrix);
		cx = cx / column;
		cy = cy / row;
		if(nParam > 0) {
			nIndex = AddWidget2(id, spos, NULL, direction, matrix, nParam, strValue, cx, cy);
		}
		else {
			nIndex = AddWidget(id, spos, NULL, direction, matrix, cx, cy);
		}
		//o̓|[g
		pWidget = (CWidget*) m_arrWidgets[nIndex];
		pWidget->SetInport(inport);		//|[g
		pWidget->ChangeInportName();
		pWidget->SetOutport(outport);
		pWidget->ChangeOutportName();
		//Name
		pWidget->SetName(_T(name));
		// XyW[ɊւĕύXKv
		if(id == M_XY) {
			pWidget->ChangeXyScope();
		}
		//gCELL
		pWidget->SetConnect(connect);
		pWidget->SetJunction(junction);
		//Scope
		if(LoadExtncsModelScope(fp, m_arrWidgets.GetAt(nIndex))) {
			//ScopeJ
			pView = (CExtncsView*)GetExtncsView();
			//TODO:f[hɊJ
			//pView->OpenScope(pWidget);
		}
		//Subsystem
		if(id == M_SUBSYSTEM) {
			UpdateAllViews(NULL, 0x6A);
			pSaveWidget = m_pTargetWidget;
			m_pTargetWidget = m_arrWidgets.GetAt(nIndex);
			LoadExtncsModelSubsystem(fp, m_arrWidgets.GetAt(nIndex));
			m_pTargetWidget = pSaveWidget;
		}
		fgets(linebuf, _MAX_PATH, fp); //} /* Begin widget */
	}
	fgets(linebuf, _MAX_PATH, fp);	//} /* End widget */

	// lineɊւ
	fgets(linebuf, _MAX_PATH, fp);	//{ /* Begin line */
	fgets(linebuf, _MAX_PATH, fp);
	sscanf(linebuf, "%d", &nLine);	// widgets
	for(i = 0; i < nLine; i++) {
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d %d %d %d %d %d %ld %d %d %d %d %d %d", &xs, &ys, &xe, &ye,
					&sblk, &eblk, &color, &arrow, &idx, &inport, &outport, &type, &junction);
		spos.x = xs; spos.y = ys;
		epos.x = xe; epos.y = ye;
		AddLine(spos, epos, sblk, eblk, color, arrow, idx, inport, outport, type, junction);
		if(!m_pTargetWidget)
			m_nLineIndex += 1;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	fgets(linebuf, _MAX_PATH, fp);	//} /* End line */
	fgets(linebuf, _MAX_PATH, fp);	//} /* End root */

	//V~[V
	fgets(linebuf, _MAX_PATH, fp);	// { /* Begin simulation */
	fgets(linebuf, _MAX_PATH, fp);
	sscanf(linebuf, "%s", tmp);
	m_strTime = _T(tmp);
	fgets(linebuf, _MAX_PATH, fp);
	sscanf(linebuf, "%s", tmp);
	m_strStep = _T(tmp);
	fgets(linebuf, _MAX_PATH, fp);
	sscanf(linebuf, "%s", tmp);
	m_strSave = _T(tmp);
	fgets(linebuf, _MAX_PATH, fp);
	sscanf(linebuf, "%d", &m_nInteg);
	fgets(linebuf, _MAX_PATH, fp);
	sscanf(linebuf, "%d", &m_bRtmode);
	fgets(linebuf, _MAX_PATH, fp);	// } /* End simulation */

	fclose(fp);
	return TRUE;
}

//Scopeݒ
BOOL CExtncsDoc::LoadExtncsModelScope(FILE *fp, CWidget *pWidget)
{
	char	linebuf[_MAX_PATH];
	int		sel,index;
	long	offset;
	CPtrArray*	p;
	SCOPEINFO *pItem;

	//Scope|C^[
	p = pWidget->GetScopePointer();
	// ^O
	fgets(linebuf, _MAX_PATH, fp);	// "Begin scope"
	// Open
	fgets(linebuf, _MAX_PATH, fp);
	linebuf[strlen(linebuf)-1] = '\0';
	sel = atoi(linebuf);
	if(sel) {
		while(!feof(fp)) {
			//fprintf(fp,"%d\n",i);
			if(fgets(linebuf, _MAX_PATH, fp) == NULL)
				break;
			if(strstr(linebuf, "}") != NULL)
				break;
			//Index
			linebuf[strlen(linebuf)-1] = '\0';
			index = atoi(linebuf);
			pItem = (SCOPEINFO*) p->GetAt (index);
			//pItem->visible
			pItem->visible = TRUE;
			//pItem->strVmax;
			fgets(linebuf, _MAX_PATH, fp);
			linebuf[strlen(linebuf)-1] = '\0';
			pItem->strVmax = _T(linebuf);
			//pItem->strVmin;
			fgets(linebuf, _MAX_PATH, fp);
			linebuf[strlen(linebuf)-1] = '\0';
			pItem->strVmin = _T(linebuf);
			//pItem->strHmax;
			fgets(linebuf, _MAX_PATH, fp);
			linebuf[strlen(linebuf)-1] = '\0';
			pItem->strHmax = _T(linebuf);
			//pItem->strVunit;
			fgets(linebuf, _MAX_PATH, fp);
			linebuf[strlen(linebuf)-1] = '\0';
			pItem->strVunit = _T(linebuf);
			//pItem->strHunit;
			fgets(linebuf, _MAX_PATH, fp);
			linebuf[strlen(linebuf)-1] = '\0';
			pItem->strHunit = _T(linebuf);
			//pItem->strTs
			fgets(linebuf, _MAX_PATH, fp);
			linebuf[strlen(linebuf)-1] = '\0';
			pItem->strTs = _T(linebuf);
			//pItem->strTe
			fgets(linebuf, _MAX_PATH, fp);
			linebuf[strlen(linebuf)-1] = '\0';
			pItem->strTe = _T(linebuf);
			//pItem->strTime
			fgets(linebuf, _MAX_PATH, fp);
			linebuf[strlen(linebuf)-1] = '\0';
			pItem->strTime = _T(linebuf);
		}
		// ߂
		offset = (long)strlen( linebuf ) + 1;
		fseek(fp, -offset, SEEK_CUR);
	}
	//^O
	fgets(linebuf, _MAX_PATH, fp);	//End scope
	return sel;
}

//Subsystem̏ꍇ
void CExtncsDoc::LoadExtncsModelSubsystem(FILE *fp, CWidget *pTargetWidget)
{
	char		linebuf[_MAX_PATH],modelpath[_MAX_PATH];
	char		name[128];
	int			i, j, nParam,xs,ys,id,direction,xe,ye,cx,cy;
	int			sblk,eblk,arrow,idx,junction,pos,row,column,nIndex;
	int			nSize,nWidget,nLine,inport,outport,type,connect;
	CPoint		spos,epos;
	CString		str,strRight,matrix,pparam[MAX_PARAM];
	COLORREF	color;
	char strValue[100][16];
	CExtncsView* pView;
	CWidget* pWidget;
	CWidget* pSaveWidget = pTargetWidget;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();

	fgets(linebuf, _MAX_PATH, fp);		//{ /* Begin system */
	fgets(linebuf, _MAX_PATH, fp);		//{ /* Begin widget */
	fgets(linebuf, _MAX_PATH, fp);
	sscanf(linebuf, "%d", &nWidget);	// widgets
	for(i = 0; i < nWidget; i++) {	// nSizewidgetǂ
		fgets(linebuf, _MAX_PATH, fp); //{ /* Begin widget */
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d %d %d %d", &xs, &ys, &cx, &cy);
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d", &id);
		//idgW[̏ꍇւ̑ΉAnSizéAWW[
		nSize = (int)g_pExtncsMain->m_blockArray.GetSize();
		if(id >= nSize) {
			//NCSfpX̎擾
			fgets(linebuf, _MAX_PATH, fp);
			linebuf[strlen(linebuf)-1] = '\0';
			strcpy(modelpath, linebuf);
		}
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%s", name);
		if(id >= nSize) {
			//m_blockArrayɊgW[o^
			id = g_pExtncsMain->SetBlockDataAppend(modelpath, name, MODULE_NCS, -1);
		}
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d", &direction);
		fgets(linebuf, _MAX_PATH, fp);
		linebuf[strlen(linebuf)-1] = '\0';
		matrix = _T(linebuf);
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d %d", &inport, &outport);
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d %d", &connect, &junction);
		spos.x = xs; spos.y = ys;
		//p[^[
		fgets(linebuf, _MAX_PATH, fp);	// { Begin parameter
		fgets(linebuf, _MAX_PATH, fp);	// p[^[
		sscanf(linebuf, "%d", &nParam);
		if(nParam > 0) {
			for(j = 0; j < nParam; j++) {
				fgets(linebuf, _MAX_PATH, fp);
				linebuf[strlen(linebuf)-1] = '\0';
				//lo
				str = _T(linebuf);
				pos = str.Find(_T("= "));
				strRight = str.Mid(pos+2);
				strcpy(strValue[j], strRight);
			}
		}
		fgets(linebuf, _MAX_PATH, fp);	// } End parameter
		//Widget
		//gCELLɑΉ邽߁Amatrixl傫ɂ
		row = GetMatrixRow(matrix);
		column = GetMatrixColumn(matrix);
		cx = cx / column;
		cy = cy / row;
		if(nParam > 0) {
			nIndex = AddSubWidget2(pTargetWidget, id, spos, NULL, direction, matrix, nParam, strValue, cx, cy);
		}
		else {
			nIndex = AddSubWidget(pTargetWidget, id, spos, NULL, direction, matrix, cx, cy);
		}
		//o̓|[g
		pWidget = (CWidget*) pArrWidgets->GetAt(nIndex);
		pWidget->SetInport(inport);		//|[g
		pWidget->ChangeInportName();
		pWidget->SetOutport(outport);
		pWidget->ChangeOutportName();
		//Name
		pWidget->SetName(_T(name));
		// XyW[ɊւĕύXKv
		if(id == M_XY) {
			pWidget->ChangeXyScope();
		}
		//gCELL
		pWidget->SetConnect(connect);
		pWidget->SetJunction(junction);
		//Scope
		if(LoadExtncsModelScope(fp, pTargetWidget)) {
			//ScopeJ
			pView = (CExtncsView*)GetExtncsView();
			//TODO:f[hɊJ
			//pView->OpenScope(pTargetWidget);
		}
		//Subsystem
		if(id == M_SUBSYSTEM) {
			//Subsystem̐eZNgĂKv
			//ExtncsTree̍XV
			UpdateAllViews(NULL, 0x6C, m_pTargetWidget);
			pSaveWidget = m_pTargetWidget;
			m_pTargetWidget = pWidget;
			LoadExtncsModelSubsystem(fp, pWidget);
			m_pTargetWidget = pSaveWidget;
		}
		fgets(linebuf, _MAX_PATH, fp); //} /* Begin widget */
	}
	fgets(linebuf, _MAX_PATH, fp);	//} /* End widget */

	// lineɊւ
	fgets(linebuf, _MAX_PATH, fp);	//{ /* Begin line */
	fgets(linebuf, _MAX_PATH, fp);
	sscanf(linebuf, "%d", &nLine);	// C
	for(i = 0; i < nLine; i++) {
		fgets(linebuf, _MAX_PATH, fp);
		sscanf(linebuf, "%d %d %d %d %d %d %ld %d %d %d %d %d %d", &xs, &ys, &xe, &ye,
					&sblk, &eblk, &color, &arrow, &idx, &inport, &outport, &type, &junction);
		spos.x = xs; spos.y = ys;
		epos.x = xe; epos.y = ye;
		AddLine(spos, epos, sblk, eblk, color, arrow, idx, inport, outport, type, junction);
		pTargetWidget->IncLineIndex(1);
	}
	fgets(linebuf, _MAX_PATH, fp);	//} /* End line */
	fgets(linebuf, _MAX_PATH, fp);	//} /* End subsystem */
}

//TODO
//gp@`FbN
void CExtncsDoc::AddSubsysWidget(CWidget* pWidget, int xs, int ys, int id, CString name,
				int direction, CString matrix, int inport, int outport, int nparam, CString pparam[])
{
	//Xgɓo^
	CPtrArray*	pSubWidgets;
	SUBSYSWIDGET* pItem;
	int i,nCount;

	//Widgetm_subsysWidgetsǂ
	pSubWidgets = pWidget->GetSubsysWidgets();
	try {
		pItem = new SUBSYSWIDGET;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return;
	}
	//@ݒ
	pItem->xs = xs;
	pItem->ys = ys;
	pItem->id = id;
	pItem->name = name;
	pItem->direction = direction;
	pItem->matrix = matrix;
	pItem->inport = inport;
	pItem->outport = outport;
	pItem->nparam = nparam;
	for(i = 0; i < nparam; i++)
		pItem->pparam[i] = pparam[i];

	//CfbNX
	nCount = (int)pSubWidgets->GetSize();
	//o^
	pSubWidgets->InsertAt( nCount, pItem );
}

//TODO
//gp@`FbN
void CExtncsDoc::AddSubsysLine(CWidget* pWidget, CPoint spos, CPoint epos, int sblk, int eblk,
				COLORREF color, int arrow, int idx, int inport, int outport, int type, int junc)
{
	//Xgɓo^
	CPtrArray*	pSubLines;
	SUBSYSLINE* pItem;
	int nCount;

	//Widgetm_subsysLinesǂ
	pSubLines = pWidget->GetSubsysLines();
	try {
		pItem = new SUBSYSLINE;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return;
	}
	//@ݒ
	pItem->spos = spos;
	pItem->epos = epos;
	pItem->sblk = sblk;
	pItem->eblk = eblk;
	pItem->color = color;
	pItem->arrow = arrow;
	pItem->index = idx;
	pItem->inport = inport;
	pItem->outport = outport;
	pItem->type = type;
	pItem->junction = junc;
	//CfbNX
	nCount = (int)pSubLines->GetSize();
	//o^
	pSubLines->InsertAt( nCount, pItem );
}

void CExtncsDoc::SetLine(CWidget *pWidget, CString list) 
{
	//Xgɓo^
	CPtrArray*	pSubsys;
	SUBSYSINFO* pItem;
	int nCount;

	//Widgetm_subsysPtrǂ
	pSubsys = pWidget->GetSubsysPointer();
	try {
		pItem = new SUBSYSINFO;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return;
	}
	//@ݒ
	pItem->strList = list;
	//CfbNX
	nCount = (int)pSubsys->GetSize();
	//o^
	pSubsys->InsertAt( nCount, pItem );
}

void CExtncsDoc::OnFileSave() 
{
	FileSave();
	//ύXȂ
	SetModifiedFlag(FALSE);
}

void CExtncsDoc::FileSave()
{
	char newPathName[_MAX_PATH];
	int ret;

	if(m_ExtncsName.Compare(_T("untitled.sig")) == NULL) {
		ret = MessageBox(NULL,"Do you wish to save by the name of untitled.sig ?",
			PACKAGE_STRING, MB_ICONQUESTION | MB_YESNO);
		if(ret == IDNO) {
			OnFileSaveAs();
			return;
		}
	}
	strcpy(newPathName, m_ExtncsName);
	SaveExtncsModel( newPathName );
}

void CExtncsDoc::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	if(m_arrWidgets.GetSize() > 0)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
}

void CExtncsDoc::OnFileSaveAs() 
{
	FileSaveAs();
}

void CExtncsDoc::FileSaveAs() 
{
	CString pathStr,filename,extname;
	char name[_MAX_PATH];
	char newPathName[_MAX_PATH];
	LPCSTR	lpszFilter;

	strcpy(name, "");
	lpszFilter = "Extncs model (*.sig) | *.sig||";
	CFileDialog	dlgFile(FALSE, ".def",name,OFN_HIDEREADONLY,lpszFilter);
	dlgFile.m_ofn.lpstrTitle = "Save As ...";
	dlgFile.m_ofn.lpstrInitialDir = _getcwd(newPathName, _MAX_PATH);
	if(dlgFile.DoModal() == IDOK) {
		pathStr = dlgFile.GetPathName();
		//m_ExtncsNameɃtpXœo^
		m_ExtncsName = pathStr;
		strcpy(newPathName, pathStr);
		//Extncsf
		SaveExtncsModel( newPathName );
		//^CgύX
		filename = dlgFile.GetFileName();
		//Sigfݒ
		m_ModelName = filename;
		extname = dlgFile.GetFileExt();
		sprintf(name, "Extncs : %s", filename);
		//EBhE^Cg
		g_pExtncsMain->m_pExtncsWnd->SendMessage(WM_SETTEXT,0,(LPARAM)name);
		//TreẽgbvύX
		UpdateAllViews(NULL, 0x6B, (CObject*) (LPCTSTR)m_ModelName);
		//ύXȂ
		SetModifiedFlag(FALSE);
	}	
}

void CExtncsDoc::OnUpdateFileSaveAs(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

BOOL CExtncsDoc::SaveExtncsModel(char *openfile)
{
	FILE *fp;
	int	i,nSize,id,sblk,eblk,arrow,idx;
	long color;
	CWidget *pWidget;
	CLine *pLine;
	CPoint spos,epos;
	CPtrArray*	pPtr;
	PARAMINFO *pItem;
	int j,nParam;
	CRect rect;
	int inport,outport,type,junc;
    BLOCKINFO* bItem;

	if((fp = fopen(openfile, "w")) == NULL)
		return FALSE;
	// widget
	nSize = (int)m_arrWidgets.GetSize ();
	fprintf(fp,"{ /* Begin root */\n");
	fprintf(fp,"{ /* Begin widget */\n");
	fprintf(fp,"%d\n",nSize);
	for(i = 0; i < nSize; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		fprintf(fp,"{ /* Begin %s */\n", pWidget->GetName());
		spos = pWidget->GetPoint();
		rect = pWidget->GetRect();
		id = pWidget->GetId();
		//fprintf(fp,"%d %d %d %s %d\n",spos.x,
		//		spos.y, id, (LPCTSTR)pWidget->GetName(), pWidget->GetDirection());
		fprintf(fp,"%d %d %d %d\n",spos.x,spos.y,rect.Width(),rect.Height());
		fprintf(fp,"%d\n",id);
		bItem = (BLOCKINFO*)g_pExtncsMain->m_blockArray.GetAt(id);
		if(bItem->type == MODULE_NCS) {
			//gW[̏ꍇ́AfpX
			fprintf(fp,"%s\n",bItem->model);
		}
		fprintf(fp,"%s\n",(LPCTSTR)pWidget->GetName());
		fprintf(fp,"%d\n",pWidget->GetDirection());
		fprintf(fp,"%s\n",pWidget->GetMatrix());
		fprintf(fp,"%d %d\n",pWidget->GetInport(),pWidget->GetOutport());
		fprintf(fp,"%d %d\n",pWidget->GetConnect(),pWidget->GetJunction());
		//p[^[ۑ
		fprintf(fp,"{ /* Begin parameter */\n");
		pPtr = pWidget->GetParamPointer();
		nParam = (int)pPtr->GetSize();
		fprintf(fp, "%d\n", nParam);
		if(nParam > 0) {
			for (j=0; j<nParam; j++) {
				//PARAMINFO
				//RootVXéAl̂
				pItem = (PARAMINFO*) pPtr->GetAt (j);
				fprintf(fp, "%s = %s\n", pItem->strName, pItem->strValue);
			}
		}
		fprintf(fp,"} /* End parameter */\n");
		//Scopeۑ
		SaveExtncsModelScope(fp, pWidget);
		//TuVXȅꍇ
		if(id == M_SUBSYSTEM)
			SaveExtncsModelSubsystem(fp, pWidget);
		fprintf(fp,"} /* End %s */\n", pWidget->GetName());
	}
	fprintf(fp,"} /* End widget */\n");
	// line
	nSize = (int)m_arrLines.GetSize ();
	fprintf(fp,"{ /* Begin line */\n");
	fprintf(fp,"%d\n", nSize);		// nSizéAC
	for(i = 0; i < nSize; i++) {
		pLine = (CLine*) m_arrLines[i];
		spos = pLine->GetSpos();
		epos = pLine->GetEpos();
		sblk = pLine->GetSblk();
		eblk = pLine->GetEblk();
		color = pLine->GetColor();
		arrow = pLine->GetArrow();
		idx = pLine->GetIndex();
		inport = pLine->GetInport();
		outport = pLine->GetOutport();
		type = pLine->GetType();
		junc = pLine->GetJunction();
		fprintf(fp,"%d %d %d %d %d %d %ld %d %d %d %d %d %d\n",spos.x, spos.y,
				epos.x, epos.y, sblk, eblk,
				color, arrow, idx, inport, outport, type, junc);
	}
	fprintf(fp,"} /* End line */\n");
	fprintf(fp,"} /* End root */\n");
	//Simulationp[^[
	fprintf(fp,"{ /* Begin simulation */\n");
    fprintf(fp, "%s\n", m_strTime);
    fprintf(fp, "%s\n", m_strStep);
    fprintf(fp, "%s\n", m_strSave);
    fprintf(fp, "%d\n", m_nInteg);
    fprintf(fp, "%d\n", m_bRtmode);
	fprintf(fp,"} /* End simulation */\n");

	fclose(fp);
	return TRUE;
}

//Scopeۑ
void CExtncsDoc::SaveExtncsModelScope(FILE *fp, CWidget *pWidget)
{
	BOOL sel;
	int i,nCount,j;
	CPtrArray*	p;
	SCOPEINFO *pItem;
	CScopeFrame* pScopeFrame;
	CWidget* pTmpWidget;

	fprintf(fp,"{ /* Begin scope */\n");
	//
	//OpenĂScope擾
	CExtncsView* pView = (CExtncsView*)GetExtncsView();
	sel = FALSE;
	if(pView->m_nScopeMax > 0) {
		for(i = 0; i < pView->m_nScopeMax; i++) {
			pScopeFrame = (CScopeFrame*)(pView->m_pScopeFrame[i]);
			pTmpWidget = pScopeFrame->m_pWidget;
			if(pTmpWidget == pWidget) {
				p = pWidget->GetScopePointer();
				nCount = (int)p->GetSize();
				for(j = 0; j < nCount; j++) {
					pItem = (SCOPEINFO*) p->GetAt (j); 
					if(pItem->visible)
						sel++;
				}
			}
		}
	}
	//
	fprintf(fp,"%d\n",sel);
	//Open
	if(sel) {
		//visible
		p = pWidget->GetScopePointer();
		nCount = (int)p->GetSize();
		for (i=0; i<nCount; i++) {
			pItem = (SCOPEINFO*) p->GetAt (i);
			if(pItem->visible) {	//
				fprintf(fp,"%d\n",i);	//OpenĂScope
				fprintf(fp,"%s\n",pItem->strVmax);
				fprintf(fp,"%s\n",pItem->strVmin);
				fprintf(fp,"%s\n",pItem->strHmax);
				fprintf(fp,"%s\n",pItem->strVunit);
				fprintf(fp,"%s\n",pItem->strHunit);
				fprintf(fp,"%s\n",pItem->strTs);		//Start
				fprintf(fp,"%s\n",pItem->strTe);		//End
				fprintf(fp,"%s\n",pItem->strTime);		//\
			}
		}
	}
	fprintf(fp,"} /* End scope */\n");
}

//Subsystem̏ꍇ
void CExtncsDoc::SaveExtncsModelSubsystem(FILE *fp, CWidget *pTargetWidget)
{
	CPtrArray* pArrWidgets;
	CPtrArray* pArrLines;
	CWidget* pWidget;
	CPoint spos,epos;
	CRect rect;
	CPtrArray*	pPtr;
	PARAMINFO *pItem;
	int	nSize,i,id,j,nParam,sblk,eblk,arrow,idx;
	long color;
	CLine *pLine;
	int inport,outport,type,junc;
    BLOCKINFO* bItem;

	pArrWidgets = pTargetWidget->GetWidgetsPointer();
	nSize = (int)pArrWidgets->GetSize();
	fprintf(fp,"{ /* Begin subsystem */\n");
	fprintf(fp,"{ /* Begin widget */\n");
	fprintf(fp,"%d\n",nSize);
	for(i = 0; i < nSize; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		fprintf(fp,"{ /* Begin %s */\n", pWidget->GetName());
		spos = pWidget->GetPoint();
		rect = pWidget->GetRect();
		id = pWidget->GetId();
		fprintf(fp,"%d %d %d %d\n",spos.x,spos.y,rect.Width(),rect.Height());
		fprintf(fp,"%d\n",id);
		bItem = (BLOCKINFO*)g_pExtncsMain->m_blockArray.GetAt(id);
		if(bItem->type == MODULE_NCS) {
			//gW[̏ꍇ́AfpX
			fprintf(fp,"%s\n",bItem->model);
		}
		fprintf(fp,"%s\n",(LPCTSTR)pWidget->GetName());
		fprintf(fp,"%d\n",pWidget->GetDirection());
		fprintf(fp,"%s\n",pWidget->GetMatrix());
		fprintf(fp,"%d %d\n",pWidget->GetInport(),pWidget->GetOutport());
		fprintf(fp,"%d %d\n",pWidget->GetConnect(),pWidget->GetJunction());
		//p[^[ۑ
		fprintf(fp,"{ /* Begin parameter */\n");
		pPtr = pWidget->GetParamPointer();
		nParam = (int)pPtr->GetSize();
		fprintf(fp, "%d\n", nParam);
		if(nParam > 0) {
			for (j=0; j<nParam; j++) {
				//PARAMINFO
				//RootVXéAl̂
				pItem = (PARAMINFO*) pPtr->GetAt (j);
				fprintf(fp, "%s = %s\n", pItem->strName, pItem->strValue);
			}
		}
		fprintf(fp,"} /* End parameter */\n");
		//Scopeۑ
		SaveExtncsModelScope(fp, pWidget);
		//TuVXȅꍇ
		if(id == M_SUBSYSTEM)
			SaveExtncsModelSubsystem(fp, pWidget);
		fprintf(fp,"} /* End %s */\n", pWidget->GetName());
	}
	fprintf(fp,"} /* End widget */\n");
	// line
	pArrLines = pTargetWidget->GetLinesPointer();
	nSize = (int)pArrLines->GetSize ();
	fprintf(fp,"{ /* Begin line */\n");
	fprintf(fp,"%d\n",nSize);		// nSize̓C
	for(i = 0; i < nSize; i++) {
		pLine = (CLine*) pArrLines->GetAt(i);
		spos = pLine->GetSpos();
		epos = pLine->GetEpos();
		sblk = pLine->GetSblk();
		eblk = pLine->GetEblk();
		color = pLine->GetColor();
		arrow = pLine->GetArrow();
		idx = pLine->GetIndex();
		inport = pLine->GetInport();
		outport = pLine->GetOutport();
		type = pLine->GetType();
		junc = pLine->GetJunction();
		fprintf(fp,"%d %d %d %d %d %d %ld %d %d %d %d %d %d\n",spos.x, spos.y,
				epos.x, epos.y, sblk, eblk,
				color, arrow, idx, inport, outport, type, junc);
	}
	fprintf(fp,"} /* End line */\n");
	fprintf(fp,"} /* End subsystem */\n");
}

//
void CExtncsDoc::SaveModelSubsystemDoc(FILE *fp, CDocument *pSubsysDoc)
{
//CDocumentCSubsysDoccast
	CSubsysDoc* pDoc = (CSubsysDoc*)pSubsysDoc;
//TODO:
	int	i,nCount,id,sblk,eblk,arrow,idx;
	long color;
	CWidget *pWidget;
	CLine *pLine;
	CPoint spos,epos;
	CPtrArray*	pParam;
	PARAMINFO *pItem;
	int j,nParam;
	CRect rect;
	int inport,outport,type,junc;

	// widget
	nCount = pDoc->GetWidgetCount ();
	fprintf(fp,"{\n");
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) pDoc->GetWidget(i);
		spos = pWidget->GetPoint();
		rect = pWidget->GetRect();
		id = pWidget->GetId();
		//fprintf(fp,"%d %d %d %s %d\n",spos.x,
		//		spos.y, id, (LPCTSTR)pWidget->GetName(), pWidget->GetDirection());
		fprintf(fp,"%d %d %d %d\n",spos.x,spos.y,rect.Width(),rect.Height());
		fprintf(fp,"%d\n",id);
		fprintf(fp,"%s\n",(LPCTSTR)pWidget->GetName());
		fprintf(fp,"%d\n",pWidget->GetDirection());
		fprintf(fp,"%s\n",pWidget->GetMatrix());
		fprintf(fp,"%d %d\n",pWidget->GetInport(),pWidget->GetOutport());
		fprintf(fp,"%d %d\n",pWidget->GetConnect(),pWidget->GetJunction());
		//p[^[
		fprintf(fp,"{\n");
		pParam = pWidget->GetParamPointer();
		nParam = (int)pParam->GetSize();
		fprintf(fp, "%d\n", nParam);
		if(nParam > 0) {
			for (j=0; j<nParam; j++) {
				//PARAMINFO
				pItem = (PARAMINFO*) pParam->GetAt (j);
				fprintf(fp, "%s = %s\n", pItem->strName, pItem->strValue);
			}
		}
		fprintf(fp,"}\n");
	}
	fprintf(fp,"}\n");
	// line
	nCount = pDoc->GetLineCount ();
	fprintf(fp,"{\n");
	for(i = 0; i < nCount; i++) {
		pLine = (CLine*) pDoc->GetLine( i );
		spos = pLine->GetSpos();
		epos = pLine->GetEpos();
		sblk = pLine->GetSblk();
		eblk = pLine->GetEblk();
		color = pLine->GetColor();
		arrow = pLine->GetArrow();
		idx = pLine->GetIndex();
		inport = pLine->GetInport();
		outport = pLine->GetOutport();
		type = pLine->GetType();
		junc = pLine->GetJunction();
		fprintf(fp,"%d %d %d %d %d %d %ld %d %d %d %d %d %d\n",
				spos.x, spos.y, epos.x, epos.y, sblk, eblk,
				color, arrow, idx, inport, outport, type, junc);
	}
	fprintf(fp,"}\n");
}

//
void CExtncsDoc::SaveModelSubsystemWidget(FILE *fp, CWidget* pWidget)
{
	CPtrArray* pSubsys;
	int lCount,i;
	SUBSYSINFO* pItem;
	char linebuf[_MAX_PATH];

	pSubsys = pWidget->GetSubsysPointer();
	lCount = (int)pSubsys->GetSize();
	if(!lCount)
		return;
	for(i = 0; i < lCount; i++) {
		pItem = (SUBSYSINFO*) pSubsys->GetAt(i);
		strcpy(linebuf, pItem->strList);
		fprintf(fp,"%s\n",linebuf);
	}
}

//f
void CExtncsDoc::OnExtncsCode() 
{
	ExtncsCode();
}

void CExtncsDoc::ExtncsCode() 
{
	//R[h
	if(m_ExtncsName.IsEmpty()) {
		AfxMessageBox("ŏɃfۑAēxs",MB_OK,NULL);
		return;
	}
	if(CodeGenerate())
		m_bCodeGen = TRUE;
}

void CExtncsDoc::OnUpdateExtncsCode(CCmdUI* pCmdUI) 
{
	int nCount;
	nCount = (int)m_arrWidgets.GetSize ();
	if(nCount > 0)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
	
}

void CExtncsDoc::OnExtncsCompile() 
{
	ExtncsCompile();
}


void CExtncsDoc::ExtncsCompile() 
{
	//R[hƃRpC
	if(m_ExtncsName.IsEmpty()) {
		AfxMessageBox("ŏɃfۑAēxs",MB_OK,NULL);
		return;
	}
	if(CodeGenerate()) {
		m_bCodeGen = TRUE;
		if(CodeCompile())
			m_bCodeCompile = TRUE;
	}
}

void CExtncsDoc::OnUpdateExtncsCompile(CCmdUI* pCmdUI) 
{
	int nCount;
	nCount = (int)m_arrWidgets.GetSize ();
	if(nCount > 0)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
}

void CExtncsDoc::OnExtncsNcs() 
{
//TODOD:
	//COutView̓eۑ	
	CString pathStr;
	char filename[_MAX_PATH];
	char newPathName[_MAX_PATH];
	LPCSTR	lpszFilter;

	lpszFilter = "NCS model (*.mdl) | *.mdl||";
	CFileDialog	dlgFile(FALSE, ".mdl","",OFN_HIDEREADONLY,lpszFilter);
	dlgFile.m_ofn.lpstrTitle = "Save As ...";
	dlgFile.m_ofn.lpstrInitialDir = _getcwd(newPathName, _MAX_PATH);
	if(dlgFile.DoModal() == IDOK) {
		pathStr = dlgFile.GetPathName();
//m_ExtncsNameɓo^
//m_ExtncsName = pathStr;
		strcpy(filename, pathStr);
		//TODO: unused
		//g_pExtncsMain->m_pOutView->Save( filename );
		SaveAsModel(filename);
	}
}

BOOL CExtncsDoc::SaveAsModel(char* modelname)
{
	char openfile[_MAX_PATH], linebuf[_MAX_PATH];
	const char *tmpdir;
	char *cptr;
	FILE *rfp, *wfp;

	tmpdir = get_tmpdir();
	if(tmpdir) {
		strcpy(openfile, tmpdir);
		strcat(openfile, "\\");
		strcat(openfile, m_ModelName/*m_ExtncsName*/);
		cptr = strstr(openfile, ".sig");
		*cptr = '\0';
		strcat(openfile, ".mdl");
		rfp = fopen(openfile, "r");
		if(!rfp)
			return FALSE;
	}
	else
		return FALSE;		//s

	if((wfp = fopen(modelname, "w")) == NULL)
		return FALSE;
	
	while(!feof(rfp)) {
		if(fgets(linebuf, _MAX_PATH, rfp) == NULL)
			break;
		fprintf(wfp, "%s", linebuf);
	}

	fclose(rfp);
	fclose(wfp);
	return TRUE;
}

void CExtncsDoc::OnUpdateExtncsNcs(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	if(m_bCodeGen)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
}

///////////////////////////////////////////////////////////////////////
// InsertLineg

// Right -> Right
void CExtncsDoc::InsertLineRR(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc) 
{
	int xm,xs,ys,xe,ye;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();
	if(!m_pTargetWidget) {
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		nLineIndex = m_nLineIndex;
	}
	else {
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}

	if(rect.left > rect.right) {
		//߂̏ꍇ
		xs = rect.left;
		ys = rect.top;
		xe = rect.right;
		ye = rect.bottom;
		//EOFFSET
		spt.x = xs;	spt.y = ys;
		ept.x = xs + OFFSET; ept.y = ys;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//OFFSET
		spt = ept;
		if(sRect.bottom > dRect.bottom)
			ept.y = sRect.bottom + OFFSET;
		else
			ept.y = dRect.bottom + OFFSET;
		ept.x = spt.x;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//OFFSET
		spt = ept;
		ept.x = xe - OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//3
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//4
		//E
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//5
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		xm = rect.left + (rect.right - rect.left)/2;
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = xm;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = xm;
		spt.y = rect.top;
		ept.x = xm;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = xm;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Right -> Up
// left > light
//
void CExtncsDoc::InsertLineRU(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xm,xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//Subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}

	if(rect.left > rect.right) {
		//߂̏ꍇ
		//EOFFSET
		spt.x = xs;	spt.y = ys;
		ept.x = xs + OFFSET; ept.y = ys;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//OFFSET
		spt = ept;
		if(sRect.bottom > dRect.bottom)
			ept.y = sRect.bottom + OFFSET;
		else
			ept.y = dRect.bottom + OFFSET;
		ept.x = spt.x;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//OFFSET
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//3
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//4
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		if(sypos > dypos) {
			//E
			xm = rect.left + (rect.right - rect.left)/2;
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = rect.right;
			ept.y = rect.top;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt.x = rect.right;
			spt.y = rect.top;
			ept.x = rect.right;
			ept.y = rect.bottom;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//E
			xm = rect.left + (rect.right - rect.left)/2;
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = spt.x + OFFSET;
			ept.y = rect.top;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = spt.x;
			ept.y = rect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = rect.right;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = spt.x;
			ept.y = spt.y - OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Right -> LEFT
void CExtncsDoc::InsertLineRL(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	CPoint spt,ept;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();
	if(!m_pTargetWidget) {
		//root
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}

	if(rect.left > rect.right) {
		//߂̏ꍇ
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = rect.left + OFFSET;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = rect.left + OFFSET;
		spt.y = rect.top;
		ept.x = rect.left + OFFSET;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = rect.left + OFFSET;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = rect.right + OFFSET;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = rect.right + OFFSET;
		spt.y = rect.top;
		ept.x = rect.right + OFFSET;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = rect.right + OFFSET;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Right -> Down
void CExtncsDoc::InsertLineRD(CRect rect, int sidx, int eidx, 
							 int inport, int outport, int junc)
{
	int xm,xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(rect.left > rect.right) {
		//߂̏ꍇ
		//EOFFSET
		spt.x = xs;	spt.y = ys;
		ept.x = xs + OFFSET; ept.y = ys;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//OFFSET
		spt = ept;
		if(sRect.top > dRect.top)
			ept.y = dRect.top - OFFSET;
		else
			ept.y = sRect.top - OFFSET;
		ept.x = spt.x;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//OFFSET
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//3
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//4
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		if(dypos > sypos) {
			//E
			xm = rect.left + (rect.right - rect.left)/2;
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = rect.right;
			ept.y = rect.top;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt.x = rect.right;
			spt.y = rect.top;
			ept.x = rect.right;
			ept.y = rect.bottom;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//E
			xm = rect.left + (rect.right - rect.left)/2;
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = spt.x + OFFSET;
			ept.y = rect.top;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = spt.x;
			ept.y = rect.bottom - OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = rect.right;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = spt.x;
			ept.y = spt.y + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Left -> Right
void CExtncsDoc::InsertLineLR(CRect rect, int sidx, int eidx, 
							 int inport, int outport, int junc)
{
	CPoint spt,ept;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();
	if(!m_pTargetWidget) {
		//root
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}

	if(rect.left > rect.right) {
		//߂̏ꍇ
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = rect.right - OFFSET;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = rect.right - OFFSET;
		spt.y = rect.top;
		ept.x = rect.right - OFFSET;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = rect.right - OFFSET;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = rect.left - OFFSET;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = rect.left - OFFSET;
		spt.y = rect.top;
		ept.x = rect.left - OFFSET;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = rect.left - OFFSET;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Left -> Up
void CExtncsDoc::InsertLineLU(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xm,xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CPoint pos;
	CRect sRect,dRect;
	CWidget *pWidget;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}

	if(rect.left > rect.right) {
		//srcdesEɑ
		if(sypos>dypos) {
			//dessrc̏
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc̉
			xm = dRect.right + (xs-dRect.right)/2;
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = xm;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//1
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//srcdes荶ɑ
		if(sypos>dypos) {
			//dessrc
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = sRect.top-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//4
		}
		else {
			//dessrc艺
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = sRect.bottom+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt = ept;
			ept.x = dRect.left-OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//4
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//4
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//4
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Left -> Left
void CExtncsDoc::InsertLineLL(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xm,xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CPoint pos;
	CRect sRect,dRect;
	CWidget *pWidget;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(rect.left > rect.right) {
		//srcdesEɑ
		xm = rect.left + (rect.right - rect.left)/2;
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = xm;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = xm;
		spt.y = rect.top;
		ept.x = xm;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = xm;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//srcdes荶ɑ
		//߂̏ꍇ
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x - OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//ォ
		spt = ept;
		ept.x = spt.x;
		if(sypos>dypos)
			ept.y = sRect.top-OFFSET;
		else
			ept.y = sRect.bottom+OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//E
		spt = ept;
		ept.x = xe + OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//3
		//ォ
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//4
		//
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//5
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Left -> Dworn
void CExtncsDoc::InsertLineLD(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CPoint pos;
	CRect sRect,dRect;
	CWidget *pWidget;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(rect.left > rect.right) {
		//srcdesEɑ
		if(dypos>sypos) {
			//srcdes̏
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc̏
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x-OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//1
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//srcdes荶ɑ
		if(dypos>sypos) {
			//srcdes
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = sRect.bottom+(dRect.top-sRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//4
		}
		else {
			//srcdes艺
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = dRect.bottom+(sRect.top-dRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt = ept;
			ept.x = dRect.left-OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//4
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//4
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//4
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Up -> Right
void CExtncsDoc::InsertLineUR(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xm,xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(rect.left > rect.right) {
		//߂̏ꍇ
		//OFFSET
		spt.x = xs;	spt.y = ys;
		if(sRect.bottom > dRect.bottom)
			ept.y = dRect.top - OFFSET;
		else
			ept.y = sRect.top - OFFSET;
		ept.x = spt.x;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//OFFSET
		spt = ept;
		ept.x = xe - OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//3
		//E
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		xm = rect.left + (rect.right - rect.left)/2;
		if(sypos > dypos) {
			//
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = rect.left;
			ept.y = rect.bottom;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//OFFSET
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = spt.x;
			ept.y = spt.y - OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xm;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//4
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Up -> Up
void CExtncsDoc::InsertLineUU(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xm,xs,ys,xe,ye,sxpos,dxpos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dxpos = dRect.left + dRect.Width() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sxpos = sRect.left + sRect.Width() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dxpos = dRect.left + dRect.Width() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sxpos = sRect.left + sRect.Width() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(rect.top > rect.bottom) {
		//dessrcɑ
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = spt.y-OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//E
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//2
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		xm = rect.left + (rect.right - rect.left)/2;
		if(sxpos > dxpos) {
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = spt.y-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xm;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = spt.y-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xm;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Up -> Left
void CExtncsDoc::InsertLineUL(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xm,xs,ys,xe,ye,sxpos,dxpos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dxpos = dRect.left + dRect.Width() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sxpos = sRect.left + sRect.Width() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dxpos = dRect.left + dRect.Width() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sxpos = sRect.left + sRect.Width() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(rect.top < rect.bottom) {
		//srcdesɑ
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = spt.y-OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//E
		spt = ept;
		ept.y = spt.y;
		if(sRect.right > dRect.right)
			ept.x = sRect.right + OFFSET;
		else
			ept.x = dRect.right + OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//2
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		xm = rect.left + (rect.right - rect.left)/2;
		if(sxpos > dxpos) {
			//srcdesEɑ
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//srcdes荶ɑ
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = spt.y-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe+OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Up -> Dworn
void CExtncsDoc::InsertLineUD(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xs,ys,xe,ye,sxpos,dxpos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dxpos = dRect.left + dRect.Width() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sxpos = sRect.left + sRect.Width() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dxpos = dRect.left + dRect.Width() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sxpos = sRect.left + sRect.Width() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(rect.top > rect.bottom) {
		//dessrcɑ
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = ye-OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//E
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//2
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//srcdesɑ
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = spt.y-OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//E
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, outport, LINE_STOP, junc);	//2
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Down -> Right
void CExtncsDoc::InsertLineDR(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(rect.left > rect.right) {
		//srcdesE
		if(sypos>dypos) {
			//dessrc̏
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//OFFSET
			spt = ept;
			ept.x = xe - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		else {
			//dessrc̉
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + (dRect.top-sRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//OFFSET
			spt = ept;
			ept.x = xe - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		if(dypos>sypos) {
			//dessrc艺
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = sRect.right+(dRect.left-sRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Down -> Up
void CExtncsDoc::InsertLineDU(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(rect.left > rect.right) {
		//srcdesE
		if(sypos>dypos) {
			//dessrc̏
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//OFFSET
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		else {
			//dessrc̉
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		if(dypos>sypos) {
			//dessrc艺
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Down -> Left
void CExtncsDoc::InsertLineDL(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsytem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(rect.left > rect.right) {
		//srcdesE
		if(sypos>dypos) {
			//dessrc̏
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = dRect.right+(sRect.left-dRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		else {
			//dessrc̉
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		if(dypos>sypos) {
			//dessrc艺
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom+(dRect.top-sRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe+OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe+OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Down -> Dworn
void CExtncsDoc::InsertLineDD(CRect rect, int sidx, int eidx,
							 int inport, int outport, int junc)
{
	int xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) m_arrWidgets[sidx];
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		dypos = dRect.top + dRect.Height() / 2;
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		sypos = sRect.top + sRect.Height() / 2;
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}

	if(rect.left > rect.right) {
		//srcdesE
		if(dypos>sypos) {
			//srcdes̏
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + (dRect.top-sRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		else {
			//dessrc̏
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = dRect.right+(sRect.left-dRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		if(dypos>sypos) {
			//dessrc艺
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom+(dRect.top-sRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = sRect.right+(dRect.left-sRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

///////////////////////////////////////////////////////////////////////
// InsertDivideg

// Horz -> Right
void CExtncsDoc::InsertDivideHR(CRect rect, int sidx, int eidx, int inport, int junc)
{
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CWidget* pWidget;
	CRect dRect;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(xs > xe) {
		//Jn_荶Widget݂
		if(ys > ye) {
			//LineWidget
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = dRect.bottom + (ys-dRect.bottom)/2;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe - OFFSET;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, -1, LINE_STOP, junc);	//4
		}
		else {
			//Line艺Widget
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ys + (dRect.top-ys)/2;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe - OFFSET;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, -1, LINE_STOP, junc);	//4
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//EWidget
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//2
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Horz -> Up
void CExtncsDoc::InsertDivideHU(CRect rect, int sidx, int eidx, int inport, int junc)
{
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CWidget* pWidget;
	CRect dRect;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}

	if(rect.top > rect.bottom) {
		//Widget
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = dRect.bottom + (ys-dRect.bottom)/2;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		//
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//4
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = ye+OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		//E
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//2
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Horz -> Left
void CExtncsDoc::InsertDivideHL(CRect rect, int sidx, int eidx, int inport, int junc)
{
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CWidget* pWidget;
	CRect dRect;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsytem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(xe > xs) {
		//Jn_EWidget݂
		if(ys > ye) {
			//LineWidget
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = dRect.bottom + (ys-dRect.bottom)/2;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe + OFFSET;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, -1, LINE_STOP, junc);	//4
		}
		else {
			//Line艺Widget
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ys + (dRect.top-ys)/2;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe + OFFSET;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, -1, LINE_STOP, junc);	//4
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//2
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Horz -> Down
void CExtncsDoc::InsertDivideHD(CRect rect, int sidx, int eidx, int inport, int junc)
{
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CWidget* pWidget;
	CRect dRect;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}

	if(rect.top > rect.bottom) {
		//Widget
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = dRect.top - OFFSET;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		//
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//4
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = ys + (dRect.top-ys)/2;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		//E
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//2
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Vert -> Right
void CExtncsDoc::InsertDivideVR(CRect rect, int sidx, int eidx, int inport, int junc)
{
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CRect dRect;
	CWidget *pWidget;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(xs > xe) {
		//Line荶Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = dRect.left - OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//LineEWidget
		spt.x = xs;
		spt.y = ys;
		ept.x = xs + (xe-xs)/2;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Vert -> Up
void CExtncsDoc::InsertDivideVU(CRect rect, int sidx, int eidx, int inport, int junc)
{
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CRect dRect;
	CWidget *pWidget;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}
	if(ys < ye) {
		//_艺Widget
		if(xs>xe) {
			//_荶Widget
			spt.x = xs;
			spt.y = ys;
			ept.x = dRect.right+(xs-dRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, -1, LINE_STOP, junc);	//3
		}
		else {
			//_EWidget
			spt.x = xs;
			spt.y = ys;
			ept.x = xs+(dRect.left-xs)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, -1, LINE_STOP, junc);	//3
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//_Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Vert -> Left
void CExtncsDoc::InsertDivideVL(CRect rect, int sidx, int eidx, int inport, int junc)
{
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CRect dRect;
	CWidget *pWidget;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}

	if(xs < xe) {
		//LineEWidget
		spt.x = xs;
		spt.y = ys;
		ept.x = dRect.right + OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//Line荶Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = xs + (xe-xs)/2;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Vert -> Down
void CExtncsDoc::InsertDivideVD(CRect rect, int sidx, int eidx, int inport, int junc)
{
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CRect dRect;
	CWidget *pWidget;
	int OFFSET = 20;
	CPtrArray* pArrWidgets;
	int nLineIndex;

	//Subsystem
	if(m_pTargetWidget)
		pArrWidgets = m_pTargetWidget->GetWidgetsPointer();

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	if(!m_pTargetWidget) {
		//root
		pWidget = (CWidget*) m_arrWidgets[eidx];
		dRect = pWidget->GetRect();
		nLineIndex = m_nLineIndex;
	}
	else {
		//subsystem
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		nLineIndex = m_pTargetWidget->GetLineIndex();
	}

	if(ys > ye) {
		//_Widget
		if(xs>xe) {
			//_荶Widget
			spt.x = xs;
			spt.y = ys;
			ept.x = dRect.right+(xs-dRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, -1, LINE_STOP, junc);	//3
		}
		else {
			//_EWidget
			spt.x = xs;
			spt.y = ys;
			ept.x = xs+(dRect.left-xs)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
				inport, -1, LINE_STOP, junc);	//3
		}
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}
	else {
		//_艺Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		if(!m_pTargetWidget)
			m_nLineIndex++;
		else
			m_pTargetWidget->IncLineIndex(1);
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// CExtncsViewĂ΂
// Connection@ύX
void CExtncsDoc::ChangeLine(int lSel, int style)
{
	CLine* pLine;
	int i,nCount,nFirstLine,nLastLine,nIndex,index;
	nCount = GetLineCount ();

	if(style != -1) {
		//lSelŎw肳ꂽCindex
		pLine = (CLine*) GetLine(lSel);
		nIndex = pLine->GetIndex();
		for(i = 0; i < nCount; i++) {
			pLine = (CLine*) GetLine( i );
			index = pLine->GetIndex();
			if(nIndex == index) {
				nFirstLine = i;
				break;
			}
		}
		//nIndexŌ̃C
		nCount = GetLineCount ();
		nLastLine = 0;
		for(i = 0; i < nCount; i++) {
			pLine = (CLine*) GetLine( i );
			index = pLine->GetIndex();
			if(nIndex == index)
				nLastLine = i;
		}

		//styleɉđύX
		switch(style) {
		case	0:
			pLine = GetLine(nFirstLine);
			pLine->SetArrow( 0 );
			pLine = GetLine(nLastLine);
			pLine->SetArrow( 1 );
			break;
		case	1:
			pLine = GetLine(nFirstLine);
			pLine->SetArrow( 3 );
			pLine = GetLine(nLastLine);
			pLine->SetArrow( 0 );
			break;
		case	2:
			pLine = GetLine(nFirstLine);
			pLine->SetArrow( 3 );
			pLine = GetLine(nLastLine);
			pLine->SetArrow( 1 );
			break;
		}
	}

	//m_selected
	for(i = 0; i < nCount; i++) {
		pLine = (CLine*) GetLine( i );
		pLine->SetSel(FALSE);
	}
	
	//ĕ`
	UpdateAllViews (NULL);
}

//CExtncsView𓾂
void* CExtncsDoc::GetExtncsView()
{
	POSITION pos = GetFirstViewPosition();
	//TODO:COutView͎gpȂ̂
	//GetNextView( pos );	// COutView̓ǂݏo
	CExtncsView* pView = (CExtncsView*)GetNextView( pos );
	return (void *)pView;
}

// matrix𕪉
int CExtncsDoc::GetMatrixRow(CString matrix)
{
	int index;
	CString strRow;

	index = matrix.Find(':');
	strRow = matrix.Left(index);
	return atoi(strRow);
}
int CExtncsDoc::GetMatrixColumn(CString matrix)
{
	int index;
	CString strColumn;

	index = matrix.Find(':');
	strColumn = matrix.Mid(index+1);
	return atoi(strColumn);
}

//LineX^CԂ֐
int CExtncsDoc::GetLineStyle(int lSel)
{
	CLine* pLine;
	int i,nCount,nFirstLine,nLastLine,nIndex,index,srcArrow,desArrow;

	//lSelŎw肳ꂽCindex
	pLine = (CLine*) GetLine(lSel);
	nIndex = pLine->GetIndex();
	//nIndexŏ̃C
	nCount = GetLineCount ();
	for(i = 0; i < nCount; i++) {
		pLine = (CLine*) GetLine( i );
		index = pLine->GetIndex();
		if(nIndex == index) {
			nFirstLine = i;
			break;
		}
	}
	//nIndexŌ̃C
	nCount = GetLineCount ();
	nLastLine = 0;
	for(i = 0; i < nCount; i++) {
		pLine = (CLine*) GetLine( i );
		index = pLine->GetIndex();
		if(nIndex == index)
			nLastLine = i;
	}
	// srcArrow
	pLine = GetLine(nFirstLine);
	srcArrow = pLine->GetArrow();
	// desArrow
	pLine = GetLine(nLastLine);
	desArrow = pLine->GetArrow();

	if(srcArrow == 0 && desArrow == 1)
		return	CONNECT_OUT;
	else if(srcArrow == 3 && desArrow == 0)
		return	CONNECT_IN;
	else if(srcArrow == 3 && desArrow == 1)
		return	CONNECT_CROSS;
	else if(srcArrow == 2 && desArrow == 1)
		return	CONNECT_BRANCH;
	return -1;
}

BOOL CExtncsDoc::SaveModified() 
{
	//̊֐I[o[Ch邱ƂɂAhLgύX
	//ɑ΂ۑ`FbN𖳎邱Ƃł

	return TRUE/*CDocument::SaveModified()*/;
}

void CExtncsDoc::OnFileClose() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	g_pExtncsMain->m_pModelDoc->OnCloseDocument();

	OnCloseDocument();
}

//NCSŎgpĂfǂݍ
void CExtncsDoc::OnNcsExtncs() 
{
	CString strPath,strFile;
	char modelPathName[_MAX_PATH],modelFileName[_MAX_PATH];
	LPCSTR	lpszFilter;
	char *cptr;
	int nIndex;
	CWidget* pWidget;
	CExtncsView* pView;
	char msg[_MAX_PATH];

	lpszFilter = "NCS model (*.mdl) | *.mdl||";
	CFileDialog	dlgFile(TRUE, ".mdl","",OFN_HIDEREADONLY,lpszFilter);
	dlgFile.m_ofn.lpstrTitle = "Open ...";
	dlgFile.m_ofn.lpstrInitialDir = _getcwd(modelPathName, _MAX_PATH);
	if(dlgFile.DoModal() == IDOK) {
		// Model path
		strPath = dlgFile.GetPathName();
		strFile = dlgFile.GetFileName();
		// Load
		strcpy(modelPathName, strPath);
		strcpy(modelFileName, strFile);
		if(cptr = strstr(modelFileName, "."))
			*cptr = '\0';
		nIndex = LoadNcsModel(modelPathName, modelFileName);
		//Check name
		if(nIndex != -1) {
			pWidget = (CWidget*) m_arrWidgets[nIndex];
			cptr = strstr(pWidget->GetName(), "-");
			if(cptr != NULL) {
		strcpy(msg,"'-' cannot be used in a name.\nPlease change a name. ");
				//CExtncsView
				pView = (CExtncsView*)GetExtncsView();
		pView->MessageBox(msg, PACKAGE_STRING, MB_OK | MB_ICONQUESTION);
				pView->WidgetExtend(nIndex);
			}
		}
		//[hCodeCompiletOZbgł邪A
		//ÃfexeŐV̏ꍇ́ARpCς݂Ƃď
		//if(CheckLatest(ExtncsPathName)) {
		//	m_bCodeGen = TRUE;
		//	m_bCodeCompile = TRUE;
		//}
		//else {
		//	m_bCodeGen = FALSE;
		//	m_bCodeCompile = FALSE;
		//}

		//̃I[vł́Auntitled̂܂
		//^CgύX
		//char title[_MAX_PATH];
		//sprintf(title, "Extncs : %s", strFile);
		//g_pExtncsMain->m_pExtncsWnd->SendMessage(WM_SETTEXT,0,(LPARAM)title);

	}
}

void CExtncsDoc::OnUpdateNcsExtncs(CCmdUI* pCmdUI) 
{
	// TODO:
	
}

//
// NCSfǂ݁Af쐬
//
int CExtncsDoc::LoadNcsModel(char *openfile, char* modelfile)
{
	FILE *fp;
	int xs,ys,cx,cy,id,direction,inport,outport,connect,junction;
	CRect rect;
	char name[_MAX_PATH];
	CString matrix;
	int nIndex;
	CPoint spos;
	CWidget* pWidget;
	CExtncsView* pView;

	if((fp = fopen(openfile, "r")) == NULL)
		return -1;

	//CExtncsView
	pView = (CExtncsView*)GetExtncsView();
	pView->GetClientRect(&rect);
	//xs,ys,cx,cy
	xs = rect.right/2 - 16;
	ys = rect.bottom/2 - 16;
	cx = 32;
	cy = 32;
	//id
	id = 9999;
	//name
	strcpy(name, modelfile);
	//direction
	direction = 0;
	//matrix
	matrix = _T("1:1");
	//inport,outport
	inport = 1;
	outport = 1;
	//connect,junction
	connect = 0;
	junction = -1;

	//gW[́Am_blockArrayւ̓o^ĂKvAidԂ
	id = g_pExtncsMain->SetBlockDataAppend(openfile, modelfile, MODULE_NCS, -1);
	//draw widget
	spos.x = xs; spos.y = ys;
	nIndex = AddWidget(id, spos, NULL, direction, matrix, cx, cy);
	//o̓|[g
	pWidget = (CWidget*) m_arrWidgets[nIndex];
	pWidget->SetInport(inport);		//|[g
	pWidget->ChangeInportName();
	pWidget->SetOutport(outport);
	pWidget->ChangeOutportName();
	//Name
	pWidget->SetName(_T(name));
	//gCELL
	pWidget->SetConnect(connect);
	pWidget->SetJunction(junction);

	//close
	fclose(fp);

	return nIndex;
}

void CExtncsDoc::ChangeName(char* name)
{
	CWidget* pWidget;
	CString tgtName,tmpName;
	char tgtIndex[16];
	int i,nCount,index;
	BOOL fg;

	nCount = GetWidgetCount ();
	index = 1;
	for(;;) {
		sprintf(tgtIndex,"%d",index);
		tgtName = _T(name);
		tgtName += _T(tgtIndex);
		fg = TRUE;
		for(i = 0; i < nCount; i++) {
			pWidget = GetWidget(i);
			tmpName = pWidget->GetName();
			if(tgtName.Compare(tmpName) == 0) {
				fg = FALSE;
				break;
			}
		}
		index++;
		if(fg)
			break;
	}
	strcpy(name, tgtName);
}

void CExtncsDoc::SubChangeName(CWidget* pTargetWidget, char* name)
{
	CWidget* pWidget;
	CString tgtName,tmpName;
	char tgtIndex[16];
	int i,nCount,index;
	BOOL fg;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();

	nCount = (int)pArrWidgets->GetSize();
	index = 1;
	for(;;) {
		sprintf(tgtIndex,"%d",index);
		tgtName = _T(name);
		tgtName += _T(tgtIndex);
		fg = TRUE;
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) pArrWidgets->GetAt(i);
			tmpName = pWidget->GetName();
			if(tgtName.Compare(tmpName) == 0) {
				fg = FALSE;
				break;
			}
		}
		index++;
		if(fg)
			break;
	}
	strcpy(name, tgtName);
}

//pTargetWidgetŎw肵pX
BOOL CExtncsDoc::GetWidgetPath(CWidget* pTargetWidget, char* pathbuf)
{
	int i,nCount,pos;
	CWidget *pWidget;
	char tmpbuf[_MAX_PATH];

	//pTargetWidget[g
	if(pTargetWidget->GetLevel() == 0)
		return FALSE;
	//Ȃ
	nCount = (int)m_arrWidgets.GetSize ();
	if(nCount == 0)
		return FALSE;
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		if(pWidget == pTargetWidget)
			return TRUE;
		if(pWidget->GetId() == M_SUBSYSTEM) {
			sprintf(tmpbuf,"/%s",pWidget->GetName());
			strcat(pathbuf, tmpbuf);
			if(GetWidgetPathSubsystem(pWidget, pTargetWidget, pathbuf))
				return TRUE;
			else {
				pos = strlen(pathbuf)-strlen(tmpbuf);
				pathbuf[pos] = '\0';
			}
		}
	}
	return FALSE;
}

//SubsystemňvWidget
BOOL CExtncsDoc::GetWidgetPathSubsystem(CWidget* pSubWidget, CWidget* pTargetWidget, char* pathbuf)
{
	int i,nCount,pos;
	CPtrArray* pArrWidgets;
	CWidget* pWidget;
	char tmpbuf[_MAX_PATH];

	pArrWidgets = pSubWidget->GetWidgetsPointer();
	nCount = (int)pArrWidgets->GetSize();
	if(nCount <= 0)
		return FALSE;
	//ẍvŌ
	pWidget = (CWidget*) pArrWidgets->GetAt(0);
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		if(pWidget == pTargetWidget)
			return TRUE;
		if(pWidget->GetId() == M_SUBSYSTEM) {
			sprintf(tmpbuf,"/%s",pWidget->GetName());
			strcat(pathbuf, tmpbuf);
			if(GetWidgetPathSubsystem(pWidget, pTargetWidget, pathbuf))
				return TRUE;
			else {
				pos = strlen(pathbuf)-strlen(tmpbuf);
				pathbuf[pos] = '\0';
			}
		}
	}
	return FALSE;
}
