/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: CodeGene.cpp,v 1.8 2004/09/02 11:11:44 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"
#include "shell/satellite4.h"		//TODO:syscomQƂ̂

#include "WidgetObj.h"
#include "ScopeWnd.h"
#include "SubsysDoc.h"
#include "SubsysWnd.h"
#include "SubsysView.h"

#include "ModelDoc.h"
#include "ExtncsDoc.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"
#include "ExtncsView.h"
#include <io.h>
#include <direct.h>
#include "ExtncsMain.h"

using namespace std;
#define printf          syscom->console->tty_printf

//O[o
extern CExtncsMain* g_pExtncsMain;
//OȂǂێ
typedef struct tagCELLINFO {
	CString	cell;
} TMPCELLINFO;


BOOL CExtncsDoc::Print(CPtrArray* pCodeArray, CString str)
{
	//Consoleɕ\
	printf("%s\n", str);

	//obt@[ɐݒ
	TMPCELLINFO* pItem;
	int index;

	try {
		pItem = new TMPCELLINFO;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return FALSE;
	}
	//@ݒ
	pItem->cell = str;
	//CfbNX
	index = (int)pCodeArray->GetSize();
	//o^
	pCodeArray->Add( pItem );
	return TRUE;
}

//fƃe|ɐt@C쐬
BOOL CExtncsDoc::CodeGenerate() 
{
	//CConsoleViewergbv
	//AfxGetMainWnd()->PostMessage(CONSOLE_ACTIVE, 0, 0L);
	AfxGetMainWnd()->SetActiveWindow();

	char openfile[_MAX_PATH];
	const char *tmpdir;
	char *cptr;
	int size,i;
	CPtrArray	codeArray;
	TMPCELLINFO* pItem;

	tmpdir = get_tmpdir();
	if(tmpdir) {
		strcpy(openfile, tmpdir);
		strcat(openfile, "\\");
		strcat(openfile, m_ModelName/*m_ExtncsName*/);
		cptr = strstr(openfile, ".sig");
		*cptr = '\0';
		strcat(openfile, ".mdl");
		m_defaultFp = fopen(openfile, "w");
	}
	else
		m_defaultFp = NULL;

	//Network쐬OɁAeWidgetɌqݒ肷
	if(!CodeGenerateInit()) {
		//`ĂVXeɃW[݂Ȃ
		AfxMessageBox("CodeGeneration G[", MB_OK, NULL);
		return FALSE;
	}

	Print(&codeArray, "/* Connection */");	
	//type:		NETWORK;`
	Print(&codeArray, "type:\t\tNETWORK;");	
	//module:		W[;`
	CodeGenerateName(&codeArray);
	//cell:Xe[gg`
	if(!CodeGenerateCell(&codeArray)) {
		// Code generation failed.
		if(m_defaultFp)
			fclose(m_defaultFp);
		return FALSE;
	}
	//߂ɌXgAbvĂ݂
	m_nList = CodeGenerateLineList(&codeArray);
	if(m_nList == -1) {
		// Code generation failed.
		if(m_defaultFp)
			fclose(m_defaultFp);
		return FALSE;
	}
	//gap:		Con[m_nList];
	CodeGenerateGap(&codeArray);
	//connection
	if(!CodeGenerateConnection(&codeArray)) {
		// Code generation failed.
		if(m_defaultFp)
			fclose(m_defaultFp);
		return FALSE;
	}

	// Code generation succeed.
	Print(&codeArray, "\t\tend;");

	//eW[Yt
	CodeGenerateModule(&codeArray);

	//fobO
	//printf("*** code ***\n");
	//size = codeArray.GetSize();
	//if(size > 0) {
	//	for (i=0; i<size; i++) {
	//		pItem = (TMPCELLINFO*) codeArray.GetAt (i);
	//		printf("%s\n",pItem->cell);
	//	}
	//}

	//e|ւ̕ۑƊJ
	size = (int)codeArray.GetSize();
	if(size > 0) {
		for (i=0; i<size; i++) {
			pItem =  (TMPCELLINFO*) codeArray.GetAt (i);
			if(m_defaultFp)
				fprintf(m_defaultFp, "%s\n", pItem->cell);
			delete pItem;
		}
		codeArray.RemoveAll();
	}

	if(m_defaultFp)
		fclose(m_defaultFp);
	return TRUE;
}

//qlASubsystemɃCfbNXݒ
BOOL CExtncsDoc::CodeGenerateInit()
{
	int i,nCount,index = 0,nSubsystem = 1;
	CWidget *pWidget;
	//int module;

	nCount = (int)m_arrWidgets.GetSize ();
	if(nCount == 0)
		return FALSE;
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		pWidget->SetOrder(-1);
		if(pWidget->GetId() == M_SUBSYSTEM) {
			nSubsystem = CodeGenerateInitSubsystem(pWidget, nSubsystem);
			if(nSubsystem <= 0)
				return FALSE;
			pWidget->SetLevel(0);
		}
		else
			pWidget->SetLevel(0);
	}
	return TRUE;
}

//Subsystem̌ql
int CExtncsDoc::CodeGenerateInitSubsystem(CWidget* pTargetWidget, int nSubsystem)
{
	int i,nCount,level;
	CPtrArray* pArrWidgets;
	CWidget* pWidget;

	pArrWidgets = pTargetWidget->GetWidgetsPointer();
	nCount = (int)pArrWidgets->GetSize();
	if(nCount <= 0)
		return -1;
	level = nSubsystem + 1;
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		pWidget->SetOrder(-1);
		if(pWidget->GetId() == M_SUBSYSTEM) {
			level = CodeGenerateInitSubsystem(pWidget, level);
			if(level <= 0)
				return -1;
			pWidget->SetLevel(nSubsystem);
		}
		else
			pWidget->SetLevel(nSubsystem);
	}
	return level;
}

//
void CExtncsDoc::CodeGenerateModule(CPtrArray* pCodeArray)
{
	int nCount,i,id,junc;
	CString str,name,model,strCon;
	CWidget *pWidget;
	BLOCKINFO* pItem;


	nCount = (int)m_arrWidgets.GetSize ();
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		name = pWidget->GetName();
		id = pWidget->GetId();
		//M_TITLE͖
		if(id == M_TITLE)
			continue;
		str = _T("/* ") + name + _T(" module") + _T(" */");
		Print(pCodeArray, str);
		//W[ňقȂ
		if(id == M_SUBSYSTEM) {
			CodeGenerateModuleSubsystem(pWidget, pCodeArray);
		}
		else {
			if(id == M_TRANSFER) {
				CodeGenerateTransferModel(pWidget, name, pCodeArray);	//ėp`B֐
			}
			else if(id == M_SUM) {
				CodeGenerateSumModel(pWidget, name, pCodeArray);		//Ϙa
			}
			else if(id == M_PRODUCT) {
				CodeGenerateProductModel(pWidget, name, pCodeArray);	//Z
			}
			else if(id == M_DELAY) {
				CodeGenerateDelayModel(pWidget, name, pCodeArray);		//x
			}
			else if(id == M_MATH) {
				CodeGenerateMathModel(pWidget, name, pCodeArray);		//Math
			}
			else if(id == M_SELECT) {
				CodeGenerateSelectModel(pWidget, name, pCodeArray);		//Select
			}
			else if(id == M_SHELL) {
				CodeGenerateShellModel(pWidget, name, pCodeArray);		//Shell
			}
			else if(id == M_XY) {
				CodeGenerateXyModel(pWidget, name, pCodeArray);		//Xy
			}
			else
				CodeGenerateModuleModel(pWidget, name, pCodeArray);		//W
		}
	}
	//WW[t
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] == 0) {
			if(m_nJunc[i] == -1) {
				CodeGenerateModuleGap(pCodeArray);
				break;
			}
		}
	}
	//gZpJunction
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		if(pWidget->GetId() == M_TITLE)
			continue;		// M_TITLE͖
		if((junc = pWidget->GetJunction()) != -1) {
			strCon = pWidget->GetName();
			pItem = (BLOCKINFO*)g_pExtncsMain->m_blockArray.GetAt(junc);
			strCon += _T("_");
			strCon += pItem->name;
			CodeGenerateModuleGapExpand(strCon, junc, pCodeArray);
		}
	}
}

void CExtncsDoc::CodeGenerateModuleGap(CPtrArray* pCodeArray)
{
	Print(pCodeArray, "/* G module */");
	Print(pCodeArray, "type:\t\tGAP;");
	Print(pCodeArray, "module:\t\tCon;");
	Print(pCodeArray, "input:\t\tVOP(0.0, 0);");
	Print(pCodeArray, "output:\tout;");
	Print(pCodeArray, "function:");
	Print(pCodeArray, "\t\tout = VOP;");
	Print(pCodeArray, "\t\tend;");
}

//////// gZpJunction
void CExtncsDoc::
CodeGenerateModuleGapExpand(CString name, int id, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128],*cptr;
	FILE *fp;
	BLOCKINFO *pItem;
	CString model;
	int codefg;

	// BLOCKINFO
	pItem = (BLOCKINFO*)g_pExtncsMain->m_blockArray.GetAt(id );
	model = pItem->model;
	// ft@C
	GetModuleDirectory(modulepath, _MAX_PATH);
	// x[XmodelJ
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,model);
	if((fp = fopen(file, "r")) == NULL)
		return;

	// Rg
	sprintf(linebuf,"/* %s module */",name);
	Print(pCodeArray, linebuf);
	codefg = 0;		// LR[h
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if((cptr = strstr(linebuf, "type:")) != NULL) {
			//XɁACELLw肪Ă
			if(strstr(cptr, "CELL") != NULL
				|| strstr(cptr, "SYNAPSE") != NULL
				|| strstr(cptr, "GAP") != NULL)
				codefg = 1;
		}
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:\t\t%s;",name);
		}
		// LR[ĥ
		if(codefg)
			Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//////// ShellW[
void CExtncsDoc::
CodeGenerateShellModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128],*cptr;
	FILE *fp;
	CPtrArray*	p;
	PARAMINFO *pItem;
	CString object;
	int codefg;

	// CWidgetparameterɓǂ
	p = pWidget->GetParamPointer();
	pItem = (PARAMINFO*) p->GetAt (0);
	object = pItem->strValue;
	// ft@C
	GetModuleDirectory(modulepath, 128);
	// x[XmodelJ
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,pWidget->GetModel());
	if((fp = fopen(file, "r")) == NULL)
		return;

	codefg = 0;		// LR[h
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if((cptr = strstr(linebuf, "type:")) != NULL) {
			//XɁACELLw肪Ă
			if(strstr(cptr, "CELL") != NULL
				|| strstr(cptr, "SYNAPSE") != NULL
				|| strstr(cptr, "GAP") != NULL)
				codefg = 1;
		}
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:\t\t%s;",name);
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//
			continue;
		}
		if(strstr(linebuf, "function:") != NULL) {
			//functionύX
			Print(pCodeArray, "function:");
			//comment
			Print(pCodeArray, "\t\t/* TODO:Table entry*/");
			//output
			Print(pCodeArray, "\t\tout = 0.0;");
			//end
			Print(pCodeArray, "\t\tend;");
			break;
		}
		// LR[ĥ
		if(codefg)
			Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//////// SelectW[
void CExtncsDoc::
CodeGenerateSelectModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	char tmp[16],*cptr;
	FILE *fp;
	int i,inport,sel,codefg;
	CPtrArray*	p;
	PARAMINFO *pItem;

	// CWidgetparameterɓǂ
	p = pWidget->GetParamPointer();
	pItem = (PARAMINFO*) p->GetAt (0);
	inport = atoi(pItem->strValue);
	pItem = (PARAMINFO*) p->GetAt (1);
	sel = atoi(pItem->strValue);

	// ft@C
	GetModuleDirectory(modulepath, _MAX_PATH);
	// x[XmodelJ
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,pWidget->GetModel());
	if((fp = fopen(file, "r")) == NULL)
		return;

	codefg = 0;		// LR[h
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if((cptr = strstr(linebuf, "type:")) != NULL) {
			//XɁACELLw肪Ă
			if(strstr(cptr, "CELL") != NULL
				|| strstr(cptr, "SYNAPSE") != NULL
				|| strstr(cptr, "GAP") != NULL)
				codefg = 1;
		}
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:		%s;",name);
		}
		if(strstr(linebuf, "input:") != NULL) {
			//͂ύX
			strcpy(linebuf, "input:		");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp,"in%d;",i);
				else
					sprintf(tmp,"in%d,",i);
				strcat(linebuf, tmp);
			}
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//sel̂ݐݒ
			sprintf(linebuf, "parameter:	sel=%d;",sel);
		}
		if(strstr(linebuf, "function:") != NULL) {
			//functionύX
			Print(pCodeArray, "function:");
			//inportif쐬
			for(i = 1; i <= inport; i++) {
				sprintf(linebuf, "\t\tif(sel==%d){",i);
				Print(pCodeArray, linebuf);
				sprintf(linebuf, "\t\t\tout=in%i;",i);
				Print(pCodeArray, linebuf);
				sprintf(linebuf, "\t\t}");
				Print(pCodeArray, linebuf);
			}
			Print(pCodeArray, "\t\tend;");
			break;
		}
		// LR[ĥ
		if(codefg)
			Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//////// MathW[
// varƋLqĂ镔inɒu
void CExtncsDoc::
CodeGenerateMathModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128],*cptr;
	FILE *fp;
	CPtrArray*	p;
	PARAMINFO *pItem;
	int pos,codefg;
	CString str,expr,strLeft,strRight;

	// CWidgetparameterɓǂŁA
	p = pWidget->GetParamPointer();
	pItem = (PARAMINFO*) p->GetAt (0);
	str = pItem->strValue;
	expr = _T("		out = ");
	strRight = _T("in");
	for(;;) {
		pos = str.Find(_T("val"));
		if(pos == -1)
			break;
		strLeft = str.Left(pos);
		expr += strLeft;
		expr += _T("in");
		//E邽
		strRight = str.Mid(pos+3);
		str = strRight;
	}
	expr += strRight;
	expr += _T(";");

	// ft@C
	GetModuleDirectory(modulepath, _MAX_PATH);
	// x[XmodelJ
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,pWidget->GetModel());
	if((fp = fopen(file, "r")) == NULL)
		return;

	codefg = 0;		// LR[h
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if((cptr = strstr(linebuf, "type:")) != NULL) {
			//XɁACELLw肪Ă
			if(strstr(cptr, "CELL") != NULL
				|| strstr(cptr, "SYNAPSE") != NULL
				|| strstr(cptr, "GAP") != NULL)
				codefg = 1;
		}
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:		%s;",name);
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//
			continue;
		}
		if(strstr(linebuf, "function:") != NULL) {
			//functionɐݒ
			Print(pCodeArray, "function:");
			Print(pCodeArray, expr);
			Print(pCodeArray, "\t\tend;");
			break;
		}
		// LR[ĥ
		if(codefg)
			Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//////// DelayW[
void CExtncsDoc::
CodeGenerateDelayModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128],*cptr;
	FILE *fp;
	CPtrArray*	p;
	PARAMINFO *pItem;
	CString delay;
	int codefg;

	// CWidgetparameterɓǂ
	p = pWidget->GetParamPointer();
	pItem = (PARAMINFO*) p->GetAt (0);
	delay = pItem->strValue;
	// ft@C
	GetModuleDirectory(modulepath, 128);
	// x[XmodelJ
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,pWidget->GetModel());
	if((fp = fopen(file, "r")) == NULL)
		return;

	codefg = 0;		// LR[h
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if((cptr = strstr(linebuf, "type:")) != NULL) {
			//XɁACELLw肪Ă
			if(strstr(cptr, "CELL") != NULL
				|| strstr(cptr, "SYNAPSE") != NULL
				|| strstr(cptr, "GAP") != NULL)
				codefg = 1;
		}
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:\t\t%s;",name);
		}
		if(strstr(linebuf, "input:") != NULL) {
			//͂ύX
			sprintf(linebuf, "input:\t\tin(%s,0);",delay);
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//
			continue;
		}
		// LR[ĥ
		if(codefg)
			Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//////// ProductW[
void CExtncsDoc::
CodeGenerateProductModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	char tmp[16],*cptr;
	FILE *fp;
	int i,inport,codefg;
	CPtrArray*	p;
	PARAMINFO *pItem;

	// CWidgetparameterɓǂ
	p = pWidget->GetParamPointer();
	pItem = (PARAMINFO*) p->GetAt (0);
	inport = atoi(pItem->strValue);
	// ft@C
	GetModuleDirectory(modulepath, _MAX_PATH);
	// x[XmodelJ
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,pWidget->GetModel());
	if((fp = fopen(file, "r")) == NULL)
		return;

	codefg = 0;		// LR[h
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if((cptr = strstr(linebuf, "type:")) != NULL) {
			//XɁACELLw肪Ă
			if(strstr(cptr, "CELL") != NULL
				|| strstr(cptr, "SYNAPSE") != NULL
				|| strstr(cptr, "GAP") != NULL)
				codefg = 1;
		}
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:		%s;",name);
		}
		if(strstr(linebuf, "input:") != NULL) {
			//͂ύX
			strcpy(linebuf, "input:		");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp,"in%d;",i);
				else
					sprintf(tmp,"in%d,",i);
				strcat(linebuf, tmp);
			}
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//Ȃ
			continue;
		}
		if(strstr(linebuf, "function:") != NULL) {
			//functionύX
			Print(pCodeArray, "function:");
			strcpy(linebuf, "		out =");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp," in%d;",i);
				else
					sprintf(tmp," in%d *",i);
				strcat(linebuf, tmp);
			}
			Print(pCodeArray, linebuf);
			Print(pCodeArray, "\t\tend;");
			break;
		}
		// LR[ĥ
		if(codefg)
			Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//////// SumW[
void CExtncsDoc::
CodeGenerateSumModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	char tmp[16],*cptr;
	FILE *fp;
	int i,inport,codefg;
	CPtrArray*	p;
	PARAMINFO *pItem;

	// CWidgetparameterɓǂ
	p = pWidget->GetParamPointer();
	pItem = (PARAMINFO*) p->GetAt (0);
	inport = atoi(pItem->strValue);
	// ft@C
	GetModuleDirectory(modulepath, _MAX_PATH);
	// x[XmodelJ
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,pWidget->GetModel());
	if((fp = fopen(file, "r")) == NULL)
		return;

	codefg = 0;		//LR[h
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if((cptr = strstr(linebuf, "type:")) != NULL) {
			//XɁACELLw肪Ă
			if(strstr(cptr, "CELL") != NULL
				|| strstr(cptr, "SYNAPSE") != NULL
				|| strstr(cptr, "GAP") != NULL)
				codefg = 1;
		}
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:		%s;",name);
		}
		if(strstr(linebuf, "input:") != NULL) {
			//͂ύX
			strcpy(linebuf, "input:		");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp,"in%d;",i);
				else
					sprintf(tmp,"in%d,",i);
				strcat(linebuf, tmp);
			}
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//Ȃ
			continue;
		}
		if(strstr(linebuf, "function:") != NULL) {
			//functionύX
			Print(pCodeArray, "function:");
			strcpy(linebuf, "		out =");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp," in%d;",i);
				else
					sprintf(tmp," in%d +",i);
				strcat(linebuf, tmp);
			}
			Print(pCodeArray, linebuf);
			Print(pCodeArray, "		end;");
			break;
		}
		//LR[ĥ
		if(codefg)
			Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//////// XyW[
void CExtncsDoc::
CodeGenerateXyModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	char tmp[16],*cptr;
	FILE *fp;
	int i,inport,codefg;
	CPtrArray*	p;
	PARAMINFO *pItem;

	// CWidgetparameterɓǂ
	p = pWidget->GetParamPointer();
	pItem = (PARAMINFO*) p->GetAt (0);
	inport = atoi(pItem->strValue);
	// inport=0 -> x-y
	// inport=1 -> x-y-z
	inport += 2;
	// ft@C
	GetModuleDirectory(modulepath, _MAX_PATH);
	// x[XmodelJ
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,pWidget->GetModel());
	if((fp = fopen(file, "r")) == NULL)
		return;

	codefg = 0;		// LR[h
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if((cptr = strstr(linebuf, "type:")) != NULL) {
			//XɁACELLw肪Ă
			if(strstr(cptr, "CELL") != NULL
				|| strstr(cptr, "SYNAPSE") != NULL
				|| strstr(cptr, "GAP") != NULL)
				codefg = 1;
		}
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:		%s;",name);
		}
		if(strstr(linebuf, "input:") != NULL) {
			//͂ύX
			strcpy(linebuf, "input:		");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp,"in%d;",i);
				else
					sprintf(tmp,"in%d,",i);
				strcat(linebuf, tmp);
			}
		}
		if(strstr(linebuf, "observable:") != NULL) {
			//j^[ϐύX
			if(inport == 2)
				strcpy(linebuf, "observable:		x, y;");
			else
				strcpy(linebuf, "observable:		x, y, z;");
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//Ȃ
			continue;
		}
		if(strstr(linebuf, "function:") != NULL) {
			//functionύX
			Print(pCodeArray, "function:");
			strcpy(linebuf, "		x = in1;");
			Print(pCodeArray, linebuf);
			strcpy(linebuf, "		y = in2;");
			Print(pCodeArray, linebuf);
			if(inport == 3) {
				strcpy(linebuf, "		z = in3;");
				Print(pCodeArray, linebuf);
			}
			strcpy(linebuf, "		out =");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp," in%d;",i);
				else
					sprintf(tmp," in%d +",i);
				strcat(linebuf, tmp);
			}
			Print(pCodeArray, linebuf);
			Print(pCodeArray, "		end;");
			break;
		}
		// LR[ĥ
		if(codefg)
			Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

////////////////////////////////////////////////////////////
//
//	ėp`B֐W[AR[h
//
void CExtncsDoc::
CodeGenerateTransferModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128],*cptr;
	FILE *fp;
	int nnum,dnum,codefg;
	double num[MAX_ORDER],den[MAX_ORDER];

	// ft@C
	GetModuleDirectory(modulepath, _MAX_PATH);
	// divideAx[XmodelJ
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,pWidget->GetModel());
	if((fp = fopen(file, "r")) == NULL)
		return;

	codefg = 0;		// LR[h
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if((cptr = strstr(linebuf, "type:")) != NULL) {
			//XɁACELLw肪Ă
			if(strstr(cptr, "CELL") != NULL
				|| strstr(cptr, "SYNAPSE") != NULL
				|| strstr(cptr, "GAP") != NULL)
				codefg = 1;
		}
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:\t\t%s;",name);
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//parameter
			CodeGenerateTransferParam(pWidget, &nnum, num, &dnum, den, pCodeArray);
			continue;
		}
		if(strstr(linebuf, "function:") != NULL) {
			//function݂sbreak
			CodeGenerateTransferFunc(nnum, num, dnum, den, pCodeArray);
			break;
		}
		// LR[ĥ
		if(codefg)
			Print(pCodeArray, linebuf);
	}
	fclose(fp);
}


// parameter:`Lq
#if 0
void CExtncsDoc::
CodeGenerateTransferParam(CWidget* pWidget, int *nord, double num[],
						  int *dord, double den[], CPtrArray* pCodeArray)
{
	int nCount,i,j,nnum,dnum;
	CPtrArray*	p;
	PARAMINFO *pItem;
	char prmbuf[128],tmpbuf[32];

	p = pWidget->GetParamPointer();
	nCount = (int)p->GetSize();
	for (i=0; i<nCount; i++) {
		//PARAMINFO
		pItem = (PARAMINFO*) p->GetAt (i);
		if(pItem->strName.Compare(_T("num")) == NULL) {
			nnum = GetTransferParam(pItem->strValue, num);
		}
		else {
			dnum = GetTransferParam(pItem->strValue, den);
		}
	}

	//qW
	strcpy(prmbuf,"parameter:	");
	for(j = 0; j < dnum; j++) {
		if(j < nnum)
			sprintf(tmpbuf,"a%d=%f,",j,num[j]);
		else
			sprintf(tmpbuf,"a%d=0.0,",j);
		strcat(prmbuf, tmpbuf);
	}
	Print(pCodeArray, prmbuf);
	//W
	strcpy(prmbuf,"		");
	for(j = 0; j < dnum; j++) {
		if(j == dnum-1)
			sprintf(tmpbuf,"b%d=%f;",j,den[j]);
		else
			sprintf(tmpbuf,"b%d=%f,",j,den[j]);
		strcat(prmbuf, tmpbuf);
	}
	Print(pCodeArray, prmbuf);

	*nord = nnum;
	*dord = dnum;	
}
#else
// V@
void CExtncsDoc::
CodeGenerateTransferParam(CWidget* pWidget, int *nord, double num[],
						  int *dord, double den[], CPtrArray* pCodeArray)
{
	int nCount,i,j,nnum,dnum;
	CPtrArray*	p;
	PARAMINFO *pItem;
	char prmbuf[128],tmpbuf[32];
	double c;

	p = pWidget->GetParamPointer();
	nCount = (int)p->GetSize();
	for (i=0; i<nCount; i++) {
		//PARAMINFO
		pItem = (PARAMINFO*) p->GetAt (i);
		if(pItem->strName.Compare(_T("num")) == NULL) {
			nnum = GetTransferParam(pItem->strValue, num);
		}
		else {
			dnum = GetTransferParam(pItem->strValue, den);
		}
	}

	//aW
	strcpy(prmbuf,"parameter:	");
	for(j = 0; j < dnum; j++) {
		sprintf(tmpbuf,"a%d=%f,",j+1,-den[j]);
		strcat(prmbuf, tmpbuf);
	}
	Print(pCodeArray, prmbuf);
	//cW
	strcpy(prmbuf,"		");
	for(j = 0; j < dnum; j++) {
		c = num[j] - den[j]*num[dnum-1];
		sprintf(tmpbuf,"c%d=%f,",j+1,c);
		strcat(prmbuf, tmpbuf);
	}
	Print(pCodeArray, prmbuf);
	//bW
	sprintf(prmbuf,"		b%d=%f;",dnum,num[dnum-1]);
	Print(pCodeArray, prmbuf);

	*nord = nnum;
	*dord = dnum;	
}
#endif
// [1 0.5]Ȃa0=0.5Aa1=1.0
int CExtncsDoc::GetTransferParam(CString prm, double val[])
{
	CString str;
	int	i,j,num,pos;
	char linebuf[128],buf[64],*cptr;

	//val[]NA
	for(i = 0; i < MAX_ORDER; i++)
		val[i] = 0.0;

	//[]O
	pos = prm.Find('[');
	str = prm.Mid(pos+1);
	pos = str.Find(']');
	str = str.Left(pos);
	//
	strcpy(linebuf, str);
	cptr = linebuf;
	num = 0;
	i = 0;
	while(1) {
		if(*cptr == ' ' || *cptr == '\0') {//؂
			buf[i] = '\0';
			for(j=num-1; j>=0; j--)
				val[j+1] = val[j];
			val[0] = atof(buf);
			num++;
			if(*cptr == '\0')
				break;
			i = 0;
		}
		else {
			buf[i++] = *cptr;
		}
		cptr++;
	}
	return num;
}

//function:
//		iddot = a0*in-b0*out;
//		ddot = integral(0.0, iddot);
//		idot = ddot + a1*in-b1*out;
//		dot = integral(0.0,idot);
//		out = dot + a2*in-b2*out;
//		end;

#if 0
void CExtncsDoc::
CodeGenerateTransferFunc(int nnum, double num[],
						 int dnum, double den[],
						 CPtrArray* pCodeArray)
{
	int	i;
	char linebuf[128];

	Print(pCodeArray, "function:");
	for(i = 0; i < dnum-1; i++) {
		if(i == 0)
			sprintf(linebuf,"		idot%d = a%d*in-b%d*out;",i,i,i);
		else
			sprintf(linebuf,"		idot%d = dot%d+a%d*in-b%d*out;",i,i-1,i,i);
		Print(pCodeArray, linebuf);
		sprintf(linebuf,"		dot%d = integral(0.0, idot%d);",i,i);
		Print(pCodeArray, linebuf);
	}
	sprintf(linebuf,"		out = dot%d+a%d*in-b%d*out;", dnum-2,dnum-1,dnum-1);
	Print(pCodeArray, linebuf);
	Print(pCodeArray, "		end;");
}
#else
// V@
void CExtncsDoc::
CodeGenerateTransferFunc(int nnum, double num[],
						 int dnum, double den[],
						 CPtrArray* pCodeArray)
{
	int	i,j;
	char linebuf[128],tmpbuf[128];

	Print(pCodeArray, "function:");
	for(i = 0; i < dnum-1; i++) {
		if(i == 0) {
			//dx(1)/dt
			strcpy(linebuf, "		dx1 = "); 
			for(j = 0; j < dnum-1; j++) {
				sprintf(tmpbuf,"a%d * x%d + ", j+1, j+1);
				strcat(linebuf,tmpbuf);
			}
			strcat(linebuf,"in;");
			Print(pCodeArray, linebuf);
			// x(1)
			sprintf(linebuf,"		x1 = integral(0.0, dx1);");
			Print(pCodeArray, linebuf);
		}
		else {
			//dx(n)
			sprintf(linebuf,"		dx%d = x%d;", i+1, i);
			Print(pCodeArray, linebuf);
			sprintf(linebuf,"		x%d = integral(0.0, dx%d);",i+1,i+1);
			Print(pCodeArray, linebuf);
		}
	}
	//y
	strcpy(linebuf, "		out = "); 
	for(i = 0; i < dnum-1; i++) {
		//if(i == dnum-2)
		//	sprintf(tmpbuf,"c%d * x%d;", i+1, i+1);
		//else
			sprintf(tmpbuf,"c%d * x%d + ", i+1, i+1);
		strcat(linebuf,tmpbuf);
	}
	sprintf(tmpbuf, "b%d * in;", dnum);
	strcat(linebuf,tmpbuf);
	Print(pCodeArray, linebuf);
	Print(pCodeArray, "		end;");
}
#endif
//
//W[ɕό`Ȃ
//gW[ƕWW[ł́AfpXقȂ
void CExtncsDoc::
CodeGenerateModuleModel(CWidget* pWidget, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	FILE *fp;
	BOOL prmfg;
	int codefg;
	int id;
	BLOCKINFO* pItem;
	CString str;
	char *cptr;

	// id烂W[^Cv
	id = pWidget->GetId();
	pItem = (BLOCKINFO*)g_pExtncsMain->m_blockArray.GetAt(id);
	if(pItem->type == MODULE_NCS) {
		//gW[
		strcpy(file, pItem->model);
	}
	else {
		// WW[
		GetModuleDirectory(modulepath, _MAX_PATH);
		// open file
		sprintf(file,"%s\\ncs\\model\\%s",modulepath,pWidget->GetModel());
		if(Access(file, SL_FATTR_FOK) != 0){
			//ǉW[Ƃ
			strcpy(file, pItem->model);
		}

	}
	if((fp = fopen(file, "r")) == NULL)
		return;

	codefg = 0;		//LR[h
	prmfg = FALSE;
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if((cptr = strstr(linebuf, "type:")) != NULL) {
			//XɁACELLw肪Ă
			if(strstr(cptr, "CELL") != NULL
				|| strstr(cptr, "SYNAPSE") != NULL
				|| strstr(cptr, "GAP") != NULL)
				codefg = 1;
			else
				codefg = -1;	// NETWORK
		}
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:\t\t%s;",name);
			if(codefg != 1) {
				codefg++;
				if(codefg == 1) {
					//type:		CELL\݂Ȃ
					//TODO:ӕKv
					Print(pCodeArray, "type:\t\tCELL;");
				}
			}
		}
		if(strstr(linebuf, "exinput:") != NULL) {
			//inputɕύXKv
			//TODO:input݂ꍇ́Aǂ邩H
			str = _T(linebuf);
			str.Replace("exinput", "input");
			sprintf(linebuf,"%s",str);
		}
		if((cptr = strstr(linebuf, "parameter:")) != NULL) {
			//parameter̈Ƃă`FbN
			prmfg = TRUE;
		}
		//if(prmfg && strstr(linebuf, ";") != NULL) {
		if(prmfg && strstr(linebuf, "function:") != NULL) {
			//parameter̈悩O
			prmfg = FALSE;
		}
		if(prmfg) {
			//p[^[C
			CodeGenerateModuleParameter(pWidget, linebuf);
		}
		if(codefg==1) {
			//module:ȉ̂
			Print(pCodeArray, linebuf);
		}
	}
	fclose(fp);
}

void CExtncsDoc::CodeGenerateModuleParameter(CWidget* pWidget, char* linebuf)
{
	int nCount,pos,j,i;
	CPtrArray*	p;
	PARAMINFO *pItem;
	CString strLine, strLeft, strRight,strTop,strTemp;
	char ch;

	strLine = _T(linebuf);
	/*It corresponds, when "/*" exists in a head. */
	pos = strLine.Find("/*");
	if(pos != -1) {
		return;
	}

	/*It corresponds to description of "parameter:". */
	pos = strLine.Find("parameter:");
	if(pos != -1) {
		strTop = strLine.Left(pos+10);
		strLine = strLine.Mid(pos+10);
	}
	else
		strTop = _T("");
	p = pWidget->GetParamPointer();
	nCount = (int)p->GetSize();
	for (i=0; i<nCount; i++) {
		//PARAMINFO
		pItem = (PARAMINFO*) p->GetAt (i);
		//eRg[ύX
		pos = strLine.Find(pItem->strName);
		if(pos != -1) {
			//ł邩mF
			strTemp = strLine.Mid(pos+pItem->strName.GetLength());
			for(j = 0; j < strTemp.GetLength(); j++) {
				ch = strTemp.GetAt(j);
				if(ch == ' ' || ch == '\t')
					continue;
				break;
			}
			if(ch == '=') {
				//A,܂Œo
				strLeft = strLine.Left(pos);
				strRight = strLine.Mid(pos);
				pos = strRight.Find(_T(","));
				if(pos == -1) {
					//TODO:co
					pos = strRight.Find(_T(";"));
				}
				//strRight,ȍ~
				strRight = strRight.Mid(pos);
				//č\
				strLine = strLeft + pItem->strName + _T("=") + pItem->strValue + strRight;
			}
		}
	}
	//Đݒ
	strTop += strLine;
	strcpy(linebuf, strTop);
}

///////////////////////////////////////////////////////////////////
//
//		SubsystemW[W[R[h
//
///////////////////////////////////////////////////////////////////

void CExtncsDoc::CodeGenerateModuleSubsystem(CWidget* pTargetWidget, CPtrArray* pCodeArray)
{
	int nCount,i,id,level;
	CPtrArray* pArrWidgets;
	CString name,str;
	char buf[_MAX_PATH];
	CWidget* pWidget;

	pArrWidgets = pTargetWidget->GetWidgetsPointer();
	nCount = (int)pArrWidgets->GetSize();
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		id = pWidget->GetId();
		//Subsystem̃CfbNXtnameɂ
		sprintf(buf,"S%d_",pWidget->GetLevel());
		name = _T(buf);
		name += pWidget->GetName();
		str = _T("/* ") + name + _T(" module") + _T(" */");
		Print(pCodeArray, str);
		//W[ňقȂ
		if(id == M_SUBSYSTEM) {
			CodeGenerateModuleSubsystem(pWidget, pCodeArray);
		}
		else {
			if(id == M_TRANSFER) {
				CodeGenerateTransferModel(pWidget, name, pCodeArray);	//ėp`B֐
			}
			else if(id == M_SUM) {
				CodeGenerateSumModel(pWidget, name, pCodeArray);		//Ϙa
			}
			else if(id == M_PRODUCT) {
				CodeGenerateProductModel(pWidget, name, pCodeArray);	//Z
			}
			else if(id == M_DELAY) {
				CodeGenerateDelayModel(pWidget, name, pCodeArray);		//x
			}
			else if(id == M_MATH) {
				CodeGenerateMathModel(pWidget, name, pCodeArray);		//Math
			}
			else if(id == M_SELECT) {
				CodeGenerateSelectModel(pWidget, name, pCodeArray);		//Select
			}
			else if(id == M_SHELL) {
				CodeGenerateShellModel(pWidget, name, pCodeArray);		//Shell
			}
			else if(id == M_XY) {
				CodeGenerateXyModel(pWidget, name, pCodeArray);		//Xy
			}
			else
				CodeGenerateModuleModel(pWidget, name, pCodeArray);		//W
			//if(id == M_TRANSFER)
			//	CodeGenerateSubsystemTransfer(wItem, name, pCodeArray);	//ėp`B֐
			//else if(id == M_SUM) {
			//	CodeGenerateSubsystemSum(wItem, name, pCodeArray);
			//}
			//else if(id == M_PRODUCT) {
			//	CodeGenerateSubsystemProduct(wItem, name, pCodeArray);
			//}
			//else if(id == M_DELAY) {
			//	CodeGenerateSubsystemDelay(wItem, name, pCodeArray);
			//}
			//else
			//	CodeGenerateSubsystemOthers(wItem, name, pCodeArray); //W
		}
	}

	//SubsystemWW[t
	pWidget = (CWidget*) pArrWidgets->GetAt(0);
	level = pWidget->GetLevel();
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] == level) {
			if(m_nJunc[i] == -1) {
				CodeGenerateSubsystemGap(pTargetWidget, pCodeArray);
				break;
			}
		}
	}
}

void CExtncsDoc::CodeGenerateSubsystemGap(CWidget* pTargetWidget, CPtrArray* pCodeArray)
{
	char buf[_MAX_PATH];
	int level;
	CWidget* pWidget;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();
	//ŏWidget̃xgp
	pWidget = (CWidget*)pArrWidgets->GetAt(0);
	level = pWidget->GetLevel();

	Print(pCodeArray, "/* G module */");
	Print(pCodeArray, "type:\t\tGAP;");
	sprintf(buf,"module:\t\tS%d_Con;",level);
	Print(pCodeArray, _T(buf));
	Print(pCodeArray, "input:\t\tVOP(0.0, 0);");
	Print(pCodeArray, "output:\t\tout;");
	Print(pCodeArray, "function:");
	Print(pCodeArray, "\t\tout = VOP;");
	Print(pCodeArray, "\t\tend;");
}

//SubsystemCodeGenerateModuleModel
void CExtncsDoc::
CodeGenerateSubsystemOthers(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	FILE *fp;
	BOOL prmfg;
	BLOCKINFO* bItem;

	// W[
	GetModuleDirectory(modulepath, _MAX_PATH);
	// f
	bItem = (BLOCKINFO *)g_pExtncsMain->m_blockArray.GetAt(wItem->id);
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,bItem->model);
	if((fp = fopen(file, "r")) == NULL)
		return;

	prmfg = FALSE;
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:			%s;",name);
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//parameter̈Ƃă`FbN
			prmfg = TRUE;
		}
		//if(prmfg && strstr(linebuf, ";") != NULL) {
		if(prmfg && strstr(linebuf, "function:") != NULL) {
			//parameter̈悩O
			prmfg = FALSE;
		}
		if(prmfg) {
			//p[^[C
			CodeGenerateSubsystemParameter(wItem, linebuf);
		}

		Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//SubsystemŁACodeGenerateModuleParameter()
//p[^[́Â悤ɐݒ肳Ă
//wItem->nparam	: number
//wItem->pparam[0] : freq = 1.0
//wItem->pparam[1] : amplitude = 1.0
//....................
//
void CExtncsDoc::CodeGenerateSubsystemParameter(SUBSYSWIDGET* wItem, char* linebuf)
{
	int nCount,pos,i;
	CString strLine, str, strName, strValue, strLeft, strRight;

	strLine = _T(linebuf);
	nCount = wItem->nparam;
	for (i=0; i<nCount; i++) {
		//p[^[
		str = wItem->pparam[i];
		pos = str.Find(_T(" = "));
		strName = str.Left(pos);
		strValue = str.Mid(pos+3);
		//eRg[ύX
		if((pos = strLine.Find(strName)) != -1) {
			//A,܂Œo
			strLeft = strLine.Left(pos);
			strRight = strLine.Mid(pos);
			if((pos = strRight.Find(_T(","))) == -1) {
//2002.11.15ēxv
				//co
				pos = strRight.Find(_T(";"));
			}
			//strRight,ȍ~
			strRight = strRight.Mid(pos);
			//č\
			strLine = strLeft + strName + _T("=") + strValue + strRight;
		}
	}
	//Đݒ
	strcpy(linebuf, strLine);
}

//SubsystemŁACodeGenerateTransferModel()
void CExtncsDoc::
CodeGenerateSubsystemTransfer(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	FILE *fp;
	int nnum,dnum;
	double num[MAX_ORDER],den[MAX_ORDER];
	BLOCKINFO* bItem;

	// fBNg
	GetModuleDirectory(modulepath, _MAX_PATH);
	// f
	bItem = (BLOCKINFO *)g_pExtncsMain->m_blockArray.GetAt(wItem->id);
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,bItem->model);
	if((fp = fopen(file, "r")) == NULL)
		return;

	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:			%s;",name);
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//parameter
			CodeGenerateTransferParamSub(wItem, &nnum, num, &dnum, den, pCodeArray);
			continue;
		}
		if(strstr(linebuf, "function:") != NULL) {
			//function݂sbreak
			CodeGenerateTransferFunc(nnum, num, dnum, den, pCodeArray);
			break;
		}
		Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//SubsystemŁACodeGenerateTransferParam()
void CExtncsDoc::
CodeGenerateTransferParamSub(SUBSYSWIDGET* wItem, int *nord, double num[],
						  int *dord, double den[], CPtrArray* pCodeArray)
{
	int nCount,i,j,nnum,dnum,pos;
	char prmbuf[128],tmpbuf[32];
	CString str,strName,strValue;

	nCount = wItem->nparam;
	for (i=0; i<nCount; i++) {
		//p[^[
		str = wItem->pparam[i];
		pos = str.Find(_T(" = "));
		strName = str.Left(pos);
		strValue = str.Mid(pos+3);
		if(strName.Compare(_T("num")) == NULL) {
			nnum = GetTransferParam(strValue, num);
		}
		else {
			dnum = GetTransferParam(strValue, den);
		}
	}

	//qW
	strcpy(prmbuf,"parameter:	");
	for(j = 0; j < dnum; j++) {
		if(j < nnum)
			sprintf(tmpbuf,"a%d=%f,",j,num[j]);
		else
			sprintf(tmpbuf,"a%d=0.0,",j);
		strcat(prmbuf, tmpbuf);
	}
	Print(pCodeArray, prmbuf);
	//W
	strcpy(prmbuf,"		");
	for(j = 0; j < dnum; j++) {
		if(j == dnum-1)
			sprintf(tmpbuf,"b%d=%f;",j,den[j]);
		else
			sprintf(tmpbuf,"b%d=%f,",j,den[j]);
		strcat(prmbuf, tmpbuf);
	}
	Print(pCodeArray, prmbuf);

	*nord = nnum;
	*dord = dnum;	
}

//SubsystemŁACodeGenerateProductModel()
void CExtncsDoc::
CodeGenerateSubsystemProduct(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	char tmp[16];
	FILE *fp;
	int i,inport,pos;
	CString str,strName,strValue;
	BLOCKINFO* bItem;

	// SUBSYSWIDGET* wItemparameterɓǂ
	str = wItem->pparam[0];
	pos = str.Find(_T(" = "));
	strName = str.Left(pos);
	strValue = str.Mid(pos+3);
	inport = atoi(strValue);

	// fBNg
	GetModuleDirectory(modulepath, _MAX_PATH);
	// f
	bItem = (BLOCKINFO *)g_pExtncsMain->m_blockArray.GetAt(wItem->id);
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,bItem->model);
	if((fp = fopen(file, "r")) == NULL)
		return;

	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:		%s;",name);
		}
		if(strstr(linebuf, "input:") != NULL) {
			//͂ύX
			strcpy(linebuf, "input:		");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp,"in%d;",i);
				else
					sprintf(tmp,"in%d,",i);
				strcat(linebuf, tmp);
			}
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//Ȃ
			continue;
		}
		if(strstr(linebuf, "function:") != NULL) {
			//functionύX
			Print(pCodeArray, "function:");
			strcpy(linebuf, "\t\tout =");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp," in%d;",i);
				else
					sprintf(tmp," in%d *",i);
				strcat(linebuf, tmp);
			}
			Print(pCodeArray, linebuf);
			Print(pCodeArray, "\t\tend;");
			break;
		}
		Print(pCodeArray, linebuf);
	}
	fclose(fp);
}
//SubsystemŁACodeGenerateSumModel()
void CExtncsDoc::
CodeGenerateSubsystemSum(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	char tmp[16];
	FILE *fp;
	int i,inport,pos;
	CString str,strName,strValue;
	BLOCKINFO* bItem;

	// SUBSYSWIDGET* wItemparameterɓǂ
	str = wItem->pparam[0];
	pos = str.Find(_T(" = "));
	strName = str.Left(pos);
	strValue = str.Mid(pos+3);
	inport = atoi(strValue);

	// ft@C̃fBNg
	GetModuleDirectory(modulepath, _MAX_PATH);
	// f
	bItem = (BLOCKINFO *)g_pExtncsMain->m_blockArray.GetAt(wItem->id);
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,bItem->model);
	if((fp = fopen(file, "r")) == NULL)
		return;

	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:		%s;",name);
		}
		if(strstr(linebuf, "input:") != NULL) {
			//͂ύX
			strcpy(linebuf, "input:		");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp,"in%d;",i);
				else
					sprintf(tmp,"in%d,",i);
				strcat(linebuf, tmp);
			}
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//Ȃ
			continue;
		}
		if(strstr(linebuf, "function:") != NULL) {
			//functionύX
			Print(pCodeArray, "function:");
			strcpy(linebuf, "		out =");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp," in%d;",i);
				else
					sprintf(tmp," in%d +",i);
				strcat(linebuf, tmp);
			}
			Print(pCodeArray, linebuf);
			Print(pCodeArray, "		end;");
			break;
		}
		Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//SubsystemŁACodeGenerateDelayModel()
void CExtncsDoc::
CodeGenerateSubsystemDelay(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	FILE *fp;
	CString delay,str,strName;
	BLOCKINFO* bItem;
	int pos;

	// SUBSYSWIDGET* wItemparameterɓǂ
	str = wItem->pparam[0];
	pos = str.Find(_T(" = "));
	strName = str.Left(pos);
	delay = str.Mid(pos+3);

	// ffBNg
	GetModuleDirectory(modulepath, _MAX_PATH);
	// f
	bItem = (BLOCKINFO *)g_pExtncsMain->m_blockArray.GetAt(wItem->id);
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,bItem->model);
	if((fp = fopen(file, "r")) == NULL)
		return;

	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:		%s;",name);
		}
		if(strstr(linebuf, "input:") != NULL) {
			//͂ύX
			sprintf(linebuf, "input:		in(%s,0);",delay);
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//
			continue;
		}
		Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//SubsystemŁACodeGenerateMathModel()
void CExtncsDoc::
CodeGenerateSubsystemMath(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	FILE *fp;
	BLOCKINFO* bItem;
	int pos;
	CString str,expr,strLeft,strRight;

	// SUBSYSWIDGET* wItemparameterɓǂ
	str = wItem->pparam[0];
	pos = str.Find(_T(" = "));
	str = str.Mid(pos+3);
	expr = _T("		out = ");
	strRight = _T("in");
	for(;;) {
		pos = str.Find(_T("val"));
		if(pos == -1)
			break;
		strLeft = str.Left(pos);
		expr += strLeft;
		expr += _T("in");
		//E邽
		strRight = str.Mid(pos+3);
		str = strRight;
	}
	expr += strRight;
	expr += _T(";");

	// fBNg
	GetModuleDirectory(modulepath, _MAX_PATH);
	// f
	bItem = (BLOCKINFO *)g_pExtncsMain->m_blockArray.GetAt(wItem->id);
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,bItem->model);
	if((fp = fopen(file, "r")) == NULL)
		return;

	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:		%s;",name);
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//
			continue;
		}
		if(strstr(linebuf, "function:") != NULL) {
			//functionɐݒ
			Print(pCodeArray, "function:");
			Print(pCodeArray, expr);
			Print(pCodeArray, "		end;");
			break;
		}
		Print(pCodeArray, linebuf);
	}
	fclose(fp);
}

//////// SelectW[
//SubsystemŁACodeGenerateSelectModel()
void CExtncsDoc::
CodeGenerateSubsystemSelect(SUBSYSWIDGET* wItem, CString name, CPtrArray* pCodeArray)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	char linebuf[128];
	char tmp[16];
	FILE *fp;
	BLOCKINFO* bItem;
	CString str,strName,strValue;
	int pos,i,inport,sel;

	// SUBSYSWIDGET* wItemparameterɓǂ
	str = wItem->pparam[0];
	pos = str.Find(_T(" = "));
	strName = str.Left(pos);
	strValue = str.Mid(pos+3);
	inport = atoi(strValue);
	str = wItem->pparam[1];
	pos = str.Find(_T(" = "));
	strName = str.Left(pos);
	strValue = str.Mid(pos+3);
	sel = atoi(strValue);

	// ffBNg
	GetModuleDirectory(modulepath, _MAX_PATH);
	// f
	bItem = (BLOCKINFO *)g_pExtncsMain->m_blockArray.GetAt(wItem->id);
	sprintf(file,"%s\\ncs\\model\\%s",modulepath,bItem->model);
	if((fp = fopen(file, "r")) == NULL)
		return;

	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		if(strstr(linebuf, "module:") != NULL) {
			//O̒u
			sprintf(linebuf,"module:		%s;",name);
		}
		if(strstr(linebuf, "input:") != NULL) {
			//͂ύX
			strcpy(linebuf, "input:		");
			for(i = 1; i <= inport; i++) {
				if(i == inport)
					sprintf(tmp,"in%d;",i);
				else
					sprintf(tmp,"in%d,",i);
				strcat(linebuf, tmp);
			}
		}
		if(strstr(linebuf, "parameter:") != NULL) {
			//sel̂ݐݒ
			sprintf(linebuf, "parameter:	sel=%d;",sel);
		}
		if(strstr(linebuf, "function:") != NULL) {
			//functionύX
			Print(pCodeArray, "function:");
			//inportif쐬
			for(i = 1; i <= inport; i++) {
				sprintf(linebuf, "		if(sel==%d){",i);
				Print(pCodeArray, linebuf);
				sprintf(linebuf, "			out=in%i;",i);
				Print(pCodeArray, linebuf);
				sprintf(linebuf, "		}");
				Print(pCodeArray, linebuf);
			}
			Print(pCodeArray, "		end;");
			break;
		}
		Print(pCodeArray, linebuf);
	}
	fclose(fp);
}


void CExtncsDoc::CodeGenerateName(CPtrArray* pCodeArray)
{
	char str[256],buf[256],name[64];

	strcpy(str, m_ExtncsName);
	_splitpath(str, NULL, NULL, name, NULL);
	sprintf(buf,"module:\t\t%s;",name);
	Print(pCodeArray, buf);
}

// fŎgpZ`
// Example
// cell:
//		Gain[1],
//		HH[10],
//		Scope[1];

BOOL CExtncsDoc::CodeGenerateCell(CPtrArray* pCodeArray)
{
	int nCount,i,row,column,id,nIndex,pos;
	CString str,name,subStr,msg;
	char cell[16];
	CWidget *pWidget;
	CPtrArray cellArray;
	TMPCELLINFO* pItem;

	nCount = (int)m_arrWidgets.GetSize ();
	str = _T("cell:");		//̍śAcell:̂݋Lq
	Print(pCodeArray, str);
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		id = pWidget->GetId();
		if(id == M_TITLE)
			continue;	// M_TITLE͖
		if(id == M_GAP || id == M_SYNAPSE)
			continue;	// M_GAPM_SYNAPSE͌qƂčp邩
		if(id == M_SUBSYSTEM) {	// Subsystem
			if(!CodeGenerateCellSubsystem(pWidget, &cellArray)) {
				AfxMessageBox("CodeGenerateCellSubsystem G[", MB_OK, NULL);
				return FALSE;
			}
		}
		else {	// Standard cell
			str = _T("\t\t");
			name = pWidget->GetName();
			str += name;
			row = pWidget->GetCellRow();
			column = pWidget->GetCellColumn();
			sprintf(cell,"[%d]",row*column);
			str += _T(cell);
			str += _T(",");		// 

			//obt@[ɐݒ
			try {
				pItem = new TMPCELLINFO;
			}
			catch (CMemoryException* e) {
				e->Delete ();
				return FALSE;
			}
			//@ݒ
			pItem->cell = str;
			//CfbNX
			nIndex = (int)cellArray.GetSize();
			//o^
			cellArray.Add( pItem );
		}
	}
	//ŁA܂Ƃ߂ďo͂
	//Ō̍sɃ^[~l[^[(;)ĂȂꍇ݂̂
	nIndex = (int)cellArray.GetSize();
	for(i = 0; i < nIndex; i++) {
		pItem = (TMPCELLINFO*)cellArray.GetAt(i);
		str = pItem->cell;
		if(i == nIndex-1) {
			pos = str.GetLength();
			if(str.GetAt(pos-1) == ',')
				str.SetAt(pos-1, ';');
		}
		Print(pCodeArray, str);
	}

	//J
	nIndex = (int)cellArray.GetSize();
	if(nIndex > 0) {
		for (i=0; i<nIndex; i++)
			delete (TMPCELLINFO*) cellArray.GetAt (i);
		cellArray.RemoveAll();
	}

	return TRUE;
}

// SubsytemCellꗗ쐬
BOOL CExtncsDoc::CodeGenerateCellSubsystem(CWidget* pTargetWidget, CPtrArray* pCellArray)
{
	CString str,strSubname,name;
	char buf[_MAX_PATH];
	CPtrArray* pArrWidgets;
	CWidget* pWidget;
	int i,id,nCount,row,column,nIndex;
	char cell[16];
	TMPCELLINFO* pItem;

	pArrWidgets = pTargetWidget->GetWidgetsPointer();
	nCount = (int)pArrWidgets->GetSize();
	if(!nCount)
		return FALSE;

	// ͂
	// SubsysteḿASɃxt
	// ŁAႦS1AS2
	// x́AŏWidget擾
	pWidget = (CWidget*)pArrWidgets->GetAt(0);
	sprintf(buf,"S%d_", pWidget->GetLevel());
	strSubname = _T(buf);
	// Cell
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		id = pWidget->GetId();
		if(id == M_TITLE)
			continue;	// M_TITLE͖
		if(id == M_GAP || id == M_SYNAPSE)
			continue;	// M_GAPM_SYNAPSE͌qƂčp邩
		if(id == M_SUBSYSTEM) {	// Subsystem
			if(!CodeGenerateCellSubsystem(pWidget, pCellArray)) {
				AfxMessageBox("CodeGenerateCellSubsystem G[", MB_OK, NULL);
				return FALSE;
			}
		}
		else {	// Standard cell
			str = _T("\t\t");
			str += strSubname;
			name = pWidget->GetName();
			str += name;
			row = pWidget->GetCellRow();
			column = pWidget->GetCellColumn();
			sprintf(cell,"[%d]",row*column);
			str += _T(cell);
			str += _T(",");		// 

			//obt@[ɐݒ
			try {
				pItem = new TMPCELLINFO;
			}
			catch (CMemoryException* e) {
				e->Delete ();
				return FALSE;
			}
			//@ݒ
			pItem->cell = str;
			//CfbNX
			nIndex = (int)pCellArray->GetSize();
			//o^
			pCellArray->Add( pItem );
		}
	}
	return TRUE;
}

//W[`
//m_nList̌񂩂쐬
//
void CExtncsDoc::CodeGenerateGap(CPtrArray* pCodeArray)
{
	int i,nCount,con,pos,junction,row,column,csize;
	CWidget* pWidget;
	char buf[128];
	CString str,strCon;
	CPtrArray gapArray;
	TMPCELLINFO* pItem;
	BLOCKINFO *bItem;

	//Gap擪
	sprintf(buf,"gap:");
	str = _T(buf);
	SetGapBuffer(&gapArray, str);

	//
	// rootVXeAW
	//
	nCount = (int)m_arrWidgets.GetSize ();
	//W
	con = 0;
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] == 0) {
			if(m_nJunc[i] == -1)
				con++;
		}
	}
	//ExpandꂽW[W
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		row = pWidget->GetCellRow();
		column = pWidget->GetCellColumn();
		csize = row * column;
		if(csize != 1) {
			junction = pWidget->GetJunction();
			if(junction == -1)
				con += (csize - 1);
		}
	}
	if(con > 0) {
		sprintf(buf, "\t\tCon[%d],", con);
		str = _T(buf);
		SetGapBuffer(&gapArray, str);
	}
	//
	// rootVXeAI(GAPASYNAPSE)
	//
	// Lineɕ\ꂽ
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] == 0) {
			if(m_nJunc[i] != -1) {
				pWidget = m_arrWidgets.GetAt(m_nJunc[i]);
				sprintf(buf, "\t\t%s[1],", pWidget->GetName());
				str = _T(buf);
				SetGapBuffer(&gapArray, str);
			}
		}
	}
	// gZ
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		row = pWidget->GetCellRow();
		column = pWidget->GetCellColumn();
		csize = row * column;
		if(csize != 1) {
			junction = pWidget->GetJunction();
			if(junction != -1) {
				strCon = pWidget->GetName();
				bItem = (BLOCKINFO*)g_pExtncsMain->m_blockArray.GetAt(junction);
				strCon += _T("_");
				strCon += bItem->name;
				sprintf(buf, "\t\t%s[%d],", strCon, csize-1);
				str = _T(buf);
				SetGapBuffer(&gapArray, str);
			}
		}
	}

	//subsytemɊւ
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		if(pWidget->GetId() == M_SUBSYSTEM) {
			CodeGenerateGapSubsystem(pWidget, &gapArray, pCodeArray);
		}
	}

	//GapSynapseɊւē
	nCount = (int)gapArray.GetSize();
	for(i = 0; i < nCount; i++) {
		pItem = (TMPCELLINFO*)gapArray.GetAt(i);
		str = pItem->cell;
		if(i == nCount-1) {
			pos = str.GetLength();
			if(str.GetAt(pos-1) == ',')
				str.SetAt(pos-1, ';');
		}
		Print(pCodeArray, str);
	}

	//J
	nCount = (int)gapArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (TMPCELLINFO*) gapArray.GetAt (i);
		gapArray.RemoveAll();
	}
}

void CExtncsDoc::CodeGenerateGapSubsystem(CWidget* pTargetWidget,
					CPtrArray* pGapArray, CPtrArray* pCodeArray)
{
	int i,nCount,con,level;
	CWidget* pWidget;
	char buf[128],subname[128];
	CString str;
	CPtrArray cellArray;
	//TMPCELLINFO* pItem;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();

	//Subsystem
	pWidget = (CWidget*) pArrWidgets->GetAt(0);
	level = pWidget->GetLevel();
	sprintf(subname, "S%d_", level);

	//SubsytemVXe
	nCount = (int)pArrWidgets->GetSize ();
	//W
	con = 0;
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] == level) {
			if(m_nJunc[i] == -1)
				con++;
		}
	}
	if(con > 0) {
		sprintf(buf, "%sCon[%d],", subname, con);
		str = _T(buf);
		SetGapBuffer(pGapArray, str);
	}

	//ꂽGapSynapse
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] == level) {
			if(m_nJunc[i] != -1) {
				pWidget = (CWidget*) pArrWidgets->GetAt(m_nJunc[i]);
				sprintf(buf, "\t\t%s%s[1],", subname, pWidget->GetName());
				str = _T(buf);
				SetGapBuffer(pGapArray, str);
			}
		}
	}

	//subsytem
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		if(pWidget->GetId() == M_SUBSYSTEM) {
			CodeGenerateGapSubsystem(pWidget, pGapArray, pCodeArray);
		}
	}
}

BOOL CExtncsDoc::SetGapBuffer(CPtrArray* pGapArray, CString str)
{
	TMPCELLINFO* pItem;
	int index;

	//obt@[ɐݒ
	try {
		pItem = new TMPCELLINFO;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return FALSE;
	}
	//@ݒ
	pItem->cell = str;
	//CfbNX
	index = (int)pGapArray->GetSize();
	//o^
	pGapArray->Add( pItem );

	return TRUE;
}


//Widget̏o͂M_GAPAM_SYNAPSEKpĂ邩?
BOOL CExtncsDoc::CheckJunction(int cell)
{
	int i;

	for(i = 0; i < m_nList; i++) {
		if(m_srcBlk[i] == cell) {
			if(m_nJunc[i] != -1)
				return TRUE;
		}
	}
	return FALSE;
}

//
//Subsystem̑SĂInport
//rootɂāAnameƖÂꂽSubsystem֌ĂCELLƂ̌
//
int CExtncsDoc::SetConnectionInport( CString name,
				int level, int nSubsystem, int con, CPtrArray* pCodeArray )
{
	int	i,j,index,order,pos,target,port;
	char buf[_MAX_PATH];
	CString str,strPort;
	CWidget* pWidget;

	index = con;
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] != level)
			continue;
		if(name.Compare(m_desName[i]) == NULL) {
			// |[gԍ
			target = m_desPort[i];
			// desNamenameł郉CTAname->Inportڑ쐬
			// m_srcName[i]
			for(j = 0; j < m_nList; j++) {
				// idInport̃CT
				if(m_lineLevel[j] != nSubsystem)
					continue;
				if(m_srcId[j] == M_INPORT) {
					// Subsystem|[gԍ
					pos = m_srcName[j].Find(_T("Inport"));
					strPort = m_srcName[j].Mid(pos+6);
					port = atoi(strPort);
					if(port+1 == target) {
						//
						//srcName[i]SubsystemɌCell
						//srcName[j]SubsystemInport Cell
						str = _T("		");
						sprintf(buf,"S%d_%s[0] < ",nSubsystem,m_srcName[j]);
						str += _T(buf);
						//srcName[i]Order
						pWidget = (CWidget*) m_arrWidgets[m_srcBlk[i]];
						order = pWidget->GetOrder();
				if(pWidget->GetId() == M_SUBSYSTEM) {
					//ǂ̃TuVXeŁA|[gԍ
					if(m_srcPort[i] == 1)
						sprintf(buf,"(Con[%d] < S%d_Outport[0]);",order, pWidget->GetLevel());
					else
						sprintf(buf,"(Con[%d] < S%d_Outport%d[0]);",order, pWidget->GetLevel(),m_srcPort[i]-1);
				}
				else {
					sprintf(buf,"(Con[%d] < %s[0]);",order, m_srcName[i]);
				}
						str += _T(buf);
						Print(pCodeArray, str);
						index++;
						break;
					}
				}
			}
		}
	}
	return index;
}

// TODO:dv
// nameW[ւ̌
// Destinationnameł錋
int CExtncsDoc::SetConnection(CWidget* pTargetWidget,
				int con, CPtrArray* pCodeArray)
{
	int i,index,level;
	char buf[_MAX_PATH];
	CString str,strTmp,name;
	int iCount,order,inport,row,column;
	CString strCell[MAX_CONNECTION];
	CWidget* pWidget;
	//CPtrArray* pName;
	//NAMEINFO* pItem;
	CString strOutName, strInName;

	//
	//Nameɓ͂SẴW[Xg
	//
	name = pTargetWidget->GetName();
	level = pTargetWidget->GetLevel();
	index = con;
	//DestinationNameł錋A܂̓|[gւ̌
	iCount = 0;
	inport = 0;
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] != level)
			continue;
		if(m_strList[i].Compare(_T("-1")) == NULL)
			continue;
		if(name.Compare(m_desName[i]) == NULL) {
			//arrow=1Ȃm_srcName[i]̓͂
			//m_srcName[i]Subsystem̏ꍇ́H
			if(m_desArrow[i] == 1) {
				//pWidget́AdesɐڑĂWidget
				pWidget = (CWidget*) m_arrWidgets[m_srcBlk[i]];
				//ordeŕApWidgetgpĂ錋q̃CfbNX
				order = pWidget->GetOrder();
				//rowAcolumnWidget̑傫
				row = pWidget->GetCellRow();
				column = pWidget->GetCellColumn();
				//m_strJunćAsrcZƂ̌qێ
				sprintf(buf,"%s < ", m_strJunc[i]);
				strCell[iCount] = _T(buf);
				if(m_srcId[i] == M_SUBSYSTEM) {
					//naméASubsystem̏o͂ƌ
					//pName = pWidget->GetOutportName();
					//pItem = (NAMEINFO*)pName->GetAt(m_srcPort[i]-1);
					//inname = pItem->strName;
					//sprintf(buf,"S%d_%s",pWidget->GetLevel(),inname);
					//m_scrPort[i]̏o̓|[g𓾂
					strOutName = SetConnectionOutport(pWidget, m_srcPort[i]);
					strCell[iCount] += strOutName/*_T(buf)*/;
					strCell[iCount] += _T("[0]");
				}
				else {
					//naméAWWidgetƌ
					strCell[iCount] += m_srcName[i];	//W
					if(m_srcPort[i] == 1)
						sprintf(buf, "[%d]", row*column-1);
					else if(m_srcPort[i] == -1) {
						//_
						sprintf(buf, "[%d]", row*column-1);

					}
					else
						sprintf(buf,"[%d]", m_srcPort[i]-2); 
					strCell[iCount] += _T(buf);
				}
				//nameZւ̓͂
				//Ex Con[1] < Step[0]
				index++;
				iCount++;
				inport++;
			}
		}
	}
	if(iCount) {
		//1sɂ܂Ƃ߂
		strTmp = _T("");
		for(i = 0; i < iCount; i++) {
			strTmp += _T("(");
			strTmp += strCell[i];
			strTmp += _T(")");
		}
		strCell[0] = strTmp;
		iCount = 1;
	}

	//SourceNameł錋Ao͂͂󂯂ꍇ
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] != level)
			continue;
		if(m_strList[i].Compare(_T("-1")) == NULL)
			continue;
		if(name.Compare(m_srcName[i]) == NULL) {
			//arrow=3Ȃm_desName[i]̓͂
			if(m_srcArrow[i] == 3) {
				sprintf(buf,"%s < %s[0]",m_strJunc[i],m_desName[i]);
				strCell[iCount] = _T(buf);
				index++;
				iCount++;
			}
		}
	}
	//nameւconnection쐬
	str = _T("\t\t");
	if(inport > 1) {
		//͂W[́Ao͂ւ̓͂֎~
		if(pTargetWidget->GetId() == M_SUBSYSTEM) {
			strInName = SetConnectionInport(pTargetWidget, inport);
			str += strInName;
		}
		else
			str += name;
		str += _T("[0] < ");
		for(i = 0; i < iCount; i++) {
			str += strCell[i];
			if(i < iCount-1)
				str += _T(" + ");
		}
		str += _T(" ;");
	}
	else {
		if(pTargetWidget->GetId() == M_SUBSYSTEM) {
			strInName = SetConnectionInport(pTargetWidget, inport);
			str += strInName;
		}
		else
			str += name;
		str += _T("[0] < (");
		for(i = 0; i < iCount; i++) {
			str += strCell[i];
			if(i < iCount-1)
				str += _T(" + ");
		}
		str += _T(" );");
	}
	Print(pCodeArray, str);

	return index;
}

CString CExtncsDoc::SetConnectionOutport(CWidget* pTargetWidget, int port)
{
	int i,size,index;
	char buf[128];
	CString strVal;
	CWidget* pWidget;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();

	strVal = _T("");
	size = (int)pArrWidgets->GetSize();
	index = 1;
	for(i = 0; i < size; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		if(pWidget->GetId() == M_OUTPORT) {
			if(index == port) {
				sprintf(buf,"S%d_%s",pWidget->GetLevel(),pWidget->GetName());
				strVal = _T(buf);
				return strVal;
			}
			index++;
		}
	}
	return strVal;
}

CString CExtncsDoc::SetConnectionInport(CWidget* pTargetWidget, int port)
{
	int i,size,index;
	char buf[128];
	CString strVal;
	CWidget* pWidget;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();

	strVal = _T("");
	size = (int)pArrWidgets->GetSize();
	index = 1;
	for(i = 0; i < size; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		if(pWidget->GetId() == M_INPORT) {
			if(index == port) {
				sprintf(buf,"S%d_%s",pWidget->GetLevel(),pWidget->GetName());
				strVal = _T(buf);
				return strVal;
			}
			index++;
		}
	}
	return strVal;
}

// TODO:dv
// nameW[ւ̌
// Destinationnameł錋
int CExtncsDoc::SetConnectionSubsystem(CWidget* pTargetWidget,		   
						int id, CString name, int con, CPtrArray* pCodeArray)
{
	int i,index,level;
	char buf[_MAX_PATH],subname[128];
	CString str,strTmp;
	int iCount,order,inport,row,column;
	CString strCell[MAX_CONNECTION];
	CWidget* pWidget;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();

	//
	//Nameɓ͂SẴW[Xg
	//
	pWidget = (CWidget*) pArrWidgets->GetAt(0);
	level = pWidget->GetLevel();
	sprintf(subname, "S%d_", level);
	index = con;
	//DestinationNameł錋A܂̓|[gւ̌
	iCount = 0;
	inport = 0;
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] != level)
			continue;
		if(m_strList[i].Compare(_T("-1")) == NULL)
			continue;
		if(name.Compare(m_desName[i]) == NULL) {
			//arrow=1Ȃm_srcName[i]̓͂
			//m_srcName[i]Subsystem̏ꍇ́H
			if(m_desArrow[i] == 1) {
				//pWidget́AdesɐڑĂWidget
				pWidget = (CWidget*) pArrWidgets->GetAt(m_srcBlk[i]);
				//ordeŕApWidgetgpĂ錋q̃CfbNX
				order = pWidget->GetOrder();
				//rowAcolumnWidget̑傫
				row = pWidget->GetCellRow();
				column = pWidget->GetCellColumn();
				//m_strJunćAsrcZƂ̌qێ
				sprintf(buf,"%s < ", m_strJunc[i]);
				strCell[iCount] = _T(buf);
				//if(m_srcId[i] == M_SUBSYSTEM) {
				//	//naméASubsystem̏o͂ƌ
				//	if(m_srcPort[i] == 1)
				//		sprintf(buf,"S%d_Outport",pWidget->GetLevel());
				//	else
				//		sprintf(buf,"S%d_Outport%d", pWidget->GetLevel(),m_srcPort[i]-1);
				//	strCell[iCount] += _T(buf);
				//	strCell[iCount] += _T("[0]");
				//}
				//else {
					//naméAWWidgetƌ
					strCell[iCount] += _T(subname);
					strCell[iCount] += m_srcName[i];	//W
					if(m_srcPort[i] == 1)
						sprintf(buf, "[%d]", row*column-1);
					else if(m_srcPort[i] == -1) {
						//_
						sprintf(buf, "[%d]", row*column-1);

					}
					else
						sprintf(buf,"[%d]", m_srcPort[i]-2); 
					strCell[iCount] += _T(buf);
				//}
				//nameZւ̓͂
				//Ex Con[1] < Step[0]
				index++;
				iCount++;
				inport++;
			}
		}
	}
	if(iCount) {
		//1sɂ܂Ƃ߂
		strTmp = _T("");
		for(i = 0; i < iCount; i++) {
			strTmp += _T("(");
			strTmp += strCell[i];
			strTmp += _T(")");
		}
		strCell[0] = strTmp;
		iCount = 1;
	}

	//SourceNameł錋Ao͂͂󂯂ꍇ
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] != level)
			continue;
		if(m_strList[i].Compare(_T("-1")) == NULL)
			continue;
		if(name.Compare(m_srcName[i]) == NULL) {
			//arrow=3Ȃm_desName[i]̓͂
			if(m_srcArrow[i] == 3) {
				sprintf(buf,"%s < %s%s[0]",m_strJunc[i],subname,m_desName[i]);
				strCell[iCount] = _T(buf);
				index++;
				iCount++;
			}
		}
	}
	//nameւconnection쐬
	str = _T("\t\t");
	if(inport > 1) {
		//͂W[́Ao͂ւ̓͂֎~
		str += _T(subname);
		str += name;
		str += _T("[0] < ");
		for(i = 0; i < iCount; i++) {
			str += strCell[i];
			if(i < iCount-1)
				str += _T(" + ");
		}
		str += _T(" ;");
		Print(pCodeArray, str);
	}
	else {
		str += _T(subname);
		str += name;
		str += _T("[0] < (");
		for(i = 0; i < iCount; i++) {
			str += strCell[i];
			if(i < iCount-1)
				str += _T(" + ");
		}
		str += _T(" );");
		//TODO:͂̂ȂW[݂
		//Subsystem̓͂̂Ȃ(iCount=0)InportĂ̂ŁAInport̏ꍇ͌͂
		if(id != M_INPORT)
			Print(pCodeArray, str);
	}

	return index;
}

// nameW[ւ̌
// Destinationnameł錋
int CExtncsDoc::SetConnectionExpand(CWidget* tWidget,
		int level, int nSubsystem, int con, CPtrArray* pCodeArray)
{
	int i,index = 0;
	char buf[_MAX_PATH];
	CString name,str,strTmp;
	int iCount,order,row,column,des_style,src_style;
	CString strCell[MAX_CONNECTION];
	CWidget* pWidget;
	int	t_row,t_column;

	//
	//Nameɓ͂SẴW[Xg
	//

	//DestinationNameł錋A܂̓|[gւ̌
	name = tWidget->GetName();
	t_row = tWidget->GetCellRow();
	t_column = tWidget->GetCellColumn();
	des_style = GetCellStyle(t_row, t_column);
	iCount = 0;
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] != level)
			continue;
		if(m_strList[i].Compare(_T("-1")) == NULL)
			continue;
		if(name.Compare(m_desName[i]) == NULL) {
			//arrow=1Ȃm_srcName[i]̓͂
			//m_srcName[i]Subsystem̏ꍇ́H
			if(m_desArrow[i] == 1) {
				pWidget = (CWidget*) m_arrWidgets[m_srcBlk[i]];
				row = pWidget->GetCellRow();
				column = pWidget->GetCellColumn();
				src_style = GetCellStyle(row, column);
if(m_desPort[i] == 1) {	//gCELL̓̓|[gւ̐ڑ
				if(des_style == COLUMN_CELL) {
					//(1) ͌
					strCell[iCount] = _T("		");
					sprintf(buf, "%s[0] < (%s < ", name, m_strJunc[i]);
					strCell[iCount] += _T(buf);
					if(m_srcId[i] == M_SUBSYSTEM) {
						//nSubsystemŎw肳ꂽSubsystem̐ڑ
						sprintf(buf,"S%d_Outport",nSubsystem);
						strCell[iCount] += _T(buf);
						strCell[iCount] += _T("[0]");
					}
					else {
			if(src_style == COLUMN_CELL) {
			//gCELL
			strCell[iCount] += m_srcName[i];
			sprintf(buf,"[%d]",column-1);
			strCell[iCount] += _T(buf);
			}
			else {
			//WCELL
			strCell[iCount] += m_srcName[i];
			strCell[iCount] += _T("[0]");
			}
					}
					//(2) (1)ɓǉ
					order = tWidget->GetOrder();
					iCount = SetConnectionExpandCell(tWidget, strCell, iCount, order);
				}
				else {	//ROW_CELLMATRIX_CELL̏ꍇ
					//Sċʂɓ
					order = pWidget->GetOrder();
					row = pWidget->GetCellRow();
					column = pWidget->GetCellColumn();
					src_style = GetCellStyle(row, column);
					if(src_style == SINGLE_CELL) {
		sprintf(buf, "for( n = 0; n <= %d; n++ ) {", t_row*t_column-1);
		str = CString("		") + _T(buf);
		strCell[iCount++] = str;
		str = _T("			");
		sprintf(buf, "%s[n] < (Con[%d] < ", name, order);
		str += _T(buf);
		str += m_srcName[i];
		str += _T("[0]);");
		strCell[iCount++] = str;
		str = CString("		") + _T("}");
		strCell[iCount++] = str;
					}
					else {
		sprintf(buf, "for( n = 0; n <= %d; n++ ) {", t_row*t_column-1);
		str = CString("		") + _T(buf);
		strCell[iCount++] = str;
		str = _T("			");
		sprintf(buf, "%s[n] < (Con[n+%d] < ", name, order);
		str += _T(buf);
		str += m_srcName[i];
		str += _T("[n]);");
		strCell[iCount++] = str;
		str = CString("		") + _T("}");
		strCell[iCount++] = str;
					}
					
				}
}
else {	//des|[g1(W|[g)ȊOւ̓͂̏ꍇ
		//gZ̔CCELLւ̌
	order = pWidget->GetOrder();
	strCell[iCount] = _T("		");
	sprintf(buf, "%s[%d] < (Con[%d] < ", name, m_desPort[i]-2, order);
	strCell[iCount] += _T(buf);
	strCell[iCount] += m_srcName[i];	//W
	strCell[iCount] += _T("[0]);");
	iCount += 1;

}
			}
		}
	}

	//o
	for(i = 0; i < iCount; i++) {
		Print(pCodeArray, strCell[i]);
	}

	return index;
}

//gCELL̓
int CExtncsDoc::SetConnectionExpandCell(CWidget* pWidget, CString strCell[], int iCount, int order)
{
	int	row,column,count/*,order*/,junc,connect;
	char buf[_MAX_PATH];
	CString str,name,strJunc;
	BLOCKINFO* pItem;
	
	count = iCount;
	row = pWidget->GetCellRow();
	column = pWidget->GetCellColumn();
	//order = pWidget->GetOrder();
	name = pWidget->GetName();
	junc = pWidget->GetJunction();
	connect = pWidget->GetConnect();

	if(junc == -1) {
		//ftHǧqgp
		//
		switch(connect) {
		case	CONNECT_OUT:
			//̓Z
			strCell[count++] += _T(");");
			//for
			sprintf(buf, "for( n = 1; n <= %d; n++ ) {", column-1);
			str = CString("		") + _T(buf);
			strCell[count++] = str;
			//Inner
			sprintf(buf, "%s[n] < ( Con[%d+n-1] < %s[n-1] );",
						name, order, name);
			str = CString("			") + _T(buf);
			strCell[count++] = str;
			//}
			str = CString("		") + _T("}");
			strCell[count++] = str;
			break;
		case	CONNECT_IN:
			break;
		case	CONNECT_CROSS:
			//Initial
			sprintf(buf, " + Con[%d] < %s[1] );",
						order, name);
			strCell[count++] += _T(buf);
			//for
			sprintf(buf, "for( n = 1; n <= %d; n++ ) {", column-2);
			str = CString("		") + _T(buf);
			strCell[count++] = str;
			//Inner
			sprintf(buf, "%s[n] < ( Con[%d+n-1] < %s[n-1] + Con[%d+n] < %s[n+1] );",
						name, order, name, order, name);
			str = CString("			") + _T(buf);
			strCell[count++] = str;
			//}
			str = CString("		") + _T("}");
			strCell[count++] = str;
			//Finish
			sprintf(buf, "%s[%d] < ( Con[%d] < %s[%d] );",
						name, column-1, order+column-2, name, column-2);
			str = CString("		") + _T(buf);
			strCell[count++] = str;
			break;
		}

	}
	else {	
		//gZŗLJunctionꍇ̓ڑ
		//1. JunctionstrName
		strJunc = pWidget->GetName();
		pItem = (BLOCKINFO*)g_pExtncsMain->m_blockArray.GetAt(junc);
		strJunc += _T("_");
		strJunc += pItem->name;

		//
		switch(connect) {
		case	CONNECT_OUT:
			//̓Z
			strCell[count++] += _T(");");
			//for
			sprintf(buf, "for( n = 1; n <= %d; n++ ) {", column-1);
			str = CString("		") + _T(buf);
			strCell[count++] = str;
			//Inner
			sprintf(buf, "%s[n] < ( %s[n-1] < %s[n-1] );",
						name, strJunc, name);
			str = CString("			") + _T(buf);
			strCell[count++] = str;
			//}
			str = CString("		") + _T("}");
			strCell[count++] = str;
			break;
		case	CONNECT_IN:
			break;
		case	CONNECT_CROSS:
			//Initial
			sprintf(buf, " + %s[0] < %s[1] );",
						strJunc, name);
			strCell[count++] += _T(buf);
			//for
			sprintf(buf, "for( n = 1; n <= %d; n++ ) {", column-2);
			str = CString("		") + _T(buf);
			strCell[count++] = str;
			//Inner
			sprintf(buf, "%s[n] < ( %s[n-1] < %s[n-1] + %s[n] < %s[n+1] );",
						name, strJunc, name, strJunc, name);
			str = CString("			") + _T(buf);
			strCell[count++] = str;
			//}
			str = CString("		") + _T("}");
			strCell[count++] = str;
			//Finish
			sprintf(buf, "%s[%d] < ( %s[%d] < %s[%d] );",
						name, column-1, strJunc, column-2, name, column-2);
			str = CString("		") + _T(buf);
			strCell[count++] = str;
			break;
		}
	}

	return count;
}

// nameW[ւ̌
// Destinationnameł錋
int CExtncsDoc::SetSubsystemConnection(CString name,
			int level, CWidget* pWidget, int con, CPtrArray* pCodeArray)
{
	int i,index;
	char buf[_MAX_PATH];
	CString str,strTmp;
	int iCount,order,inport;
	CString strCell[MAX_CONNECTION];
	CPtrArray* pSubsysWidgets;
	SUBSYSWIDGET* wItem;

	// Subsystem̃|C^[
	pSubsysWidgets = pWidget->GetSubsysWidgets();

	//
	//Nameɓ͂SẴW[Xg
	//

	index = con;
	//DestinationNameł錋A܂̓|[gւ̌
	iCount = 0;
	inport = 0;
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] != level)
			continue;
		if(m_strList[i].Compare(_T("-1")) == NULL)
			continue;
		if(name.Compare(m_desName[i]) == NULL) {
			//arrow=1Ȃm_srcName[i]̓͂
			if(m_desArrow[i] == 1) {
				wItem = (SUBSYSWIDGET*)pSubsysWidgets->GetAt(m_srcBlk[i]);
				order = wItem->order;
				sprintf(buf, "S%d_Con[%d] < ", level,order);
				strCell[iCount] = _T(buf);
				sprintf(buf, "S%d_%s", level,m_srcName[i]);
				strCell[iCount] += _T(buf);
				strCell[iCount] += _T("[0]");
				index++;
				iCount++;
				inport++;
			}
		}
	}
	if(iCount) {
		//1sɂ܂Ƃ߂
		strTmp = _T("");
		for(i = 0; i < iCount; i++) {
			strTmp += _T("(");
			strTmp += strCell[i];
			strTmp += _T(")");
		}
		strCell[0] = strTmp;
		iCount = 1;
	}

	//SourceNameł錋
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] != level)
			continue;
		if(m_strList[i].Compare(_T("-1")) == NULL)
			continue;
		if(name.Compare(m_srcName[i]) == NULL) {
			//arrow=3Ȃm_desName[i]̓͂
			if(m_srcArrow[i] == 3) {
				wItem = (SUBSYSWIDGET*)pSubsysWidgets->GetAt(m_srcBlk[i]);
				order = wItem->order;
				sprintf(buf, "S%d_Con[%d] < ", level,order);
				strCell[iCount] = _T(buf);
				sprintf(buf, "S%d_%s", level,m_desName[i]);
				strCell[iCount] += _T(buf);
				strCell[iCount] += _T("[0]");
				index++;
				iCount++;
			}
		}
	}
	//nameւconnection쐬
	str = _T("		");
	if(inport > 1) {
		//͂W[́Ao͂ւ̓͂֎~
		sprintf(buf,"S%d_%s",level,name);
		str += _T(buf);
		str += _T("[0] < ");
		for(i = 0; i < iCount; i++) {
			str += strCell[i];
			if(i < iCount-1)
				str += _T(" + ");
		}
		str += _T(" ;");
	}
	else {
		sprintf(buf,"S%d_%s",level,name);
		str += _T(buf);
		str += _T("[0] < (");
		for(i = 0; i < iCount; i++) {
			str += strCell[i];
			if(i < iCount-1)
				str += _T(" + ");
		}
		str += _T(" );");
	}
	Print(pCodeArray, str);

	return index;
}

BOOL CExtncsDoc::CodeGenerateConnection(CPtrArray* pCodeArray)
{
	Print( pCodeArray, "connection:" );

	//VXẻ͏
	SetWidgetOrder(pCodeArray);

	//Widget
	int i,nCount,id,nSubsystem,root,level;
	CString name;
	CWidget* pWidget;
	CString str;
	BOOL flag;
	int	order,index,con = 0;	//W[̃CfbNX
	int row,column;

	// RootVXe
	root = 0;
	nSubsystem = 0;
	nCount = (int)m_arrWidgets.GetSize ();
	index = 0;
	for(;;) {
		//SĂWidgetɑ΂ďI?
		flag = TRUE;
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) m_arrWidgets[i];
			if(pWidget->GetId() == M_TITLE)
				continue;
			order = pWidget->GetSearch();
			if(order != -1) {
				flag = FALSE;
				break;
			}
		}
		if(flag)
			break;	//SĂWidget}[NĂ̂exit

		//indexԖڂWidgetւ̌
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) m_arrWidgets[i];
			if(pWidget->GetId() == M_TITLE)
				continue;
			order = pWidget->GetSearch();
			row = pWidget->GetCellRow();
			column = pWidget->GetCellColumn();
			if(order == index) {
				//nameWidgetւ̌쐬
				id = pWidget->GetId();
				name = pWidget->GetName();
				level = pWidget->GetLevel();
				if(row*column == 1)
					con = SetConnection( pWidget, con, pCodeArray );
				else
					con = SetConnectionExpand( pWidget, root, level, con, pCodeArray );
				pWidget->SetSearch(-1);
			}
		}
		index++;	//̃I[_[
	}

	// SubsystemVXe
	nCount = (int)m_arrWidgets.GetSize ();
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		if(pWidget->GetId() == M_SUBSYSTEM)
			CodeGenerateConnectionSubsystem(pWidget, pCodeArray);
	}

	return TRUE;
}

BOOL CExtncsDoc::CodeGenerateConnectionSubsystem(CWidget* pTargetWidget, CPtrArray* pCodeArray)
{
	//VXẻ͏
	SetSubsystemOrder(pTargetWidget, pCodeArray);

	//Widget
	int i,nCount,id,nSubsystem,root,level;
	CString name;
	CWidget* pWidget;
	CString str;
	BOOL flag;
	int	order,index,con = 0;	//W[̃CfbNX
	int row,column;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();

	// SubsystemVXe
	root = 0;
	nSubsystem = 0;
	nCount = (int)pArrWidgets->GetSize ();
	index = 0;
	for(;;) {
		//SĂWidgetɑ΂ďI?
		flag = TRUE;
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) pArrWidgets->GetAt(i);
			if(pWidget->GetId() == M_TITLE)
				continue;
			order = pWidget->GetSearch();
			if(order != -1) {
				flag = FALSE;
				break;
			}
		}
		if(flag)
			break;	//SĂWidget}[NĂ̂exit

		//indexԖڂWidgetւ̌
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) pArrWidgets->GetAt(i);
			if(pWidget->GetId() == M_TITLE)
				continue;
			order = pWidget->GetSearch();
			row = pWidget->GetCellRow();
			column = pWidget->GetCellColumn();
			if(order == index) {
				//nameWidgetւ̌쐬
				id = pWidget->GetId();
				name = pWidget->GetName();
				level = pWidget->GetLevel();
				if(row*column == 1)
					con = SetConnectionSubsystem( pTargetWidget, id, name, con, pCodeArray );
				else
					con = SetConnectionExpand( pWidget, root, level, con, pCodeArray );
				pWidget->SetSearch(-1);
			}
		}
		index++;	//̃I[_[
	}

	// SubsystemVXe
	nCount = (int)pArrWidgets->GetSize ();
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		if(pWidget->GetId() == M_SUBSYSTEM)
			CodeGenerateConnectionSubsystem(pWidget, pCodeArray);
	}

	return TRUE;
}

int CExtncsDoc::GetCellStyle(int row, int column)
{
	if(row == 1 && column == 1)
		return SINGLE_CELL;
	else if(row == 1 && column > 1)
		return COLUMN_CELL;
	else if(row > 1 && column == 1)
		return ROW_CELL;
	else if(row > 1 && column > 1)
		return MATRIX_CELL;
	return SINGLE_CELL;
}

// SCACԂ
// 
//	srcArrow	<->		desArrow		
//	srcRow		<->		desRow
//	srcColumn	<->		desColumn
//	srcId		<->		desId			Idɂڑ
//	srcName		<->		desName			Cellɂڑ
//	srcBlk		<->		desBlk			Cellԍɂڑ
//	srcPort		<->		desPort			|[gԍɂڑ
//	strJunćALiněq̋Lq
//	nJunćALiněqCellԍ

int CExtncsDoc::CodeGenerateLineList(CPtrArray* pCodeArray)
{
	int	i,j,nCount,sblk,eblk,arrow,lCount,inport,outport,junc;
	CWidget *pSWidget, *pEWidget;
	CLine *pLine;
	char buf[256];
	CString src, des;
	int addr, index, nIndex, id;
	//CPtrArray* pSubsysLines;
	//SUBSYSLINE* lItem;
	//CPtrArray* pSubsysWidgets;
	//SUBSYSWIDGET *swItem, *ewItem;
	int defaultIndex = 0;
	BOOL	equal;

	//RootVXeLineXg쐬
	addr = nIndex = -1;
	lCount = (int)m_arrLines.GetSize ();
	for(i = 0; i < lCount; i++) {
		pLine = (CLine*) m_arrLines[i];
		//srcCELLԍ
		sblk = pLine->GetSblk();
		pSWidget = (CWidget*) m_arrWidgets[sblk];
		//desCELLԍ
		eblk = pLine->GetEblk();
		pEWidget = (CWidget*) m_arrWidgets[eblk];
		//Line̖
		arrow = pLine->GetArrow();
		//Linedes̓̓|[gԍ
		inport = pLine->GetInport();
		//Linesrc̏o̓|[gԍ
		outport = pLine->GetOutport();
		//Liněq
		junc = pLine->GetJunction();
		//index0Ԃn܂킯ł͂Ȃ
		index = pLine->GetIndex();
		if(nIndex != index) {	//LineIndexقȂA܂n_
			nIndex = index;
			addr++;
			//
			m_lineLevel[addr] = pSWidget->GetLevel();
			des = pEWidget->GetName();
			src = pSWidget->GetName();
			sprintf(buf,"%s < %s", des, src);
			m_strList[addr] = _T(buf);
			//Line̐ڑ
			m_srcArrow[addr] = arrow;
			m_desRow[addr] = pEWidget->GetCellRow();
			m_desColumn[addr] = pEWidget->GetCellColumn();
			m_desId[addr] = pEWidget->GetId();
			m_desName[addr] = des;
			m_srcRow[addr] = pSWidget->GetCellRow();
			m_srcColumn[addr] = pSWidget->GetCellColumn();
			m_srcId[addr] = pSWidget->GetId();
			m_srcName[addr] = src;
			//łɁAĂubN
			m_srcBlk[addr] = sblk;
			m_desBlk[addr] = eblk;
			//|[gԍ
			m_srcPort[addr] = outport;
			m_desPort[addr] = inport;
			//LineɓKpĂ錋qCfbNX
			m_nJunc[addr] = junc;
			//CoñCfbNXݒ
			if(m_nJunc[addr] == -1) {
				if(pSWidget->GetOrder() == -1) {
					pSWidget->SetOrder(defaultIndex);
					if(pSWidget->GetJunction() == -1)
						defaultIndex += (m_srcColumn[addr]*m_srcRow[addr]);
					else
						defaultIndex += 1;
				}
				// TODO:̃Rgs
				//if(pEWidget->GetOrder() == -1) {
				//	pEWidget->SetOrder(defaultIndex);
				//	if(pEWidget->GetJunction() == -1)
				//		defaultIndex += (m_desColumn[addr]*m_desRow[addr]);
				//	else
				//		defaultIndex += 1;
				//}
			}
		}
		else {	//LineIndexÂݐݒ
			m_desArrow[addr] = arrow;
		}
	}
	// addr̃C݂邱ƂɂȂ
	// eČqݒ肷
	// n߂ɁABranch܂߂Ȃq
	for(i = 0; i <= addr; i++) {
		m_nDefaultJunc[i] = -1;
		if(m_srcArrow[i] != 2) {	// branchłȂ
			if(m_nJunc[i] == -1) {
				pSWidget = (CWidget*) m_arrWidgets[m_srcBlk[i]];
				defaultIndex = pSWidget->GetOrder();
				if(pSWidget->GetJunction() == -1) {
					if(m_srcColumn[i]*m_srcRow[i] > 1)
						sprintf(buf,"Con[%d]",defaultIndex+m_srcColumn[i]*m_srcRow[i]-1);
					else
						sprintf(buf,"Con[%d]",defaultIndex);
				}
				else
					sprintf(buf,"Con[%d]",defaultIndex);
				m_strJunc[i] = _T(buf);
				m_nDefaultJunc[i] = defaultIndex;
			}
			else {	//M_GAPM_SYNAPSE`
				pSWidget = (CWidget*) m_arrWidgets[m_nJunc[i]];
				sprintf(buf,"%s[0]",pSWidget->GetName());
				m_strJunc[i] = _T(buf);
			}
		}
		else
			m_strJunc[i] = _T("");
	}
	// āABranchC
	for(i = 0; i <= addr; i++) {
		if(m_srcArrow[i] == 2) {	// branch
			//Am_srcBlkCT
			equal = FALSE;
			for(j = 0; j < addr; j++) {
				if(i == j)
					continue;
				if(m_srcBlk[i] == m_srcBlk[j]) {
					if(m_strJunc[j].GetLength() > 0) {
						equal = TRUE;
						break;
					}
				}
			}
			if(!equal)
				return -1;		//G[
			m_strJunc[i] = m_strJunc[j];
			m_nDefaultJunc[i] = m_nDefaultJunc[j];
		}
	}
	//
	// Subsystem
	//
	nCount = (int)m_arrWidgets.GetSize ();
	for(i = 0; i < nCount; i++) {
		pSWidget = (CWidget*) m_arrWidgets[i];
		id = pSWidget->GetId();
		if(id == M_TITLE)
			continue;
		if(id == M_SUBSYSTEM) {
			addr = CodeGenerateLineListSubsystem(pSWidget, addr);
		}
	}
	// SẴC
	nIndex = addr+1;

#if 0
	//LineXg\CfobOp
	Print(pCodeArray, "strJunc:");
	for(i = 0; i < nIndex; i++) {
		sprintf(buf,"%s, %s, %s, %d, %d", m_srcName[i], m_desName[i], m_strJunc[i],
			m_nDefaultJunc[i], m_nJunc[i]);
		Print( pCodeArray, buf );
	}
	//Print("Order:");
	//for(i = 0; i < GetWidgetCount(); i++) {
	//	sprintf(buf,"%s -> %d",
	//		GetWidget(i)->GetName(), GetWidget(i)->GetOrder());
	//	Print( buf );
	//}
#endif

	//LineԂ
	return nIndex;
}

// SubsystemLine
// pTargetWidget:Subsystem
// baseaddr:݂܂łɌoꂽLine
int CExtncsDoc::CodeGenerateLineListSubsystem(CWidget* pTargetWidget, int baseaddr)
{
	int	i,j,nCount,sblk,eblk,arrow,lCount,inport,outport,junc;
	CWidget *pSWidget, *pEWidget;
	CLine *pLine;
	char buf[256],subname[64];
	CString src, des;
	int addr, index, nIndex = -1, id;
	//SUBSYSLINE* lItem;
	//CPtrArray* pSubsysWidgets;
	//SUBSYSWIDGET *swItem, *ewItem;
	int defaultIndex = 0;
	BOOL	equal;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();
	CPtrArray* pArrLines = pTargetWidget->GetLinesPointer();

	//Subsystem
	pSWidget = (CWidget*) pArrWidgets->GetAt(0);
	sprintf(subname,"S%d_", pSWidget->GetLevel());
	//Subsystem̃gbvVXeLineXg쐬
	addr = baseaddr;
	lCount = (int)pArrLines->GetSize ();
	for(i = 0; i < lCount; i++) {
		pLine = (CLine*) pArrLines->GetAt(i);
		//srcCELLԍ
		sblk = pLine->GetSblk();
		pSWidget = (CWidget*) pArrWidgets->GetAt(sblk);
		//desCELLԍ
		eblk = pLine->GetEblk();
		pEWidget = (CWidget*) pArrWidgets->GetAt(eblk);
		//Line̖
		arrow = pLine->GetArrow();
		//Linedes̓̓|[gԍ
		inport = pLine->GetInport();
		//Linesrc̏o̓|[gԍ
		outport = pLine->GetOutport();
		//Liněq
		junc = pLine->GetJunction();
		//index0Ԃn܂킯ł͂Ȃ
		index = pLine->GetIndex();
		if(nIndex != index) {	//LineIndexقȂA܂n_
			nIndex = index;
			addr++;
			//
			m_lineLevel[addr] = pSWidget->GetLevel();
			des = pEWidget->GetName();
			src = pSWidget->GetName();
			sprintf(buf,"%s < %s", des, src);
			m_strList[addr] = _T(buf);
			//Line̐ڑ
			m_srcArrow[addr] = arrow;
			m_desRow[addr] = pEWidget->GetCellRow();
			m_desColumn[addr] = pEWidget->GetCellColumn();
			m_desId[addr] = pEWidget->GetId();
			m_desName[addr] = des;
			m_srcRow[addr] = pSWidget->GetCellRow();
			m_srcColumn[addr] = pSWidget->GetCellColumn();
			m_srcId[addr] = pSWidget->GetId();
			m_srcName[addr] = src;
			//łɁAĂubN
			m_srcBlk[addr] = sblk;
			m_desBlk[addr] = eblk;
			//|[gԍ
			m_srcPort[addr] = outport;
			m_desPort[addr] = inport;
			//LineɓKpĂ錋qCfbNX
			m_nJunc[addr] = junc;
			//CoñCfbNXݒ
			if(m_nJunc[addr] == -1) {
				if(pSWidget->GetOrder() == -1) {
					pSWidget->SetOrder(defaultIndex);
					if(pSWidget->GetJunction() == -1)
						defaultIndex += (m_srcColumn[addr]*m_srcRow[addr]);
					else
						defaultIndex += 1;
				}
				// TODO:̃Rgs
				//if(pEWidget->GetOrder() == -1) {
				//	pEWidget->SetOrder(defaultIndex);
				//	if(pEWidget->GetJunction() == -1)
				//		defaultIndex += (m_desColumn[addr]*m_desRow[addr]);
				//	else
				//		defaultIndex += 1;
				//}
			}
		}
		else {	//LineIndexÂݐݒ
			m_desArrow[addr] = arrow;
		}
	}
	// addr̃C݂邱ƂɂȂ
	// eČqݒ肷
	// n߂ɁABranch܂߂Ȃq
	for(i = baseaddr+1; i <= addr; i++) {
		m_nDefaultJunc[i] = -1;
		if(m_srcArrow[i] != 2) {	// branchłȂ
			if(m_nJunc[i] == -1) {
				pSWidget = (CWidget*) pArrWidgets->GetAt(m_srcBlk[i]);
				defaultIndex = pSWidget->GetOrder();
				if(pSWidget->GetJunction() == -1) {
					if(m_srcColumn[i]*m_srcRow[i] > 1)
						sprintf(buf,"%sCon[%d]",subname, defaultIndex+m_srcColumn[i]*m_srcRow[i]-1);
					else
						sprintf(buf,"%sCon[%d]",subname, defaultIndex);
				}
				else
					sprintf(buf,"%sCon[%d]",subname, defaultIndex);
				m_strJunc[i] = _T(buf);
				m_nDefaultJunc[i] = defaultIndex;
			}
			else {	//M_GAPM_SYNAPSE`
				pSWidget = (CWidget*) pArrWidgets->GetAt(m_nJunc[i]);
				sprintf(buf,"%s%s[0]",subname, pSWidget->GetName());
				m_strJunc[i] = _T(buf);
			}
		}
		else
			m_strJunc[i] = _T("");
	}
	// āABranchC
	for(i = baseaddr+1; i <= addr; i++) {
		if(m_srcArrow[i] == 2) {	// branch
			//Am_srcBlkCT
			equal = FALSE;
			for(j = 0; j < addr; j++) {
				if(i == j)
					continue;
				if(m_srcBlk[i] == m_srcBlk[j]) {
					if(m_strJunc[j].GetLength() > 0) {
						equal = TRUE;
						break;
					}
				}
			}
			if(!equal)
				return -1;		//G[
			m_strJunc[i] = m_strJunc[j];
			m_nDefaultJunc[i] = m_nDefaultJunc[j];
		}
	}
	//
	// SubsystemSubsystem
	//
	nCount = (int)pArrWidgets->GetSize ();
	for(i = 0; i < nCount; i++) {
		pSWidget = (CWidget*) pArrWidgets->GetAt(i);
		id = pSWidget->GetId();
		if(id == M_TITLE)
			continue;
		if(id == M_SUBSYSTEM) {
			addr = CodeGenerateLineListSubsystem(pSWidget, addr);
		}
	}

	return addr;
}

//RootVXeWidget쐬
void CExtncsDoc::SetWidgetOrder(CPtrArray* pCodeArray)
{
	int nCount,i,order,j,id;
	BOOL flag;
	CWidget *pWidget;
	CString name,sname,dname;
	//char buf[256];
	nCount = (int)m_arrWidgets.GetSize ();

	//orderNA
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		pWidget->SetSearch(-1);
	}

	// ͂̂ȂW[́Aorder=0ɐݒ
	order = 0;
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		//M_GAPAM_SYNAPSEO
		id = pWidget->GetId();
		if(id == M_TITLE)
			continue;
		if(id == M_GAP || id == M_SYNAPSE)
			continue;
		name = pWidget->GetName();
		//namem_desName[i]
		flag = FALSE;
		for(j = 0; j < m_nList; j++) {
			if(m_lineLevel[j] != 0)
				continue;		//Root
			if(name.Compare(m_desName[j]) == NULL) {
				flag = TRUE;
				break;
			}
		}
		if(!flag) {
			//̓W[
			pWidget->SetSearch( 0 );
			//֌WĂ錋ɉordert
			order = SetWidgetOrderSearch( name, order );
		}
		//Subsystemւ̏
		//if(id == M_SUBSYSTEM)
		//	SetSubsystemOrder(pWidget);
	}

	// emF
#if 0
	Print(pCodeArray,"**** Order ****");
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		sprintf(buf,"%s -> %d",pWidget->GetName(),pWidget->GetSearch());
		Print(pCodeArray, buf);
	}
#endif
}

int CExtncsDoc::SetWidgetOrderSearch(CString name, int origin)
{
	CString start;
	int i,order;
	CWidget* pWidget;

	order = origin;
	start = name;
	//\[Xnamelinesearch
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] != 0)
			continue;	//Root
		if(name.Compare(m_srcName[i]) == NULL) {
			//̃CfbNXŎwm_desBlk[i]WidgetĂ
			pWidget = (CWidget*) m_arrWidgets[m_desBlk[i]];
			if(pWidget->GetSearch()  == -1) {
				//܂ݒ
				order++;
				pWidget->SetSearch(order);
				order = SetWidgetOrderSearch(m_desName[i], order);
			}
		}
	}
	return order;
}

//SubsystemVXeWidget쐬
void CExtncsDoc::SetSubsystemOrder(CWidget* pTargetWidget, CPtrArray* pCodeArray)
{
	int i,nCount,j,level,order,id;
	CString name;
	BOOL flag;
	CWidget* pWidget;
	//char buf[256];
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();

	//Subsystem
	pWidget = (CWidget*) pArrWidgets->GetAt(0);
	level = pWidget->GetLevel();
	nCount = (int)pArrWidgets->GetSize();

	//searchNA
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		pWidget->SetSearch(-1);
	}

	// ͂̂ȂW[́Aorder=0ɐݒ
	order = 0;
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*)pArrWidgets->GetAt(i);
		//M_GAPAM_SYNAPSEO
		id = pWidget->GetId();
		if(id == M_TITLE)
			continue;
		if(id == M_GAP || id == M_SYNAPSE)
			continue;
		name = pWidget->GetName();
		//namem_desName[i]
		flag = FALSE;
		for(j = 0; j < m_nList; j++) {
			if(m_lineLevel[j] != level)
				continue;
			if(name.Compare(m_desName[j]) == NULL) {
				flag = TRUE;
				break;
			}
		}
		if(!flag) {
			//̓W[
			pWidget->SetSearch(0);
			//֌WĂ錋ɉordert
			order = SetSubsystemOrderSearch( pTargetWidget, level, name, order );
		}
		//Subsystemւ̏
		if(id == M_SUBSYSTEM)
			SetSubsystemOrder(pWidget, pCodeArray);
	}

	// emF
#if 0
	Print(pCodeArray, "**** Subsystem Order ****");
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*)pArrWidgets->GetAt(i);
		sprintf(buf,"%s -> %d",pWidget->GetName(),pWidget->GetSearch());
		Print(pCodeArray, buf);
	}
#endif
}

int CExtncsDoc::SetSubsystemOrderSearch(CWidget* pTargetWidget, int level, CString name, int origin)
{
	CString start;
	int i,order;
	CWidget* pWidget;
	CPtrArray* pArrWidgets;

	//Subsystem|C^[
	pArrWidgets = pTargetWidget->GetWidgetsPointer();

	order = origin;
	start = name;
	//\[Xnamelinesearch
	for(i = 0; i < m_nList; i++) {
		if(m_lineLevel[i] != level)
			continue;
		if(name.Compare(m_srcName[i]) == NULL) {
			//̃CfbNXŎwm_desBlk[i]WidgetĂ
			pWidget = (CWidget*) pArrWidgets->GetAt(m_desBlk[i]);
			if(pWidget->GetSearch()  == -1) {
				//܂ݒ
				order++;
				pWidget->SetSearch(order);
				order = SetSubsystemOrderSearch(pTargetWidget, level, m_desName[i], order);
			}
		}
	}
	return order;
}

void CExtncsDoc::CodeGeneratePrint() 
{
	char openfile[256];
	FILE *fp;
	char linebuf[256];
	char *cptr;

	strcpy(openfile, m_ExtncsName);
	cptr = strstr(openfile, ".sig");
	*cptr = '\0';
	strcat(openfile, ".mdl");

	if((fp = fopen(openfile, "r")) != NULL) {
		while(!feof(fp)) {
			if(fgets(linebuf, _MAX_PATH, fp) == NULL)
				break;
			linebuf[strlen(linebuf)-1] = '\0';
			// m_pOutVieẃAgpȂ
			//g_pExtncsMain->m_pOutView->Print( linebuf );
			printf("%s\n", linebuf);
		}
		fclose(fp);
	}

}

