/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: BlockView.cpp,v 1.3 2004/08/02 07:16:12 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "BlockView.h"
#include "ModelDoc.h"
#include "ExtncsDoc.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"
#include <vfw.h>
#include "shell/satellite4.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef __cplusplus
extern "C" {
#endif
__declspec(dllimport) BOOL NcsdefExec(HANDLE hStdioW,
			CDocument* pDocument,
			CView* pConsoleView,
			CView* pModelView, CString szGroup);
#ifdef __cplusplus
}
#endif

//O[o
extern CExtncsMain*	g_pExtncsMain;


/////////////////////////////////////////////////////////////////////////////
// CBlockView

IMPLEMENT_DYNCREATE(CBlockView, CListView)

CBlockView::CBlockView()
{
	m_bImageList = FALSE;		//ImageList͏ĂȂ
	m_DragImage = NULL;
	m_pImageList = NULL;
	int i;
	for(i = 0; i < MAX_BITMAP_IMAGE; i++)
		m_pBitmap[i] = NULL;
}

CBlockView::~CBlockView()
{
	int i;
	if(m_pImageList)
		delete m_pImageList;
	for(i = 0; i < MAX_BITMAP_IMAGE; i++) {
		if(m_pBitmap[i])
			delete m_pBitmap[i];
	}
}


BEGIN_MESSAGE_MAP(CBlockView, CListView)
	//{{AFX_MSG_MAP(CBlockView)
	ON_WM_DESTROY()
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnGetdispinfo)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_NOTIFY_REFLECT(LVN_BEGINDRAG, OnBegindrag)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_MODEL_DELETE, OnModelDelete)
	ON_UPDATE_COMMAND_UI(ID_MODEL_DELETE, OnUpdateModelDelete)
	ON_COMMAND(ID_MODEL_EDIT, OnModelEdit)
	ON_UPDATE_COMMAND_UI(ID_MODEL_EDIT, OnUpdateModelEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBlockView `

void CBlockView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: ̈ʒuɕ`p̃R[hǉĂ
}

/////////////////////////////////////////////////////////////////////////////
// CBlockView ff

#ifdef _DEBUG
void CBlockView::AssertValid() const
{
	CListView::AssertValid();
}

void CBlockView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBlockView bZ[W nh

BOOL CBlockView::PreCreateWindow(CREATESTRUCT& cs) 
{
    cs.style &= ~LVS_TYPEMASK;
    cs.style |= LVS_REPORT;
	
	return CListView::PreCreateWindow(cs);
}

void CBlockView::OnInitialUpdate() 
{
	CListView::OnInitialUpdate();
	
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
}

void CBlockView::InitialImagelist()
{

	// Initialize the image list.
	CDC *pDC;//ʏ̃foCXReLXgi[|C^
	int	i;
	CDC	dcMem;
	CBitmap *pOldBitmap;
	void *bitmap;
	HDC hDCMem;
	BOOL bRet;
	int nCount;
	BLOCKINFO *pItem;
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	DWORD bfOffBits;

	// ݂DC߲擾
	pDC=GetDC();
	// ʏDCƃDCɌ݊
	dcMem.CreateCompatibleDC(pDC);

	m_pImageList = new CImageList();
	ASSERT(m_pImageList != NULL);    // serious allocation failure checking
	bRet = m_pImageList->Create(32, 32, TRUE, MAX_BITMAP_IMAGE, MAX_BITMAP_IMAGE);

	nCount = (int)g_pExtncsMain->m_blockArray.GetSize();
	for(i = 0; i < nCount; i++) {
		//ubN
		pItem = (BLOCKINFO *)(g_pExtncsMain->m_blockArray.GetAt( i ));
		// rbg}bvIuWFNg̓Im
		m_pBitmap[i] = new CBitmap();
		// ʏDČ݊̂ޯϯ߂؏ɍ쐬
		m_pBitmap[i]->CreateCompatibleBitmap(pDC, 32, 32);
		//ޯϯ߂DC̊֘At
		pOldBitmap = dcMem.SelectObject(m_pBitmap[i]);
		// rbg}bvt@C
		GetModuleDirectory(modulepath, _MAX_PATH);
		if(pItem->fBitmap.GetLength() == 0)
			sprintf(file, "%s\\ncs\\bmp\\default.bmp", modulepath);
		else
			sprintf(file, "%s\\ncs\\bmp\\%s", modulepath, pItem->fBitmap);
		bitmap = LoadBitmapFile(file, &bfOffBits);
		// HDC
		hDCMem = dcMem.GetSafeHdc();
		// rbg}bv̕`
		StretchDIBits(hDCMem,
			0, 0, 32, 32,
			0, 0, 32, 32,
			(BYTE *)(bitmap) + bfOffBits - sizeof(BITMAPFILEHEADER),
			(BITMAPINFO*)bitmap,
			DIB_RGB_COLORS,
			SRCCOPY);
		//̂Bitmapɖ߂
		dcMem.SelectObject(pOldBitmap);

		if(bitmap)
			delete bitmap;
	}


	//DC
	ReleaseDC(pDC);

	//C[WXgɒǉ
	for(i = 0; i < nCount; i++) {
		m_pImageList->Add(m_pBitmap[i], RGB(255,255,255));
	}

    GetListCtrl ().SetImageList (m_pImageList, LVSIL_NORMAL);

	// ŏ͉ݒ肳ĂȂ
	m_moduleType = MODULE_NULL;

	//傫ACRɐݒ肵Ă
    ModifyStyle (LVS_TYPEMASK, LVS_ICON);
}

void * CBlockView::LoadBitmapFile(LPCTSTR lpszPathName, DWORD *bfOffBits)
{
	char msgbuf[_MAX_PATH];
	CFile file;
	BITMAPFILEHEADER bmpHeader;
	unsigned long fileSize, leftSize;
	void *bitmap;

	// I[v
	if (file.Open(lpszPathName, CFile::modeRead | CFile::shareDenyWrite) == FALSE) {
		sprintf(msgbuf, "%s̃I[vɎs܂", lpszPathName);
		AfxMessageBox(msgbuf, MB_OK, NULL);
		return NULL;
	}

	// t@C̒
	fileSize = (unsigned long)file.GetLength();

	// rbg}bvwb_[̎擾
	if (file.Read((LPSTR)&bmpHeader, BMP_HEADER_SIZE) != BMP_HEADER_SIZE)
		return NULL;
	*bfOffBits = bmpHeader.bfOffBits;

	// rbg}bvt@Cł邱Ƃ̊mFibfType=="BM" ?j
	if (bmpHeader.bfType != BMP_HEADER_ID) {
		AfxMessageBox(_T("BITMAPł͂܂"));
		return NULL;
	}

	// [hp̊m
	bitmap = (void*)new char[fileSize];

	// rbg}bv̓ǂݍ
	leftSize = fileSize - BMP_HEADER_SIZE;
	if (file.Read(bitmap, leftSize) != leftSize) {
		delete bitmap;
		return NULL;
	}

	file.Close();

	return bitmap;
}

BYTE * CBlockView::GetBitmapBits(void *bitmap)
{
	DWORD numOfColors;
	BITMAPINFOHEADER *pBitmap = (BITMAPINFOHEADER*)bitmap;
	WORD bitCount = pBitmap->biBitCount;

	if (pBitmap->biSize >= 36)
		numOfColors = pBitmap->biClrUsed;
	else
		numOfColors = 0;

	if (numOfColors == 0 && bitCount != 24) 
			numOfColors = 1L << bitCount;

	return (BYTE*)pBitmap + pBitmap->biSize + numOfColors * sizeof(RGBQUAD);

}

int CBlockView::Refresh(int group/*LPCTSTR pszPath*/)
{
	int nType, nCount, i;
    BLOCKINFO* pItem;

	nType = group/*GetGroupIndex(CString(_T(pszPath)))*/;

	nCount = (int)g_pExtncsMain->m_blockArray.GetSize();
	for(i = 0; i < nCount; i++) {
		pItem = (BLOCKINFO *)(g_pExtncsMain->m_blockArray.GetAt( i ));
		if(pItem->type == nType) {
			AddItem( i, pItem );
		}
	}

	return nCount;

}

int CBlockView::RefreshCell(LPCTSTR pszPath)
{
	int	nCount = 0;
	return nCount;
}

int CBlockView::RefreshSynapse(LPCTSTR pszPath)
{
	int	nCount = 0;
	return nCount;
}

int CBlockView::RefreshGap(LPCTSTR pszPath)
{
	int	nCount = 0;
	return nCount;
}

int CBlockView::RefreshIo(LPCTSTR pszPath)
{
	int	nCount = 0;
	return nCount;
}

int CBlockView::RefreshMath(LPCTSTR pszPath)
{
	int	nCount = 0;
	return nCount;
}

BOOL CBlockView::AddItem(int nIndex, BLOCKINFO *pItem)
{
	//
	// Add the item to the list view.
	//
    LV_ITEM lvi;
    lvi.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM; 
    lvi.iItem = nIndex; 
    lvi.iSubItem = 0; 
    lvi.iImage = pItem->nBitmap;
    lvi.pszText = LPSTR_TEXTCALLBACK; 
    lvi.lParam = (LPARAM) pItem;

    if (GetListCtrl ().InsertItem (&lvi) == -1)
        return FALSE;

    return TRUE;

}

void CBlockView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	MODULEINFO* pItem;
	int group;
	
    if (lHint == 0x5A || lHint == 0x5B) {
		//0x5BłȂƂ
		if(lHint == 0x5A)
			group = GetGroupIndex((LPCTSTR) pHint);
		//FreeItemMemory ();
		GetListCtrl ().DeleteAllItems ();
		if(!m_bImageList) {
			InitialImagelist();
			m_bImageList = TRUE;
		}
		else {
			if(lHint == 0x5B) {
				//Module̓o^
				pItem = (MODULEINFO*)pHint;
				ModuleAppend( pItem );
				ClearImageList();
				InitialImagelist();
				group = GetGroupIndex(pItem->strGroup);
			}
		}
		Refresh (group/*(LPCTSTR) pHint*/);
		return;
	}	
	CListView::OnUpdate (pSender, lHint, pHint);
	
}

//module̓o^
void CBlockView::ModuleAppend(MODULEINFO* pItem)
{
	int group,nBitmap;
	char modelname[128], modelpath[_MAX_PATH];

	// O[vԍ擾
	group = GetGroupIndex(pItem->strGroup);
	// ǉmoduleCfbNX
	// LoadNcsModelœǂݍ܂ꂽfƋʂ
	nBitmap = g_pExtncsMain->GetModuleIndex();
	// o^
	if(pItem->strName.GetLength() == 0)
		return;
	strcpy(modelname, pItem->strName);
	if(pItem->strPath.GetLength() == 0)
		return;
	strcpy(modelpath, pItem->strPath);
	g_pExtncsMain->SetBlockDataAppend(modelpath, modelname, group, nBitmap);

}

int CBlockView::GetGroupIndex(CString group)
{
	int nType;
	if(group.Compare(_T("Cell")) == NULL)
		nType = MODULE_CELL;
	else if(group.Compare(_T("Synapse")) == NULL)
		nType = MODULE_SYNAPSE;
	else if(group.Compare(_T("Gap")) == NULL)
		nType = MODULE_GAP;
	else if(group.Compare(_T("I/O")) == NULL)
		nType = MODULE_IO;
	else if(group.Compare(_T("Source")) == NULL)
		nType = MODULE_SOURCE;
	else if(group.Compare(_T("Sink")) == NULL)
		nType = MODULE_SINK;
	else if(group.Compare(_T("General")) == NULL)
		nType = MODULE_MATH;
	else if(group.Compare(_T("System")) == NULL)
		nType = MODULE_SYSTEM;
	else if(group.Compare(_T("User")) == NULL)
		nType = MODULE_USER;
	else
		nType = MODULE_NULL;
	return nType;
}

//gpĂ͂Ȃ
void CBlockView::FreeItemMemory()
{
    int nCount = GetListCtrl ().GetItemCount ();
    if (nCount) {
        for (int i=0; i<nCount; i++)
            delete (BLOCKINFO*) GetListCtrl ().GetItemData (i);
    }
}

void CBlockView::OnDestroy() 
{
#if 0
	FreeItemMemory ();
	CListView::OnDestroy ();
#endif
	CListView::OnDestroy();
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	
}

void CBlockView::OnGetdispinfo(NMHDR* pNMHDR, LRESULT* pResult) 
{
    CString string;
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*) pNMHDR;

    if (pDispInfo->item.mask & LVIF_TEXT) {
        BLOCKINFO* pItem = (BLOCKINFO*) pDispInfo->item.lParam;

        switch (pDispInfo->item.iSubItem) {

        case 0: // Block name
            ::lstrcpy (pDispInfo->item.pszText, pItem->name);
            break;

        case 1: // Block type
            string.Format (_T ("%d"), pItem->type);
            ::lstrcpy (pDispInfo->item.pszText, string);
            break;

        case 2: // Bitmap
            ::lstrcpy (pDispInfo->item.pszText, pItem->fBitmap);
            break;
        }
    }
	*pResult = 0;
}

void CBlockView::OnMouseMove(UINT nFlags, CPoint point) 
{
	CRect rect;
	CPoint newpos;
	if(m_DragImage) {
		GetWindowRect(&rect);
		newpos.x = rect.left + point.x;
		newpos.y = rect.top + point.y;
		m_DragImage->DragMove(newpos/*point*/);
		//}EẌO
		CRect rcClient;
		GetClientRect( rcClient );
		if(rcClient.PtInRect( point ) == FALSE) {
		//if(0) {
			m_DragImage->EndDrag();
			::ReleaseCapture();
			ShowCursor(TRUE);
			//m_fCapture = FALSE;
		}
	}
	
	CListView::OnMouseMove(nFlags, point);
}

void CBlockView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if(m_DragImage) {
		m_DragImage->EndDrag();
		delete m_DragImage;
		::ReleaseCapture();
		m_DragImage = NULL;
		ShowCursor(TRUE);
//CExtncsDocɃhbOC[WNA
//TODO
		g_pExtncsMain->m_pExtncsDoc->m_DragImageFile = NULL;
	}
	
	CListView::OnLButtonUp(nFlags, point);
}

void CBlockView::ClearImageList()
{
	int i;
	if(m_pImageList) {
		delete m_pImageList;
		m_pImageList = NULL;
	}
	for(i = 0; i < MAX_BITMAP_IMAGE; i++) {
		if(m_pBitmap[i]) {
			delete m_pBitmap[i];
			m_pBitmap[i] = NULL;
		}
	}

}

void CBlockView::OnBegindrag(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
    BLOCKINFO* pItem;

	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CPoint	OrgPos,DragPos,ImagePos,OfsI2D,OfsC2D;
	CRect	rect;

	//hbOEC[W쐬
	m_iItemDrag = pNMListView->iItem;
pItem = (BLOCKINFO *)GetListCtrl ().GetItemData(m_iItemDrag);
	m_DragImage = GetListCtrl ().CreateDragImage(m_iItemDrag, &DragPos);

	//ACeEC[W쐬̍W擾
	GetListCtrl ().GetOrigin(&OrgPos);
	GetListCtrl ().GetItemPosition(m_iItemDrag, &ImagePos);
	ImagePos -= OrgPos;

	//ACeEC[WhbOEC[Wւ̃ItZbgvZ
	OfsI2D = DragPos;	OfsI2D -= ImagePos;

	//hbOEC[WƃJ[\̃ItZbgvZ
	OfsC2D = pNMListView->ptAction;
	OfsC2D -= DragPos;
	OfsC2D.Offset(-2,2);	//magic number

	//J[\ACRւ̃ItZbgvZ
	m_OfsCursor2Icon = - OfsC2D - OfsI2D;
	m_OfsCursor2Icon.Offset(-2,2);	//magic number

	//hbOJn
	m_DragImage->BeginDrag(0,OfsC2D);
	//XgERg[̎n_XN[Wœ
	GetWindowRect(&rect);
	//hbOʒuNCAgWnXN[Wn֕ϊ
	ClientToScreen(&DragPos);
	//hbOʒuEBhEWnœ
	DragPos.Offset(rect.left,rect.top);

	//ǉ
	ShowCursor(FALSE);
	//NULLw
	m_DragImage->DragEnter(NULL/*this*/, DragPos);

	//J[\Lv`
	::SetCapture(GetSafeHwnd());

//CExtncsViewɃhbOC[Wn
//TODO
	g_pExtncsMain->m_pExtncsDoc->m_DragImageFile = m_DragImage;
	g_pExtncsMain->m_pExtncsDoc->m_DragItemIndex = pItem->nBitmap/*m_iItemDrag*/;
	g_pExtncsMain->m_pExtncsDoc->m_DragItemGroup = pItem->type;

	*pResult = 0;
}

void CBlockView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	int nItem;
	LVHITTESTINFO info;
	UINT state;
	BLOCKINFO* pItem;

	//IȂ
	m_nSelectedItem = -1;
	//NbNꂽitemIĂ邩H
	info.pt = point;
	nItem = GetListCtrl ().HitTest( &info );
	if(nItem == -1)
		return;

	//Is it chosen? 
	state = GetListCtrl ().GetItemState(nItem, LVIS_SELECTED);
	if(state != LVIS_SELECTED)
		return;

	// I
	m_nSelectedItem = nItem;
	// }EX|C^XN[Wɕϊ
	ClientToScreen( &point );
	// gɃtH[JXݒ
	SetForegroundWindow();
	// |bvAbvj[̍쐬
	CMenu menu;
	// IDR_MENUPOPUP_SCOPE̓j[̃\[XID
	menu.LoadMenu( IDR_POPUP_BLOCK );
	/*The state of the popup menu is set up. */
	pItem = (BLOCKINFO *)GetListCtrl ().GetItemData(nItem);
	if(pItem->nBitmap <= M_DA3305) {
		//ivo[́AdeleteeditłȂ
		menu.EnableMenuItem(ID_MODEL_EDIT, MF_GRAYED);
		menu.EnableMenuItem(ID_MODEL_DELETE, MF_GRAYED);
	}

	CMenu* pPopup = menu.GetSubMenu( 0 );
	// |bvAbvj[\
	pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			point.x, point.y, this);
	// LoadMenuJ
	menu.DestroyMenu();
	
	CListView::OnRButtonDown(nFlags, point);
}

// o^Ămodule폜
void CBlockView::OnModelDelete() 
{
	BLOCKINFO* pItem;

	if(m_nSelectedItem == -1)
		return;
	//Xg폜
	pItem = (BLOCKINFO*)GetListCtrl ().GetItemData(m_nSelectedItem);
	GetListCtrl ().DeleteItem(m_nSelectedItem);
	//m_blockArray폜
	g_pExtncsMain->DelBlockData(pItem->nBitmap);

	//XV
	ClearImageList();
	InitialImagelist();
	Refresh (pItem->type/*(LPCTSTR) pHint*/);
		
}

void CBlockView::OnUpdateModelDelete(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CBlockView::OnModelEdit() 
{
	if(m_nSelectedItem == -1)
		return;

	BLOCKINFO* pItem;
	CString szText;
	pItem = (BLOCKINFO *)GetListCtrl ().GetItemData(m_nSelectedItem);
	szText = pItem->model;
	//ncsdefAṽR[
	NcsdefExec(g_pExtncsMain->m_hStdinW,
		(CDocument *)GetDocument(),
		(CView *)g_pExtncsMain->m_pConsoleView,
		(CView *)this, szText);
}

void CBlockView::OnUpdateModelEdit(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}
