; SATELLITE installer script for Win32

!define SL_PRODUCT       "SATELLITE"
!define SL_VER_MAJOR     "4"
!define SL_VER_MINOR     "2"
!define SL_VER_MICRO     "2"
!define SL_URL           "http://satellite.sourceforge.jp/"
!define SL_PUBLISHER     "RIKEN BSI Neuroinformatics Laboratory"
!define SL_PUBLISHER_URL "http://www.ni.brain.riken.jp/"

!define SL_NAME    "${SL_PRODUCT} ${SL_VERSION}"
!define SL_VERSION "${SL_VER_MAJOR}.${SL_VER_MINOR}.${SL_VER_MICRO}"
!define SL_REGKEY  "Software\${SL_PRODUCT}"
!define SL_UNINST_REGKEY  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SL_NAME}"

!define SL_OUTFILE       "satellite-win32-${SL_VERSION}.exe"

!include "MUI.nsh"

Var MUI_TEMP
;--------------------------------
;General

  ;Name and file
  Name "${SL_NAME}"
  OutFile "${SL_OUTFILE}"

  ;Default installation folder
  InstallDir "$PROGRAMFILES\${SL_PRODUCT}"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKLM "${SL_REGKEY}" ""

  ;------------------------------
  ;Interface Configuration

  ; Installer and uninstaller icon file
  !define MUI_ICON   "resources\setup.ico"
  !define MUI_UNICON "resources\remove.ico"
  ; welcome page bitmap
  !define MUI_WELCOMEFINISHPAGE_BITMAP "resources\welcome.bmp"
  !define MUI_WELCOMEFINISHPAGE_BITMAP_NOSTRETCH
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP "resources\unwelcome.bmp"
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP_NOSTRETCH

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING
  
;--------------------------------
;Languages
  !insertmacro MUI_LANGUAGE "English"
  !insertmacro MUI_LANGUAGE "Japanese"
  !include "languages\english.nsh"
  !include "languages\japanese.nsh"

;-------------------------
;Installer Sections

Function .onInit

   ; If it is failed to extract the installation directory from command lines,
   ; find the keyword "/D=", extract the installation directory, and set it
   ; to the variable $INSTDIR.

   Push $R0
   Push $R1
   Push $R2
   Push $R3  ; length of commad line

   StrCpy $R2 0
   StrLen $R3 $CMDLINE

   loop:
     StrCpy $R0 $CMDLINE 3 $R2
     StrCpy $R1 "/D="
     StrCmp $R0 $R1 get
     StrCmp $R2 $R3 end
     IntOp $R2 $R2 + 1
     Goto loop

   get:
     IntOp $R2 $R2 + 3
     IntOp $R1 $R3 - $R2
     IntOp $R1 $R1 - 1
     StrCpy $R0 $CMDLINE $R1 $R2
     StrCpy $INSTDIR $R0

   end:

   Pop $R3
   Pop $R2
   Pop $R1
   Pop $R0
FunctionEnd

Section "SATELLITE" SecCopyUI
  ;Check an old version
  Push $R0
  Push $R1
  Push $R2
  Push $R3
  ReadRegStr $R0 HKLM "${SL_REGKEY}" ""
  StrCmp $R0 "" NoOldVer
  ReadRegDWORD $R1 HKLM "${SL_REGKEY}" "VersionMajor"
  ReadRegDWORD $R2 HKLM "${SL_REGKEY}" "VersionMinor"
  ReadRegDWORD $R3 HKLM "${SL_REGKEY}" "VersionMicro"
  IntCmp $R1 ${SL_VER_MAJOR} IsSameMajorVer MessageOldVer MessageNewVer
IsSameMajorVer:
  IntCmp $R2 ${SL_VER_MINOR} IsSameMinorVer MessageOldVer MessageNewVer
IsSameMinorVer:
  IntCmp $R3 ${SL_VER_MICRO} MessageSameVer MessageOldVer MessageNewVer
MessageOldVer:
  MessageBox MB_YESNO|MB_ICONEXCLAMATION|MB_TOPMOST $(DESC_OverwriteOldVer) IDYES DoUnInstPrevInst
  goto DoAbortInst
MessageNewVer:
  MessageBox MB_YESNO|MB_ICONEXCLAMATION|MB_TOPMOST $(DESC_OverwriteNewVer) IDYES DoUnInstPrevInst
  goto DoAbortInst
MessageSameVer:
  MessageBox MB_YESNO|MB_ICONEXCLAMATION|MB_TOPMOST $(DESC_OverwriteSameVer) IDYES DoUnInstPrevInst
DoAbortInst:
  DetailPrint "The installation was canceled.."
  Abort
DoUnInstPrevInst:
  ExecWait '"$R0\Uninstall.exe" /S'
  Sleep 500
NoOldVer:
  Pop $R3
  Pop $R2
  Pop $R1
  Pop $R0

  WriteRegStr HKLM "${SL_REGKEY}" "" $INSTDIR
  WriteRegDWORD HKLM "${SL_REGKEY}" "VersionMajor"   "${SL_VER_MAJOR}"
  WriteRegDWORD HKLM "${SL_REGKEY}" "VersionMinor"   "${SL_VER_MINOR}"
  WriteRegDWORD HKLM "${SL_REGKEY}" "VersionMicro"   "${SL_VER_MICRO}"

  ; Install Files
  SetOutPath "$INSTDIR"
  File /r "..\NET2003\Release\doc"
  File /r "..\NET2003\Release\etc"
  File /r "..\NET2003\Release\examples"
  File /r "..\NET2003\Release\include"
  File /r "..\NET2003\Release\modules"
  File /r "..\NET2003\Release\share"
  File /r "..\NET2003\Release\tools"
  File "..\NET2003\Release\extncs.dll"
  File "..\NET2003\Release\gpm2eps.bat"
  File "..\NET2003\Release\gpm2ps.exe"
  File "..\NET2003\Release\libsatellite.dll"
  File "..\NET2003\Release\libslshell.dll"
  File "..\NET2003\Release\ncsdef.dll"
  File "..\NET2003\Release\satellite4.exe"
  File "..\NET2003\Release\satellite4-console.exe"
  File "..\..\contrib\MFC71.dll"
  File /oname=Acknowledgement.txt "..\..\..\Acknowledgement"
  File /oname=COPYING.txt         "..\..\..\COPYING"
  File /oname=AUTHORS.txt         "..\..\..\AUTHORS"

  SetOutPath "$INSTDIR\doc"
  File /r "..\..\..\doc\reference\reference-ja"
  File /r "..\..\..\doc\usersman\usersman-ja"

  WriteUninstaller "$INSTDIR\Uninstall.exe"

  ; start menu
  StrCpy  $MUI_TEMP "$SMPROGRAMS\${SL_PRODUCT} ${SL_VERSION}"
  CreateDirectory "$MUI_TEMP"
  CreateShortCut  "$MUI_TEMP\${SL_PRODUCT}.lnk" "$INSTDIR\satellite4-console.exe"
  CreateShortCut  "$MUI_TEMP\${SL_PRODUCT} IDE.lnk" "$INSTDIR\satellite4.exe"
  WriteINIStr     "$MUI_TEMP\${SL_PRODUCT} Site.url" "InternetShortcut" "URL" "${SL_URL}"
  CreateShortCut  "$MUI_TEMP\Uninstall.lnk" "$INSTDIR\Uninstall.exe"
  CreateDirectory "$MUI_TEMP\Manuals"
  CreateShortCut  "$MUI_TEMP\Manuals\Reference Manual (Japanese).lnk" "$INSTDIR\doc\reference-ja\index.html"
  CreateShortCut  "$MUI_TEMP\Manuals\User's Manual (Japanese).lnk" "$INSTDIR\doc\usersman-ja\index.html"
  ; desktop
  CreateShortCut "$DESKTOP\${SL_PRODUCT} ${SL_VERSION}.lnk" "$INSTDIR\satellite4-console.exe"

SectionEnd


;--------------------------------
; Section for Write Registry
Section -post
  Push $0
  ; Write to Registry Uninstall information
  WriteRegExpandStr HKLM "${SL_UNINST_REGKEY}" "UninstallString" '"$INSTDIR\Uninstall.exe"'
  WriteRegExpandStr HKLM "${SL_UNINST_REGKEY}" "InstallLocation" "$INSTDIR"
  WriteRegStr   HKLM "${SL_UNINST_REGKEY}" "DisplayName" "${SL_NAME}"
  WriteRegStr   HKLM "${SL_UNINST_REGKEY}" "DisplayIcon" "$INSTDIR\samurai-graph.ico,0"
  WriteRegStr   HKLM "${SL_UNINST_REGKEY}" "DisplayVersion" "${SL_VERSION}"
  WriteRegDWORD HKLM "${SL_UNINST_REGKEY}" "VersionMajor"   "${SL_VER_MAJOR}"
  WriteRegDWORD HKLM "${SL_UNINST_REGKEY}" "VersionMinor"   "${SL_VER_MINOR}"
  WriteRegStr   HKLM "${SL_UNINST_REGKEY}" "Publisher"      "${SL_PUBLISHER}"
  WriteRegStr   HKLM "${SL_UNINST_REGKEY}" "URLInfoAbout"   "${SL_PUBLISHER_URL}"
  WriteRegStr   HKLM "${SL_UNINST_REGKEY}" "HelpLink"       "${SL_URL}"
  WriteRegStr   HKLM "${SL_UNINST_REGKEY}" "URLUpdateInfo"  "${SL_URL}"
  WriteRegDWORD HKLM "${SL_UNINST_REGKEY}" "NoModify" "1"
  WriteRegDWORD HKLM "${SL_UNINST_REGKEY}" "NoRepair" "1"
  Pop $0
SectionEnd

;-------------------------
;Uninstaller Section

!include "WinMessages.nsh"

Section "Uninstall"

  RMDir /r /REBOOTOK "$INSTDIR"

  StrCpy  $MUI_TEMP "$SMPROGRAMS\${SL_PRODUCT} ${SL_VERSION}"
  Delete "$MUI_TEMP\${SL_PRODUCT}.lnk"
  Delete "$MUI_TEMP\${SL_PRODUCT} IDE.lnk"
  Delete "$MUI_TEMP\${SL_PRODUCT} Site.url"
  Delete "$MUI_TEMP\Manuals\Reference Manual (Japanese).lnk"
  Delete "$MUI_TEMP\Manuals\User's Manual (Japanese).lnk"
  Delete "$MUI_TEMP\Uninstall.lnk"
  Delete "$DESKTOP\$DESKTOP\${SL_PRODUCT} ${SL_VERSION}.lnk"
  RMDir   $MUI_TEMP\Manuals
  startMenuDeleteLoop:
    RMDir $MUI_TEMP
    GetFullPathName $MUI_TEMP "$MUI_TEMP\.."
    IfErrors startMenuDeleteLoopDone
    StrCmp $MUI_TEMP $SMPROGRAMS startMenuDeleteLoopDone startMenuDeleteLoop
  startMenuDeleteLoopDone:

  ; delete regkeys
  DeleteRegValue HKLM "${SL_REGKEY}" "VersionMajor"
  DeleteRegValue HKLM "${SL_REGKEY}" "VersionMinor"
  DeleteRegValue HKLM "${SL_REGKEY}" "VersionMicro"
  DeleteRegKey /ifempty HKLM "${SL_REGKEY}"
  DeleteRegKey HKLM "${SL_UNINST_REGKEY}"

SectionEnd
