#!/usr/bin/perl
#
# This script is public domain
#
if(@ARGV==0){
    die "Usage:perl sl2tosl4.pl sl2file.sl > sl4file.sl\n";
}

while($line = <>){
    if($line =~ /(Symbols[(])/){
	$line =~ s/Symbols/symbols/;
    }
    if($line =~ /(sam[(])/){
	$line =~ s/sam/sampling/;
    }
    if($line =~ /(GarCo[(])/){
	$line =~ s/GarCo[(][)]//;
    }
    if($line =~ /(unix[(])/){
	$line = "$`system($'";
    }

## ISPP
    if($line =~ /[cn]^(integ[(])/){
	$line =~ s/integ/sum/;
    }
    if($line =~ /(interp[(])/){
	$line =~ s/interp/interp2/;
    }
    if($line =~ /(iircoef[(])/){
	$line =~ s/iircoef/iirmake/;
    }
    if($line =~ /(revTime[(])/){
	$line =~ s/revTime/revtime/;
    }

## GPM
    if($line =~ /(scale[(])[ ]*([NL])[ ]*,[ ]*([AFD])[ ]*,[ ]*([NL])[ ]*,[ ]*([AFD])/){
	$line = "$`$1\"$2\",\"$3\",\"$4\",\"$5\"$'";
    }
    if($line =~ /(draw[(])[ ]*([XY])/){
	$line = "$`$1\"$2\"$'";
    }
    if($line =~ /(label[(])[ ]*([IF])/){
	$line = "$`$1\"$2\"$'";
    }
    if($line =~ /(graph[(])[ ]*([a-zA-Z0-9]+)[ ]*,[ ]*([TFD])/){
	$line = "$`$1$2,\"$3\"$'";
    }
    if($line =~ /(map[(])[ ]*([a-zA-Z0-9]+)[ ]*,[ ]*([XY])/){
	$line = "$`$1$2,\"$3\"$'";
    }
    if($line =~ /(color[(])[ ]*([a-zA-Z]+)[ ]*,[ ]*([a-zA-Z]+)/){
	$line = "$`$1\"$2\",\"$3\"$'";
    }
    if($line =~ /(color[(])[ ]*(\"[a-zA-Z]+\")[ ]*,[ ]*([a-zA-Z]+)/){
	$line = "$`$1$2,\"$3\"$'";
    }
    if($line =~ /(color[(])[ ]*([a-zA-Z]+)[ ]*,[ ]*(\"[a-zA-Z]+\")/){
	$line = "$`$1\"$2\",$3$'";
    }
    if($line =~ /(axis[(][ ]*[0-9]*[ ]*,[ ]*[0-9]*[ ]*,)[ ]*([XY]*)[ ]*,[ ]*(\"[XY]*\")/){
	$line = "$`$1\"$2\",$3$'";
    }
    if($line =~ /(axis[(][ ]*[0-9]*[ ]*,[ ]*[0-9]*[ ]*,)[ ]*([XY]*)[ ]*,[ ]*([XY]*)/){
	$line = "$`$1\"$2\",\"$3\"$'";
    }
    if($line =~ /(axis[(][ ]*[0-9]*[ ]*,[ ]*[0-9]*[ ]*,)[ ]*(\"[XY]*\")[ ]*,[ ]*([XY]*[ ]*,)/){
	$line = "$`$1$2,\"$3\"$'";
    }
## NCS
    if($line =~ /(nout[(])[ ]*([a-zA-Z0-9]+)[ ]*,[ ]*([a-zA-Z0-9]+)[ ]*,[ ]*([0-9]+)[ ]*,[ ]*([123])/){
	$line = "$`$1$2,\"$3\",$4,$5$'";
    }
    if($line =~ /(nout[(])[ ]*([a-zA-Z0-9]+)[ ]*,[ ]*([a-zA-Z0-9]+)[ ]*,[ ]*([0-9]+)[ ]*,[ ]*([123])[ ]*,[ ]*([a-zA-Z0-9]+)/){
	$line = "$`$1$2,\"$3\",$4,$5,\"$6\"$'";
    }
    if($line =~ /(nout[(])[ ]*([a-zA-Z0-9]+)[ ]*,[ ]*(\"[a-zA-Z0-9]+\")[ ]*,[ ]*([0-9]+)[ ]*,[ ]*([123])[ ]*,[ ]*([a-zA-Z0-9]+)/){
	$line = "$`$1$2,$3,$4,$5,\"$6\"$'";
    }
    if($line =~ /(ninteg[(])([FRE])/){
	$line ="$`$1\"$2\"$'";
    }
    if($line =~ /(nstim[(])([ ]*\"[a-zA-Z0-9]+\")[ ]*,[ ]*([0-9]+)[ ]*,[ ]*([PRFB])/){
	$line = "$`$1$2,$3,\"$4\"$'";
    }
    if($line =~ /(npara[(])([ ]*[a-zA-Z0-9]+)[ ]*,[ ]*([a-zA-Z0-9]+)/){
	$line = "$`$1\"$2\",\"$3\"$'";
    }
    if($line =~ /(npara[(])([ ]*\"[a-zA-Z0-9]+\")[ ]*,[ ]*([a-zA-Z0-9]+)/){
	$line = "$`$1$2,\"$3\"$'";
    }
    if($line =~ /(npara[(])([ ]*[a-zA-Z0-9]+)[ ]*,[ ]*(\"[a-zA-Z0-9]+\")/){
	$line = "$`$1\"$2\",$3$'";
    }

## NPE
    if($line =~ /(npeinit[(])/){
	$line =~ s/npeinit[(][)]//;
    }
    if($line =~ /(cinteg[(]\"[A-Z]\"[)])/){
	$line =~ s/cinteg[(]\"[A-Z]\"[)]//;
    }

##
    print $line;
}
