/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: termios_console.h,v 1.2 2005/03/01 14:10:54 orrisroot Exp $ */

#ifndef __TERMIOS_TTY_H__
#define __TERMIOS_TTY_H__

#include "terminal.h"

class termios_console : public tty_console {
private:
  bool  term_is_auto_lf(){ return false; }
  void  term_move_down(int y){ sl4_term_cursor_down(y); }
  void  term_move_up(int y){ sl4_term_cursor_up(y); }
  void  term_move_right(int x){ sl4_term_cursor_right(x); }
  void  term_move_left(int x){ sl4_term_cursor_left(x); }
  void  term_move_bol(){ sl4_term_cursor_bol(); }
  void  term_move_newline(){ sl4_term_cursor_newline(); }
  void  term_bell(){ sl4_term_bell(); }
  void  term_vbell(){ sl4_term_vbell(); }
  void  term_clear_screen(){ sl4_term_clear_screen(); }
  void  term_clear_eol(int x){ sl4_term_clear_eol(x); }
  void  term_set_attr_normal(){ sl4_term_attr_normal(); }
  void  term_set_attr_bold(){ sl4_term_attr_bold(); }
  void  term_set_attr_reverse(){ sl4_term_attr_reverse(); }
  void  term_set_attr_underline(){ sl4_term_attr_underline(); }
  bool  term_has_color();
  void  term_putc(int c){ sl4_term_putc(c); }
  void  term_print(const char *str){ sl4_term_puts(str); }
  int   term_keypad_getc();
  int   term_getc(){ return sl4_term_getc(); }
  char* term_gets(char *buf, int size);
  void  term_edit_mode(){ sl4_tty_setmode(TTY_MODE_RAW); }
  void  term_normal_mode(){ sl4_tty_setmode(TTY_MODE_NORMAL); }
public:
  termios_console();
  ~termios_console(){ sl4_term_quit(); }
  void term_flush(sl4_fd_t fd);
  void term_set_fgcolor(SL_TTY::COLOR color){}
  void term_set_bgcolor(SL_TTY::COLOR color){}
  void term_getmaxyx(int *y, int* x){ sl4_term_getmaxyx(y, x); }
};

#endif
