/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: termios_console.cpp,v 1.3 2005/03/01 14:10:54 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <setjmp.h>

#include "libsatellite.h"

#include "SL_header.h"
#include "SL_exception.h"
#include "history.h"
#include "module.h"
#include "tty_console.h"
#include "termios_console.h"

#include "terminal.h"

#ifdef RETSIGTYPE
typedef RETSIGTYPE (*sigfunc_t)(int);
#else
typedef void (*sigfunc_t)(int);
#endif

termios_console::termios_console() {
  ifd.fd = fileno(stdin);
  ofd.fd = fileno(stdout);
  efd.fd = fileno(stderr);
  sl4_term_init(stdin, stdout, stderr);
  sl4_term_clear_screen();
}

bool termios_console::term_has_color(){
  return false; // TODO termcap
}

int termios_console::term_keypad_getc(){
  int ret;
  ret = sl4_term_keypad_getc();
  switch(ret){
  case SL4_KEYPAD_UP:    ret = SL_TTY::UPKEY    << 8; break;
  case SL4_KEYPAD_DOWN:  ret = SL_TTY::DOWNKEY  << 8; break;
  case SL4_KEYPAD_LEFT:  ret = SL_TTY::LEFTKEY  << 8; break;
  case SL4_KEYPAD_RIGHT: ret = SL_TTY::RIGHTKEY << 8; break;
  case SL4_KEYPAD_HOME:  ret = SL_TTY::HOMEKEY  << 8; break;
  case SL4_KEYPAD_END:   ret = SL_TTY::ENDKEY   << 8; break;
  }
  return ret;
}

static sigjmp_buf jmpenv;
void sigintjmp(int sig){
  signal(SIGINT, SIG_IGN);
  siglongjmp(jmpenv, 1);
}

char *termios_console::term_gets(char *buf, int size){
  char *ret;
  sigfunc_t sigoldfunc;
  sigoldfunc = signal(SIGINT, SIG_IGN);
  if(sigsetjmp(jmpenv, 1) == 0){
    signal(SIGINT, sigintjmp);
    ret = sl4_term_gets(buf, size);
  }else{
    sl4_term_putc('\n');
    ret = NULL; /* sig int caught */
  }
  signal(SIGINT, sigoldfunc);
  return ret;
}

void termios_console::term_flush(sl4_fd_t fd){
  FILE *fp;
  switch(fd.fd){
  case -1: break;
  case 0: /* fflush(stdin); */ break;
  case 1: fflush(stdout); break;
  case 2: fflush(stderr); break;
  default:
    fp = fdopen(fd.fd,"w");
    if(fp != NULL){
      fflush(fp);
      fclose(fp);
    }
  }
}
