/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: main.cpp,v 1.1.1.1 2004/03/31 08:15:07 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_SIGNAL_H
# include <signal.h>
#endif

#include "shell/satellite4.h"
#include "termios_console.h"

/* test code for symbol list event callback */
/* void symlist_var_event_callback(int event, symbol_t *sym){ */
/*   switch(event){ */
/*   case SYMLIST_EVENT_ADD: */
/*     printf("symbol list add -> %s\n", sym->name); */
/*     break; */
/*   case SYMLIST_EVENT_DELETE: */
/*     printf("symbol list delete -> %s\n", sym->name); */
/*     break; */
/*   } */
/* } */

/* test code for module event callback */
/* void module_event_callback(int event, module_t *mod){ */
/*   switch(event){ */
/*   case MODULE_EVENT_NEW: */
/*     printf("module new\n"); */
/*     break; */
/*   case MODULE_EVENT_LOAD: */
/*     printf("module load -> %s (%d:commands)\n",  */
/*            mod->module_name, mod->commands->nkeys); */
/*     break; */
/*   case MODULE_EVENT_UNLOAD: */
/*     printf("module unload -> %s (%d:commands)\n", */
/*            mod->module_name,mod->commands->nkeys); */
/*     break; */
/*   case MODULE_EVENT_DELETE: */
/*     printf("module delete -> %s\n", mod->module_name); */
/*     break; */
/*   } */
/* } */

// void print_object_num();
// void print_series_buffer_num();
// void print_scalar_buffer_num();
// void print_string_buffer_num();
// void print_builtin_buffer_num();
// void print_buffer_num();

int main(int argc,char *argv[]){
  sl_shell *pshell;
  tty_console *console;
  console = new termios_console;
  pshell = new sl_shell(console);
  if(pshell->initialize(argc,argv)) {
    /***** test code for symbol event callback *****/
    /* symlist_set_var_callback(symlist_var_event_callback); */
    /***** test code for module event callback *****/
    /* module_set_callback(module_event_callback); */
    /* Main loop */
    pshell->shell_main();
  }
  delete pshell;
  delete console;
  //  print_object_num();
  //  print_buffer_num();
  //  print_series_buffer_num();
  //  print_scalar_buffer_num();
  //  print_string_buffer_num();
  //  print_builtin_buffer_num();
  return 0;
}
