#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#define BUFBSIZE 2048
#define emalloc(x)    malloc(x)
#define efree(x)      free(x)

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int slutil_text2string()
{
  
  char **fn;       /* file name string object - fn, fdim, fidx */
  int fdim, *fidx;
  char *fname;     /* file name */
  char **ret;      /* returning string object - ret, dim, idx */
  int  dim, idx;

  size_t i, nb, len, dsiz;
  char *mem, *buf, c;

  sl4_mmapfile_t *mf;

  /* get 1st argument */
  fn = sl4_syscom_get_string(0, &fdim, &fidx);
  /* argument check */
  if(fn == NULL) return 1; /* illegal parameter */
  if(IndexSize(fdim,fidx) != 1) return 2; /* illegal index */
  fname = fn[0];
  if(fname == NULL) return 1; /* illegal parameter */

  /* file mapping */
  mf = sl4_mmapfile_new();
  if(mf == NULL) return 3;
  if(sl4_mmapfile_map(mf, fname, SL4_MMAPFILE_RD, 0, 0) == -1)
    return 2; /* TODO: allocate error message */

  mem = (char*)mf->mem;

  nb = 0; len = 0; nb = 1; dsiz = 0;
  ret = (char**)malloc(BUFBSIZE * sizeof(char*));
  if(ret == NULL){ /* TODO: error recovering */ return 3; }
  for(i=0; i<mf->size; i++){
    c=mem[i];
    if(c == '\n' || c == '\t' || c == '\r' || c == ' '){
      if(len != 0){
        if(dsiz == BUFBSIZE * nb){
          char **tmp;
          nb++;
          tmp = (char**)realloc(ret, BUFBSIZE * nb * sizeof(char*));
          if(tmp == NULL){ /* TODO: error recovering */ return 3; }
          ret = tmp;
        }
        buf = (char*)malloc(len + 1);
        if(buf == NULL){ /* TODO: error recovering */ return 3; }
        memcpy(buf, &mem[i], len);
        buf[len]='\0';
        ret[nb] = buf;
        len = 0;
        dsiz++;
      }
    }else{
      len++;
    }
  }
  /* file unmapping */
  sl4_mmapfile_unmap(mf);
  sl4_mmapfile_delete(mf);

  /* reallocate returning string object */
  if(dsiz != BUFBSIZE * nb){
    char **tmp;
    nb++;
    tmp = (char**)realloc(ret, dsiz * sizeof(char*));
    if(tmp == NULL){ /* TODO: error recovering */ return 3; }
    ret = tmp;
  }
  dim = 1;
  idx = dsiz;
  sl4_syscom_return_string(dim,&idx,ret);
  return 0;
}

#ifdef __cplusplus
}
#endif
