/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: wait.cpp,v 1.2 2005/02/02 18:08:37 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef HAVE_WINDOWS_H
# include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef HAVE_UNISTD_H
# include "unistd.h"
#endif

#define DBUFSIZ 256

#ifdef HAVE_WINDOWS_H
# define sleep(x) Sleep(x)
#endif

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_system_wait(){
  int waittime;
  char *type, *str, buf[DBUFSIZ];
  if(GetArgNum() == 0){
    str = "  * * * *  Hit Return key : ";
    type = "string";
  }else{
    type = GetArgType(0);
    if(strcmp(type, "string") == 0){
      str = GetString(0);
    }else if(strcmp(type, "scalar") == 0){
      waittime = (int)GetScalar(0);
    }else{
      return 2; /* illegal parameter */
    }
  }
  if(strcmp(type, "string") == 0){
    printf(str);
    if(sl4_getstr(buf,DBUFSIZ) == NULL){
      return 99;
    }
  }else{
    if(waittime>0){
      sleep((unsigned int)waittime);
    }
  }
  return 0;
}

#ifdef __cplusplus
}
#endif
