/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: system_sub.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#include <stdio.h>

void q_sort(float *a,float *idx, int is, int ie){
  float x,w,iw;
  int i,j;
  i=is;
  j=ie;
  x=a[(is+ie)/2];
  while(i<=j){
    while(a[i]<x)i++;
    while(x<a[j])j--;
    if (i <= j) {
      w = a[i];
      a[i] = a[j];
      a[j] = w;
      iw = idx[i];
      idx[i] = idx[j];
      idx[j] = iw;
      i++;
      j--;
    }
  }
  if(is<j)q_sort(a,idx,is,j);
  if(ie>i)q_sort(a,idx,i,ie);
}

void sort(float *a,float *idx, int n){
  int i;
  for(i=0;i<n;i++)
    idx[i]=(float)i;
  q_sort(a,idx,0,n-1);
}
