/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: minpos.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#include "system_sub.h"
/****************************************************
*   FIND POSITION OF MINIMUM VALUE                  *
*---------------------------------------------------*
*     maxpos( x, num )                              *
*             x    : Input Buffer                   *
*             num  : get data number                *
*---------------------------------------------------*
*                 K.Takebe                          *
*                       1993 , 4 , 17               *
****************************************************/

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_system_minpos(){
  Buffer *x, *xx;
  float  *dst, *idx, *ds, *id, *max;
  int    leng, num, *ind, *maxi;
  int    dim, index1[MAX_INDEX], index2[MAX_INDEX];

  if (( x = GetSeries( 0, &dim, index1 ) ) == NULL )
    return (4);

  leng = IndexSize( dim, index1 );

  if ( ( num =(int)GetScalar(1) ) >= leng )
    num = leng;

  dst = (float*)emalloc( leng*sizeof(float) );
  idx = (float*)emalloc( leng*sizeof(float) );

  if ( dst == NULL || idx == NULL )
    return (8);

  max = dst + leng;

  for ( xx = x, ds = dst; ds < max; ds++, xx++ ) {
    *ds = (float)(*xx);
  }

  sort( dst, idx, leng );

  max = idx+num;
  for ( xx = x, id = idx; id < max; id++ ) {
    rIndex( (int)(*id), index2, dim, index1 );
    for ( ind = index2, maxi = index2+dim; ind < maxi; ind++, xx++ )
      *xx = (double)(*ind);
  }

  if ( num == 1 && dim == 1 )
    ReturnScalar( x[0] );
  else {
    index1[ 0 ] = num;
    index1[ 1 ] = dim;
    ReturnSeries( x, 2, index1 );
  }

  //FreeBuffer( x );
  efree( dst );
  efree( idx );
  return 0;
}

#ifdef __cplusplus
}
#endif
