/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: copy.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#include <stdio.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

/**********************************************************
           file name : tempdir.c
***********************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_WINDOWS_H
# define W "wb"
# define R "rb"
#else
# define W "w"
# define R "r"
#endif

DLLEXPORT int mod_system_copy(){
  FILE *fp_from, *fp_to;
  char *from, *to, buf[BUFSIZ];
  int   narg;
  size_t rsize, wsize;
  narg = GetArgNum();
  if(narg < 2)
    return 30; /* less argument */
  from = GetString(0);
  to   = GetString(1);
  if(from == NULL || to == NULL){
    return 2; /* illegal parameter */
  if(IsDirectory(to)){
    /* to = to + '/' + basename(from) */
  }
  fp_from = fopen(from, R);
  if(fp_from == NULL){
    return 0; /* file not found */
  }
  fp_to   = fopen(to, W);
  if(fp_to == NULL){
    fclose(fp_from);
    return 0; /* can't create file */
  }
  rsize = wsize = 0;
  while(feof(fp_from) == 0){
    rsize = fread(buf, 1, BUFSIZ, fp_from);
    if(rsize != 0)
      wsize = fwrite(buf, 1, rsize, fp_to);
    if(rsize != wsize)
      break;
  }
  fclose(fp_from);
  fclose(fp_to);
  if(rsize != wsize){
    return 0; /* an error occured */
  return 0;
}

#ifdef __cplusplus
}
#endif
