# Wilcoxon Rank-Sum Test

func stat_number(d){
	str = typeof(d);
	if(str=="series"){		
		def=Snapshot(d);
	}else{
		def = d;
	}

	nx = indexsize(d);
	snapshot num[nx];

	for(i=0;i<nx;i++){
		A = def[i];
		cnt = 1;
		flag = 0;
		for(j=0;j<nx;j++){
			B = def[j];
			if(A==B){
				flag++;
			}else if(A>B){	
				cnt++;
			}
		}
		no = cnt;
		add = 0;
		
		check1 = stat_checkdivision0(flag,"T-Value");
		
		for(k=flag;k>0;k--){
			add += no;
			cnt = add  / flag;	
			no++;
		}
		num[i] = cnt;
	}
	return num;
}

# Not Paired
func stat_calwilcoxon(x,y,flag){
	if(typeof(x)=="snapshot"){
		xx=Series(x);
	}else{
		xx=x;
	}
	if(typeof(y)=="snapshot"){
		yy=Series(y);
	}else{
		yy=y;
	}

	check1 = stat_checkvartype(xx,"series",0);
	check1 = stat_checkvartype(yy,"series",0);

	xx = reform(xx,indexsize(xx));
	yy = reform(yy,indexsize(yy));

	cntx = indexsize(xx);
	cnty = indexsize(yy);

	if( cntx <= cnty ){
		n1data = xx;
		n2data = yy;
	}else{
		n1data = yy;
		n2data = xx;
	}
	n1 = indexsize(n1data);
	n2 = indexsize(n2data);

	mgData = merge(n1data,n2data);

	mgRank = stat_number(mgData);
	Rank = cut( mgRank, 0, (n1-1) );
	W = sum(Rank);

	if( n2 > 20 ){
		a1 = abs(W - (((n1 + n2 + 1)*n1)/2))-0.5;
		a2 = sqrt(((n1 + n2 + 1)*n1*n2)/12);

	    t = a1/a2;
	    p=2*(stat_normscdf(t));

		series result;
		result = ( W , p );
		return result;

	}else{
		if( n1 < 3 &&  n2 < 8 || n1 < 4 && n2 < 5){
			series result;
			printf(" Error! : This sample size is out of Wilcoxon list. \n");
			result = ( W, 0 );
			return result;
		}else{
			series result;
			u = stat_datafile("udata.dat");
			a1 = Snapshot(u[n1][n2]);
			u1 = a1[0];
			u2 = a1[1];

			if( W > u1 && W < u2 ){
				if( flag == 0 ){
					result = ( W, u1, u2 );
					return result;
				}else if( flag == 1 ){
					printf("p=0.05  %d < %d < %d \n",u1,W,u2);
					result = ( W, u1, u2 );
					return result;
				}
			}else{
				if( flag == 0 ){
					result = ( W, u1, u2 );
					return result;
				}else if( flag == 1 ){
					printf("p=0.05  %d < %d < %d \n",u1,W,u2);
					result = ( W, u1, u2 );
					return result; 
				}
			}
		}
	}
}

func wilcoxon(x,y){
	result = stat_calwilcoxon(x,y,1);
	return result;
}

# Paired
func wilcoxonp(x,y){
	str = typeof(x);
	if(str=="snapshot"){
		xx=Series(x);
	}else{
		xx=x;
	}
	
	str = typeof(y);
	if(str=="snapshot"){
		yy=Series(y);
	}else{
		yy=y;
	}
	
	check1 = stat_checkvartype(xx,"series",0);
	check1 = stat_checkvartype(yy,"series",0);
	
	xx = reform(xx,indexsize(xx));
	yy = reform(yy,indexsize(yy));
	
	check1 = stat_checkelementcnt(xx,yy);
	
	nx = indexsize(xx); 
	ny = indexsize(yy); 
	
	snapshot def[nx];
	snapshot def2[nx];
	nn = 0;

	for(i=0;i<nx;i++){
		def[i]=xx:[i] - yy:[i];
		def2[i]=abs(xx:[i] - yy:[i]);
	}
	
	num = stat_number(def2);
	
	zer = 0;
	for(i=0;i<nx;i++){
		if(def2[i]==0){
			zer++;
			for(j=0;j<nx;j++){
				num[j]=num[j]-1;
			}
			num[i]=0;
		}
	}
	snapshot gh[nx];
	cn=0;
	snapshot C[nx];
	for(i=0;i<nx;i++){
		A=num[i];
		flag=0;
		for(j=0;j<nx;j++){
				if(A==num[j]){
					flag++;
				}
		}
		if(flag>1){
				if(C!=num[i]){
					gh[cn++]=flag;
					C[cn]=num[i];
				}
		}
	}
	W=0;
	V=0;
	for(i=0;i<nx;i++){
		if(def[i]>0){
			W +=num[i];
			nn++;
		}else if(def[i]<0){
			V +=num[i];
			nn++;
		}
	}
	
	t=0;
	t=W;
	if(W>V){
		t=V;
	}
	
	z0=0;
	series nt5;
	#n =    0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26  27  28  29  30  31  32  33  34  35  36  37  38  39  40  41  42  43  44  45  46  47  48  49  50
	nt5 = (-1,-1,-1,-1,-1,-1, 0, 2, 3, 5, 8,10,13,17,21,25,29,34,40,46,52,58,65,73,81,89,98,107,116,126,137,147,159,170,182,195,208,221,235,249,264,279,294,310,327,343,361,378,396,415,434,453,473,494,514,536,557,579,602,625,648,672,697,721,747)
	series nt1;
	nt1 = (-1,-1,-1,-1,-1,-1,-1, -1,0, 1, 3, 5, 7, 9,12,15,19,23,27,32,37,42,48,54,61,68,75,83,91,100,109,118,128,138,148,159,171,182,194,207,220,233,247,261,276,291,307,322,339,355,373,390,408,427,445,465,484,504,525,546,567,589,611,634,657)
	
	alpha1=0.05;
	alpha2=0.025;
	
	series z;
	
	if(nn <= 50){			
		if(nn <= 5){
			printf(" Error! : This sample subtracted size is out of Wilcoxon list. \n");
			r=0;
		}else{
			r = nt5:[nn];
			#r = nt1:[nn];
			if(t>r){
				#printf("1:N<=50 : Z[0]%d > Z[1]%d \n",t,r);
			}else if(t<=r){
				#printf("2:N<=50 : Z[0]%d <= Z[1]%d \n",t,r);
			}
		}
		z = (t,r);
		
	}else{
		zi = abs(t-nn*(nn+1)/4);
		zj = nn*(nn+1)*(2*nn+1)/24;
		zk = 0;
		if(cn>0){
			for(i=0;i<cn;i++){
				zk += (pow(gh[i],3)-gh[i]);
			}
			zj = zj - (zk / 48);
		}
		check1 = stat_checkdivision0(zj,"Z0-Value");
		
		z0 = zi / sqrt(zj);
		
		p = stat_normscdf(z0);
		if(p > alpha1){
			#printf("3:N>50 : Z[0]%f  Z[1]%f \n",z0,p*2);
		}else if(p <= alpha1){
			#printf("4:N>50 : Z[0]%f  Z[1]%f \n",z0,p*2)
		}
		z = (z0 , p*2);
	}	
	return z;
}