# Welch's Test

func stat_fbeta(x, a, b){
	const MAXIT = 100;
	const EPS = 3*10^(-7);
	const FPMIN = 10^(-30);
	qab = a+b;
	qap = a+1;
	qam = a-1;
	c = 1;
	d = 1-qab*x/qap;

	if(abs(d) < FPMIN){
		d = FPMIN;
	}
	d = 1/d;
	hh = d;

	for(m=1; m<=MAXIT; m++){
		m2 = 2*m;
		aa = m*(b-m)*x/((qam+m2)*(a+m2));
		d = 1+aa*d;
		if(abs(d) < FPMIN){
			d = FPMIN;
		}
		c = 1+aa/c;
		if(abs(c) < FPMIN){
			c = FPMIN;
		}
		d = 1/d;
		hh = hh * (d*c);
		aa = (-1) * (a+m) * (qab+m) * x / ((a+m2) * (qap+m2));
		d = 1+aa*d;
		if(abs(d) < FPMIN){
			d = FPMIN;
		}
		c = 1+aa/c;
		if(abs(c) < FPMIN){
			c = FPMIN;
		}
		d = 1/d;
		del = d*c;
		hh = hh * del;
		if(abs(del-1) < EPS){
			break;
		}
	}

	if(m > MAXIT){
		printf("Error : Illegal parameter ! ( during calculating P-Value )\n");
		abort();
	} else {
		return hh;
	}
}

func stat_caltcdf2(t,df){

	x = df/(df+t*t);
	a = df/2;
	b = 0.5;

	if(x == 0.0 || x == 1.0){
		bt = 0.0;
	} else {
		bt = exp(stat_lggamma(a+b)-stat_lggamma(a)-stat_lggamma(b)+a*log(x)+b*log(1.0-x));
	}

	if(x < (a+1.0)/(a+b+2.0)){
		ret = bt*stat_fbeta(x, a, b)/a;
	} else {
		ret = 1.0-bt*stat_fbeta(1.0-x, b, a)/b;
	}
	return ret/2;
}

func welch(x,y,type){
	check1 = stat_checkvartype(x,"either",0);
	check1 = stat_checkvartype(y,"either",0);
	check1 = stat_checkvartype(type,"string",0);
	check1 = stat_checksideflg(type);

	nx = indexsize(x);
	ny = indexsize(y);
	check0 = stat_checkdivision0((nx-1)*(ny-1),"T Value");
	varx = var(x);
	vary = var(y);

	numer = ave(x) - ave(y);
	denom = sqrt(varx/nx + vary/ny);
	check0 = stat_checkdivision0(denom,"T Value");
	t = numer / denom;
	df = (varx/nx + vary/ny)^2/((varx/nx)^2/(nx-1)+(vary/ny)^2/(ny-1));
	p = stat_caltcdf2(abs(t),df);
 
	if(type=="T"){
		p = 2*p;
	} else if(type=="O") {
		t = abs(t);
	}

	ret = (t, p);
	return ret;
}