# Student's t-Test

# Not Paired
func ttest(x,y,type){
	check1 = stat_checkvartype(x,"either",0);
	check1 = stat_checkvartype(y,"either",0);
	check1 = stat_checkvartype(type,"string",0);
	check1 = stat_checksideflg(type);

	avex = ave(x);
	avey = ave(y);
	x2 = sum((x-avex)^2);
	y2 = sum((y-avey)^2);
	cntx = indexsize(x);
	cnty = indexsize(y);
	df = cntx + cnty - 2;
	a1 = avex - avey;
	check0 = stat_checkdivision0(df*(x2+y2),"T Value");
	a2 = (x2 + y2) / df;
	a3 = (1/cntx) + (1/cnty);

	t = a1 / sqrt(a2 * a3);
	p = stat_caltcdf(abs(t),df,0);

	if(type=="T"){
		p = 2*p;
	} else if(type=="O") {
		t = abs(t);
	}

	ret = (t, p);
	return ret;
}

# Paired
func ttestp(x,y,type){
	check1 = stat_checkvartype(x,"either",0);
	check1 = stat_checkvartype(y,"either",0);
	check1 = stat_checkelementcnt(x,y);
	check1 = stat_checkvartype(type,"string",0);
	check1 = stat_checksideflg(type);

	z = x - y;
	avez = ave(z);
	z2 = sum((z-avez)^2);
	n = indexsize(x);
	check0 = stat_checkdivision0(z2*n*(n-1),"T Value");
	t = avez / sqrt(z2/n/(n-1));
	p = stat_caltcdf(abs(t),n-1,0);

	if(type=="T"){
		p = 2*p;
	} else if(type=="O") {
		t = abs(t);
	}

	ret = (t, p);
	return ret;
}