# T PROBABILITY DISTIBUTION FUNCTION

func stat_caltpdf(x,v){
	check1 = stat_checkisscalar(x);
	check2 = stat_checkisscalar(v);
	check3 = stat_checkpositiveint(v);

	lgg1 = stat_lggamma((v+1)/2);
	lgg2 = stat_lggamma(v/2);
	lgv = log(v * PI)/2;
	lgx = ((v+1)/2) * log(1+x*x/v);
	lgret = lgg1 - (lgv + lgg2 + lgx);
	ret = exp(lgret);
	
	return ret;
}

func tpdf(x,v){
	if (typeof(x)=="scalar"){
		ret = stat_caltpdf(x,v);
		return ret;
	}else{
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_caltpdf(y:[i],v);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}
