# INVERSE CUMULATIVE DISTRIBUTION FUNCTION OF THE T-DISTRIBUTION

func stat_tdiff(x,v){
	check1 = stat_checkisscalar(x);
	check2 = stat_checkisscalar(v);
	
	ret = stat_caltcdf(x,v,1);
	return ret;
}

func stat_tnewton(x1,v1,p){
	check1 = stat_checkisscalar(x1);
	check2 = stat_checkisscalar(v1);
	check4 = stat_checkisscalar(p);
	
	eps1 = 10^(-6);
	eps2 = 10^(-10);

	x = x1;
	ind = 0;
	sw = 0;

	while(sw ==0 && ind>= 0){
		ind ++;
		sw = 1;
		
		g = (1-stat_caltcdf(x1,v1,0))-1+p;
		
		if(abs(g) > eps2){
			if(ind<=100){
				
				dg = stat_tdiff(x1,v1);
				
				if(abs(dg)>eps2){
					x = x1-g/dg;
					if(abs(x-x1)>eps1 && abs(x-x1)>eps1*abs(x)){
						x1 = x;
						sw = 0;
					} else{
						ind = -1;
					}
				} else{
					ind = -1;
				}
			}
		}
	}
	
	return x;
}

func stat_caltinv(p,v){
	check1 = stat_checkisscalar(p);
	check2 = stat_checkisscalar(v);
	check3 = stat_checkpvalue(p);
	check4 = stat_checkpositiveint(v);
	
	pis = sqrt(PI);
	df = v;
	df2 = 0.5*df;
	
	if(df==1){
		tt = tan(PI*(0.5-p));
		
	} else if(df==2){
		if(p > 0.5){
			c=-1;
		} else{
			c=1;
		}
		p2  = (1 - 2 * p);
		p2 *= p2;
		tt  = c * sqrt(2 * p2 / (1 - p2));
	
	} else{
		yq = stat_calnormsinv(p);
		
		x  = 1 - 1 / (4 * df);
		e  = x * x - yq * yq / (2 * df);

		if (e > 0.5){
			t0 = yq / sqrt(e);
		}else {
			x  = sqrt(df) / (pis * p * df * stat_gamma(df2) / stat_gamma(df2+0.5));
			t0 = pow(x, 1.0/df);
		}

		tt = stat_tnewton(t0,v,p);
		
	}
	return tt;
}

func tinv(x,v){
	if (typeof(x)=="scalar"){
		ret = stat_caltinv(x,v);
		return ret;
	}else{
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_caltinv(y:[i],v);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}