# CUMULATIVE DISTRIBUTION FUNCTION OF THE T-DISTRIBUTION

func stat_caltcdf(x,v,flg){
	check1 = stat_checkisscalar(x);
	check2 = stat_checkisscalar(v);
	check3 = stat_checkpositiveint(v);

	if(abs(x) < 10^(-10)){
		tt = sgn(x) * 10^(-10);
	} else {
		tt = x;
	}
	t2 = tt * tt;
	t  = t2 / (t2 + v);

	if(v%2 != 0) {
		u  = sqrt(t*(1.0-t)) / PI;
		p  = 1.0 - 2.0 * atan2(sqrt(1.0-t), sqrt(t)) / PI;
		ia = 1;
	} else {
		u  = sqrt(t) * (1.0 - t) / 2.0;
		p  = sqrt(t);
		ia = 2;
	}

	if (ia != v) {
		for (i1 = ia; i1 <= v-2; i1 += 2) {
			p += 2.0 * u / i1;
			u *= (1.0 + i1) / i1 * (1.0 - t);
		}
	}
	
	if(flg==1){
		dd = u/abs(tt);
		return dd;
	}
	
	pp  = 0.5 + 0.5 * sgn(tt) * p;
	pp = 1 - pp;

	return pp;
}

func tcdf(x,v){
	if(typeof(x)=="scalar"){
		ret = stat_caltcdf(x,v,0);
		return ret;
	} else {
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_caltcdf(y:[i],v,0);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}