# Principal Component Analysis

proc stat_printmatrix(x,name1,name2){
	for(i=0;i<length(x);i++){
		if(i==0){
			for(j=0;j<length(x);j++){
				printf("	%s%d",name1,j);
			}
		}
		printf("\n");
		for(j=0;j<length(x);j++){
			if(j==0){
				printf("%s%d ",name2,i);
			}
			if(Scalar(x[i][j])>=0) printf(" ");
			printf("%f ",Scalar(x[i][j]));
		}
	}
}

proc stat_printarray(x,name){
	for(i=0;i<indexsize(x);i++){
		printf("	%s%d",name,i+1);
	}
	printf("\n");
	for(i=0;i<indexsize(x);i++){
		printf("%f ",Scalar(x[i]));
	}
}

func pca(x){
	check1 = stat_checkvartype(x, "either", 1);
	if(length(x)<=1){
		printf("Error : Illegal parameter - too small element count ! \n");
		abort();
	}

	ca = corrcoefmat(x);
	a = ca;
	n = length(a);

	series default[n];
	default[0] = 1;
	u = trans(default);
	
	series eigenval[n];
	series eigenvec[n];
	
	for(i=0;i<n;i++){
		flg = "true";
		while(flg=="true"){
			au = mul(a,u);
			normval = sum(pow(au,2));
			eig = sqrt(normval);
			u2 = au / eig;
			
			if(max(abs(u-u2))<0.000001){
				u = u2;
				flg = "false";
			}
			u = u2;
		}
		
		uu = u[0];
		eigenval[i] = eig;
		eigenvec[i] = uu;

		series aa[n*n];
		count = 0;
		for(j=0;j<n;j++){
			for(k=0;k<n;k++){
				aa[count++] = uu:[j] * uu:[k];
 			}
		}
		aa = eig * reform(aa,(n,n));
		a = a-aa;
		u = trans(uu);
	}

	series coef[n];
	for(i=0;i<n;i++){
		std = stddev(x[i]);
		coef:[i] = eigenvec:[i]/std;
	}

	series avex[n];
	for(i=0;i<n;i++){
		avex[i] = ave(x[i]);
	}
	
	series cons[n];
	scoef = Snapshot(coef);
	for(i=0;i<n;i++){
		series vv[n];
		for(j=0;j<n;j++){
			vv[j] = (scoef[j][i]*avex[j]);
		}
		cons[i] = -sum(vv);
	}
	
	snapshot fact[n][n];
	for(i=0;i<n;i++){
		vec = eigenvec[i];
		for(j=0;j<length(vec);j++){
			fact[j][i] = vec:[j]*sqrt(eigenval[i]);
		}
	}
	
	series cratio[n];
	series cumcratio[n];
	for(i=0;i<n;i++){
		cratio[i] = eigenval[i]/n;
		if(i==0){
			cumcratio[i] = cratio[i];
		} else{
			cumcratio[i] = cumcratio[i-1] + cratio[i];
		}
	}

	xx = Snapshot(x);
	snapshot princ[length(x)][n];
	for(i=0;i<n;i++){
		for(j=0;j<length(x);j++){
			series zz[n];
			for(k=0;k<n;k++){
				zz[k] = scoef[k][i] * xx[j][k];
			}
			princ[j][i] = sum(zz) + cons[i];
		}
	}
	
	printf("Correlation Coefficient Matrix\n");
	stat_printmatrix(Snapshot(ca),"Var","Var");
	printf("\n\nEigenvalue\n");
	stat_printarray(eigenval," ");
	printf("\n\nEigenVectors\n");
	stat_printmatrix(Snapshot(eigenvec),"PCA","Vec");
	printf("\n\nCoefficientVectors\n");
	stat_printmatrix(Snapshot(coef),"PCA","Vec");
	printf("\n\nConstant\n");
	stat_printarray(cons," ");
	printf("\n\nFactor Loadings\n");
	stat_printmatrix(Snapshot(fact),"PCA","Vec");
	printf("\n\nContribution\n");
	stat_printarray(cratio," ");
	printf("\n\nCumulative Contribution\n");
	stat_printarray(cumcratio," ");
	printf("\n");
	
	return princ;
}