# NORMAL PROBABILITY DISTRIBUTION FUNCTION

func stat_calnormpdf(x,mu,sig){
	check1 = stat_checkisscalar(x);
	check2 = stat_checkisscalar(mu);
	check3 = stat_checkisscalar(sig);
	check4 = stat_checkpositive(sig);
	
	a = sqrt(2 * PI) * sig;
	b = ((x - mu)*(x - mu)) / (2*sig*sig);
	ret = 1/(a*exp(b));
	return ret;
}

func normpdf(x,mu,sig){
	if (typeof(x)=="scalar"){
		ret = stat_calnormpdf(x,mu,sig);
		return ret;
	}else{
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_calnormpdf(y:[i],mu,sig);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}