# INVERSE CUMULATIVE DISTIBUTION FUNCTION OF THE NORMAL DISTIBUTION

func stat_calnormsinv(x){
	check1 = stat_checkisscalar(x);
	check2 = stat_checkpvalue(x);
	
	a1 = 1.570796288;
	a2 = 0.03706987906;
	a3 = -8.364353589 * 10^(-4);
	a4 = -2.250947176 * 10^(-4);
	a5 =  6.841218299 * 10^(-6);
	a6 =  5.824238515 * 10^(-6);
	a7 = -1.04527497 * 10^(-6);
	a8 =  8.360937017 * 10^(-8);
	a9 = -3.231081277 * 10^(-9);
	
	y = - log(4 * x * (1 - x));
	y = y * (a1 + y * (a2 + y * (a3 + y * (a4 + y * (a5 + y * (a6 + y * (a7 + y * (a8 + y * a9))))))));
	ret = sqrt(y);
	
	if(x > 0.5){
		ret = -ret;
	}
	
	return ret;
}

func stat_normsinv(x){
	if (typeof(x)=="scalar"){
		ret = stat_calnormsinv(x);
		return ret;
	}else{
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_calnormsinv(y:[i]);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}

}

func norminv(x,mu,sig){
	check1 = stat_checkisscalar(mu);
	check2 = stat_checkisscalar(sig);
	check3 = stat_checkpositive(sig);
	
	if (typeof(x)=="scalar"){
		ret = mu + sig * stat_calnormsinv(x);
		return ret;
	}else{
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_calnormsinv(y:[i]);
		}
		
		rets = mu + sig * reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}