# Multi-Regression Analysis

func mregression(x,y,m,type){
	check1 = stat_checkisscalar(m);
	check1 = stat_checkpositiveint(m);
	check1 = stat_checkvartype(x,"either",0);
	check1 = stat_checkvartype(y,"either",0);
	check1 = stat_checkelementcnt(x,y);
	check1 = stat_checkvartype(type,"string",0);
	check1 = stat_checksideflg(type);
	
	msg0 = " cannot calculate inverse matrix ! \n";
	
	n = indexsize(x);
	if(m >= n-1){
		printf("Error : Illegal parameter - too big dimension m !\n");
		abort();
	}

	srx = reform(x,n);
	sry = reform(y,n);

	series mX[m+1],mA,mY,mtX;
	for(j=0; j<=m; j++){
		mX[j] = srx^j;
	}
	mtX = trans(mX);
	mY = trans(sry);
	
	if(det((mul(mtX,mX)))==0){
		printf(msg0);
		abort();
	}else{
		mA = mul(mul(inv((mul(mtX,mX))), mtX), mY);
	}

	regY = mul(mX,mA);
	regAveY = ave(regY);
	SSr = sum((regY - regAveY)^2);
	SSe = sum((mY-regY)^2);
	SSt = SSr + SSe;
	Dfr = m;
	Dfe = n-m-1;
	Dft = n-1;
	check0 = stat_checkdivision0(Dfe*Dft,"MS Value");
	MSr = SSr/Dfr;
	MSe = SSe/Dfe;
	MSt = SSt/Dft;
	check0 = stat_checkdivision0(MSe,"F Value");
	Fr = MSr/MSe;
	Pr = fcdf(Fr,Dfr,Dfe);

	check0 = stat_checkdivision0(SSt,"R Value");
	R2 = 1 - SSe/SSt;
	R1 = sqrt(R2);
	R2a = 1 - MSe/MSt;

	srdataX = cut(mX,(0,1),index(mX)-1);
	sndataX = Snapshot(srdataX);
	snapshot aveXj[m];
	for(j=0;j<m;j++){
		aveXj[j] = ave(srdataX[j]);
	}

	snapshot mS[m][m];
	for(i=0; i<n; i++){
		for(j=0; j<m; j++){
			temp = 0;
			for(k=0; k<m; k++){
				temp = (sndataX[i][j]-aveXj[j])*(sndataX[i][k]-aveXj[k]);
				mS[j][k] = mS[j][k] + temp;
			}
		}
	}

	sty = stddev(sry);
	check0 = stat_checkdivision0(sty,"Std.Reg Coef");
	snapshot stregcoef[m+1];
	regcoef = Snapshot(reform(mA,indexsize(mA)));
	for(k=0;k<m;k++){
		stregcoef[k+1] = regcoef[k+1]*stddev(srdataX[k])/sty;
	}

	srRXY = trans(merge(trans(srdataX),reform(sry,(1,n))));
	srR = corrcoefmat(srRXY);

	if(det(srR)==0){
		printf(msg0);
		abort();
	}else{
		srinvR = inv(srR);
	}

	snapshot pcorrecoef[m+1];
	pcorrecoef[0] = -1;
	for(k=0;k<m;k++){
		temp = get(srinvR[m],m) * get(srinvR[k],k);
		check0 = stat_checkdivision0(temp,"Par.Reg Coef");
		pcorrecoef[k+1] = (-1) * get(srinvR[m],k) / sqrt(temp);
	}

	if(det(mS)==0){
		printf(msg0);
		abort();
	}else{
		invmS = Snapshot(inv(mS));
	}
	snapshot regSe[m+1];
	temp = 0;
	for(i=0;i<m;i++){
		for(j=0;j<m;j++){
			temp += aveXj[i] * aveXj[j] * invmS[i][j];
		}
	}
	regSe[0] = sqrt((1/n + temp)*MSe);
	for(k=0;k<m;k++){
		regSe[k+1] = sqrt(invmS[k][k] * MSe);
	}

	snapshot regT[m+1], regP[m+1];
	for(k=0;k<m+1;k++){
		check0 = stat_checkdivision0(regSe[k],"T Value");
		regT[k] = regcoef[k] / regSe[k];
		regP[k] = stat_caltcdf(abs(regT[k]),n-m-1,0);
	}

	if(type=="T"){
		regP = Snapshot(regP*2);
	} else if(type=="O") {
		regT = abs(regT);
	}

	printf("ANOVA Table\n");
	printf("Source\tSum of Squares\tDf\tMean Square\tF Value\t\tP Value\n");
	printf("Reg\t%f\t%d\t%f\t%f\t%f\n",SSr,Dfr,MSr,Fr,Pr);
	printf("Error\t%f\t%d\t%f\n",SSe,Dfe,MSe);
	printf("Total\t%f\t%d\t%f\n",SSt,Dft,MSt);
	printf("\n");
	printf("Coefficient of Determination\n");
	printf("multiple correlation coefficient\t%f\n",R1);
	printf("coefficient of determination\t\t%f\n",R2);
	printf("... adjusted for the degrees of freedom\t%f\n",R2a);
	printf("\n");
	printf("Regression Coefficient Test\n");
	printf("Dim\tReg Coef\tSE\t\tT Value\t\tP Value\t\tStd.Reg Coef\tPar.Reg Coef\n");
	for(k=0;k<m+1;k++){
		printf("%d\t%f\t%f\t%f\t%f\t%f\t%f\n",k,regcoef[k],regSe[k],regT[k],regP[k],stregcoef[k],pcorrecoef[k]);
	}

	ret = (Fr, Pr);
	return ret;
}
