# Homogeneity of Variance Test

func homogeneity(x, n){
	check1 = stat_checkvartype(x, "either", 1);
	check1 = stat_checkvartype(n, "series", 0);
	check1 = stat_checkpositiveints(n);
	check1 = stat_checkgroupcnt(x, n);

	scalar B;
	series ret;
	scalar cnt;
	scalar sumU, sumlU, sumN, sumN2;
	
	if(typeof(x)=="snapshot"){
		sx = Series(x)
	} else {
		sx = x;
	}
	
	cnt = indexsize(n);
	snapshot U[cnt];

	for(i = 0; i < cnt; i++){
		check1 = stat_checkdivision0((n:[i]-1),"Var");
		U[i] = var(cut(sx[i],0,n:[i]-1));
		sumU += (n:[i]-1) * U[i];
		check1 = stat_checkdivision0(U[i],"LOG");
		sumlU += (n:[i]-1) * log(U[i]);
		check1 = stat_checkdivision0((n:[i]-1),"B-Value");
		sumN2 += 1 / (n:[i]-1);
	}
	sumN = sum(n) - cnt;
	check1 = stat_checkdivision0((sumU/sumN) * sumN,"LOG");
	Up2 = sumN * log(sumU/sumN) - sumlU;
	C = 1 + 1/3/(index(n)-1)*(sumN2 - 1/sumN);
	check1 = stat_checkdivision0(C,"B-Value");
	B = Up2/C;
	P = chi2cdf(B,index(n)-1);
	
	ret = (B,P);
	return ret;
}