# F PROBABILITY DISTIBUTION FUNCTION

func stat_calfpdf(x,v1,v2){
	check1 = stat_checkisscalar(x);
	check2 = stat_checkisscalar(v1);
	check3 = stat_checkisscalar(v2);
	check4 = stat_checkpositiveint(v1);
	check5 = stat_checkpositiveint(v2);

	if(x == 0){
		ret = 0;
	} else {
		lgv1 = stat_lggamma(v1/2);
		lgv2 = stat_lggamma(v2/2);
		lgv1v2 = stat_lggamma((v1+v2)/2);
		lg12 = (v1/2)*log(v1/v2);
		lgx = (v1-2)/2*log(x);
		lg12x = (v1+v2)/2*log(1+(v1/v2)*x);
		lgret = lgv1v2 - lgv1 - lgv2 + lg12 + lgx - lg12x;
		ret = exp(lgret);
	}
	return ret;
}

func fpdf(x,v1,v2){
	if (typeof(x)=="scalar"){
		ret = stat_calfpdf(x,v1,v2);
		return ret;
	} else {
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_calfpdf(y:[i],v1,v2);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}