# INVERSE CUMULATIVE DISTRIBUTION FUNCTION OF THE F-DISTRIBUTION

func stat_fdiff(x,v1,v2){
	check1 = stat_checkisscalar(x);
	check2 = stat_checkisscalar(v1);
	check3 = stat_checkisscalar(v2);
	
	ret = stat_calfcdf(x,v1,v2,1);
	return ret;
}

func stat_fnewton(x1,v1,v2,p){
	check1 = stat_checkisscalar(x1);
	check2 = stat_checkisscalar(v1);
	check3 = stat_checkisscalar(v2);
	check4 = stat_checkisscalar(p);
	
	eps1 =10^(-6);
	eps2 =10^(-10);

	x = x1;
	ind = 0;
	sw = 0;

	while(sw ==0 && ind>= 0){
		ind ++;
		sw = 1;
		
		g = (1-stat_calfcdf(x1,v1,v2,0))-1+p;
		
		if(abs(g) > eps2){
			if(ind<=100){
				
				dg = stat_fdiff(x1,v1,v2);
				
				if(abs(dg)>eps2){
					x = x1-g/dg;
					if(abs(x-x1)>eps1 && abs(x-x1)>eps1*abs(x)){
						x1 = x;
						sw = 0;
					} else{
						ind = -1;
					}
				} else{
					ind = -1;
				}
			}
		}
	}
	
	return x;
}

func stat_calfinv(p,v1,v2){
	check1 = stat_checkisscalar(p);
	check2 = stat_checkisscalar(v1);
	check3 = stat_checkisscalar(v2);
	check4 = stat_checkpvalue(p);
	check5 = stat_checkpositiveint(v1);
	check6 = stat_checkpositiveint(v2);
	
	sw = 0;
	mx = 340;

	df1 = 0.5 * (v1-sw);
	df2 = 0.5 * (v2-sw);
	a = 2/(9*(v1-sw));
	a1 = 1-a;
	b = 2/(9*v2);
	b1 = 1-b;
	
	yq = stat_calnormsinv(p);
	e = b1*b1-b*yq*yq;
	
	if(e>0.8 || (yq+v2-sw)<=mx){
		sw = -1;
		
	} else{
		sw += 1;
		if((v1-sw) == 0){
			sw = -2;
		}
	}
	
	if(sw == -2){
		p = -1;

	} else{
		if(e>0.8){
			x = (a1*b1+yq*sqrt(a1*a1*b+a*e))/e;
			f0 = pow(x,3);
		
		} else {

			lg12 = stat_lggamma(df1+df2);
			lg1 = stat_lggamma(df1);
			lg2 = stat_lggamma(df2);
			lgv1 = df2 * log(v1);
			lgv2 = (df2-1)*log(v2);
			lg = (2/v2) * (lg12 + log(2) + lgv2 - lg1 - lg2 - lgv1);
			f0 = exp(lg);
		}
		
		ans = stat_fnewton(f0,v1,v2,p);
	}
	return ans;
}

func finv(p,v1,v2){
	if (typeof(p)=="scalar"){
		ans = stat_calfinv(p,v1,v2);
		return ans;
	
	} else{
		y=reform(p,(indexsize(p)));
		series rets[indexsize(p)];
		
		for(i=0;i<indexsize(p);i++){
			rets[i] = stat_calfinv(y:[i],v1,v2);
		}
		
		rets = reform(rets,index(p));
		
		if(typeof(p)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}