# CHI2 PROBABILITY DISTRIBUTION FUNCTION

func stat_calchi2pdf(x,v){
	check1 = stat_checkisscalar(x);
	check2 = stat_checkisscalar(v);
	check3 = stat_checkpositiveint(v);

	if(x == 0){
		ret = 0;
	} else {
		lgx = (v-2)*log(x);
		lge = x;
		lg2 = v*log(2);
		lgg = 2*stat_lggamma(v/2);
		lgret = (lgx - (lge + lg2 + lgg))/2;
		ret = exp(lgret);
	}
	return ret;
}

func chi2pdf(x,v){
	if (typeof(x)=="scalar"){
		ret = stat_calchi2pdf(x,v);
		return ret;
	}else{
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_calchi2pdf(y:[i],v);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}