# CUMULATIVE DISTRIBUTION FUNCTION OF THE CHI2 DISTRIBUTION

func stat_calchi2cdf(x, v){
	check1 = stat_checkisscalar(x);
	check2 = stat_checkisscalar(v);
	check3 = stat_checkpositiveint(v);

	if(x <= 0){
		return 1;
	}

	if(v > 10) {
		w = 2 / (9 * v);
		pw = pow(x / v, 1 / 3);
		ret = stat_calnormscdf((pw - 1 + w) / sqrt(w));
		return ret;
	}
	w = exp(-x / 2);
	if(v == 2){
		return w;
	}
	sx = sqrt(x);
	if(v == 1){
		ret = 2 * stat_calnormscdf(sx);
		return ret;
	}
	if((v % 2) == 0){
		i1 = 2;
		qc = w;
	} else {
 		i1 = 1;
		qc = 2 * stat_calnormscdf(sx);
		w *= (0.797884560750774 / sx);
	}
	
	for(i = i1; i <= v - 2; i += 2) {
		w *= (x / i);
		qc += w;
	}
	return qc;
}

func chi2cdf(x,v){
	if (typeof(x)=="scalar"){
		ret = stat_calchi2cdf(x,v);
		return ret;
	}else{
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_calchi2cdf(y:[i],v);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}
