# 2-way ANOVA

func anova2(x,n,type){
	const CRF_TYPE = "N";
	const SPF_TYPE = "NP";
	const RBF_TYPE = "P";
	
	check1 = stat_checkvartype(x,"either",2);
	check1 = stat_checkvartype(n,"series",1);
	check1 = stat_checkpositiveints(n);
	check1 = stat_checkgroupcnt(x,n);
	check1 = stat_checkanovatype(2,type);

	scalar eqlflg;
	scalar temp;
	
	srx = Series(x);
	snn = Snapshot(n);
	
	idx = Snapshot(index(snn));
	scalar Na,Nb;
	Na = idx[1];
	Nb = idx[0];

	eqlflg = 1;
	for(i = 0; i < idx[0]; i++){
		for(j = 0; j < idx[1]; j++){
			if(snn[0][0] != snn[i][j]){
				eqlflg = 0;
				break;
			}
		}
		if(eqlflg == 0){
			break;
		}
	}

	if((type == SPF_TYPE) && (eqlflg == 0)){
		for(j=0; j<Na; j++){
			for(i=1; i<Nb; i++){
				if(snn[i][j] != snn[0][j]){
					printf("Error : Illegal parameter - not support combination parameter !\n");
					abort();
				}
			}
		}
	}
	if(type == RBF_TYPE){
		if(eqlflg == 0){
			printf("Error : Illegal parameter - not support combination parameter!\n");
			abort();
		}
	}

	scalar ABS, AB;
	ABS = sum(srx^2);
	for(i = 0; i < idx[0]; i++){
		for(j = 0; j < idx[1]; j++){
			AB += sum(srx[i][j])^2 / snn[i][j];
		}
	}

	if(eqlflg == 1){
		scalar G,X,A,B;
		G = sum(srx);
		X = G^2 / (snn[0][0]*Na*Nb);
		for(j=0; j<Na; j++){
			temp = 0;
			for(i=0; i<Nb; i++){
				temp += sum(srx[i][j]);
			}
			A += temp^2/(snn[0][0]*Nb);
		}
		for(i=0; i<Nb; i++){
			temp = 0;
			for(j=0; j<Na; j++){
				temp += sum(srx[i][j]);
			}
			B += temp^2 / (snn[0][0]*Na);
		}
	} else {
		scalar G2,X2,A2,B2,AB2,n2;
		snapshot aveAB[Nb][Na];

		for(i=0; i<Nb; i++){
			for(j=0; j<Na; j++){
				aveAB[i][j] = sum(srx[i][j])/snn[i][j];
			}
		}

		G2 = sum(aveAB);
		X2 = G2^2 / (Na*Nb);
		AB2 = sum(aveAB^2);
		for(j=0; j<Na; j++){
			temp = 0;
			for(i=0; i<Nb; i++){
				temp += aveAB[i][j];
			}
			A2 += (temp/Nb)^2;
		}
		A2 = Nb * A2;

		for(i=0; i<Nb; i++){
			temp = 0;
			for(j=0; j<Na; j++){
				temp += aveAB[i][j];
			}
			B2 += (temp/Na)^2;
		}
		B2 = Na * B2;

		temp = 0;
		for(i=0; i<Nb; i++){
			for(j=0; j<Na; j++){
				temp += 1/snn[i][j];
			}
		}
		n2 = Na * Nb / temp;
	}

	if(type != CRF_TYPE){
		scalar AS;
		maxk = max(snn);
		snapshot Ski[maxk][Na];
		for(j=0; j<Na; j++){
			for(k=0; k<maxk; k++){
				temp = 0;
				
				for(i=0; i<Nb; i++){
					if(k < snn[i][j]){
						temp += get(srx[i][j], k);
					} else {
						break;
					}
				}
				Ski[k][j] = temp;
			}
		}
		AS = sum(Ski^2/Nb);
	}

	if((type == SPF_TYPE) && (eqlflg == 0)){
		scalar A;
		for(j=0; j<Na; j++){
			temp = 0;
			for(i=0; i<Nb; i++){
				temp += sum(srx[i][j]);
			}
			A += temp^2 / (snn[0][j]*Nb);
		}
	}

	if(type == RBF_TYPE){
		scalar S,BS;
		for(k=0; k<snn[0][0]; k++){
			temp = 0;
			for(j=0; j<Na; j++){
				temp += Ski[k][j];
			}
			S += temp^2 / (Na*Nb);
		}
		for(i=0; i<Nb; i++){
			for(k=0; k<snn[0][0]; k++){
				temp = 0;
				for(j=0; j<Na; j++){
					temp += get(srx[i][j], k);
				}
				BS += temp^2 / Na;
			}
		}
	}

	scalar SSa, SSb, SSab;
	if(eqlflg == 1){
		scalar SSt;
		SSa = A - X;
		SSb = B - X;
		SSab = AB - A - B + X;
		SSt = ABS - X;
	} else {
		SSa = n2 * (A2 - X2);
		SSb = n2 * (B2 - X2);
		SSab = n2 * (AB2 - A2 - B2 + X2);
	}
	
	if(type == CRF_TYPE){
		scalar SSwc;
		SSwc = ABS - AB;
	} else if(type == SPF_TYPE){
		scalar SSsa, SSbsa;
		SSsa = AS -A;
		SSbsa = ABS - AB - AS + A;
	} else if(type == RBF_TYPE){
		scalar SSs, SSas, SSbs, SSabs;
		SSs = S - X;
		SSas = AS - A - S + X;
		SSbs = BS - B - S + X;
		SSabs = ABS - AB - AS - BS + A + B + S - X;
	}

	scalar DFa, DFb, DFab, MSa, MSb, MSab;
	DFa = Na-1;
	DFb = Nb-1;
	DFab = DFa * DFb;
	check0 = stat_checkdivision0(DFab,"MS Value");
	MSa = SSa / DFa;
	MSb = SSb / DFb;
	MSab = SSab / DFab;
	if(eqlflg == 1){
		scalar DFt;
		DFt = snn[0][0] * Na * Nb -1;
	}
	if(type == CRF_TYPE){
		scalar DFwc, MSwc;
		DFwc = sum(snn) - Na*Nb;
		check0 = stat_checkdivision0(DFwc,"MS Value");
		MSwc = SSwc / DFwc;
	} else if(type == SPF_TYPE){
		scalar DFsa, DFbsa, MSsa, MSbsa;
		for(j=0; j<Na; j++){
			DFsa += snn[0][j];
		}
		DFsa -= Na;
		DFbsa = DFsa * DFb;
		check0 = stat_checkdivision0(DFbsa,"MS Value");
		MSsa = SSsa/DFsa;
		MSbsa = SSbsa/DFbsa;
	} else if(type == RBF_TYPE){
		scalar DFs, DFas, DFbs, DFabs, MSs, MSas, MSbs, MSabs;
		DFs = snn[0][0] - 1;
		DFas = DFa * DFs;
		DFbs = DFb * DFs;
		DFabs = DFa * DFb * DFs;
		check0 = stat_checkdivision0(DFabs,"MS Value");
		MSs = SSs/DFs;
		MSas = SSas/DFas;
		MSbs = SSbs/DFbs;
		MSabs = SSabs/DFabs;
	}

	scalar Fa, Fb, Fab, Pa, Pb, Pab;
	if(type == CRF_TYPE){
		check0 = stat_checkdivision0(MSwc,"F Value");
		Fa = MSa/MSwc;
		Fb = MSb/MSwc;
		Fab = MSab/MSwc;
		Pa = stat_calfcdf(Fa, DFa, DFwc, 0);
		Pb = stat_calfcdf(Fb, DFb, DFwc, 0);
		Pab = stat_calfcdf(Fab, DFab, DFwc, 0);
	} else if(type == SPF_TYPE){
		check0 = stat_checkdivision0(MSsa*MSbsa,"F Value");
		Fa = MSa/MSsa;
		Fb = MSb/MSbsa;
		Fab = MSab/MSbsa;
		Pa = stat_calfcdf(Fa, DFa, DFsa, 0);
		Pb = stat_calfcdf(Fb, DFb, DFbsa, 0);
		Pab = stat_calfcdf(Fab, DFab, DFbsa, 0);
	} else if(type == RBF_TYPE){
		check0 = stat_checkdivision0(MSas*MSbs*MSabs,"F Value");
		Fa = MSa/MSas;
		Fb = MSb/MSbs;
		Fab = MSab/MSabs;
		Pa = stat_calfcdf(Fa, DFa, DFas, 0);
		Pb = stat_calfcdf(Fb, DFb, DFbs, 0);
		Pab = stat_calfcdf(Fab, DFab, DFabs, 0);
	}

	printf("TWOWAY ANOVA TABLE\n");
	printf("Source\tSum of Squares\tDf\tMean Square\tF Value\t\tP Value\n");
	if(type == CRF_TYPE){
		printf("A\t%f\t%d\t%f\t%f\t%f\n",SSa,DFa,MSa,Fa,Pa);
		printf("B\t%f\t%d\t%f\t%f\t%f\n",SSb,DFb,MSb,Fb,Pb);
		printf("A*B\t%f\t%d\t%f\t%f\t%f\n",SSab,DFab,MSab,Fab,Pab);
		printf("WC\t%f\t%d\t%f\n",SSwc,DFwc,MSwc);
	} else if(type == SPF_TYPE){
		printf("A\t%f\t%d\t%f\t%f\t%f\n",SSa,DFa,MSa,Fa,Pa);
		printf("S(A)\t%f\t%d\t%f\n",SSsa,DFsa,MSsa);
		printf("B\t%f\t%d\t%f\t%f\t%f\n",SSb,DFb,MSb,Fb,Pb);
		printf("A*B\t%f\t%d\t%f\t%f\t%f\n",SSab,DFab,MSab,Fab,Pab);
		printf("B*S(A)\t%f\t%d\t%f\n",SSbsa,DFbsa,MSbsa);
	} else if(type == RBF_TYPE){
		printf("S\t%f\t%d\t%f\n",SSs,DFs,MSs);
		printf("A\t%f\t%d\t%f\t%f\t%f\n",SSa,DFa,MSa,Fa,Pa);
		printf("A*S\t%f\t%d\t%f\n",SSas,DFas,MSas);
		printf("B\t%f\t%d\t%f\t%f\t%f\n",SSb,DFb,MSb,Fb,Pb);
		printf("B*S\t%f\t%d\t%f\n",SSbs,DFbs,MSbs);
		printf("A*B\t%f\t%d\t%f\t%f\t%f\n",SSab,DFab,MSab,Fab,Pab);
		printf("A*B*S\t%f\t%d\t%f\n",SSabs,DFabs,MSabs);
	}
	if(eqlflg == 1){
		printf("Total\t%f\t%d\n",SSt,DFt);
	}

	series ret[2];
	ret[0] = (Fa, Fb, Fab);
	ret[1] = (Pa, Pb, Pab);
	
	return ret;
}