# 1-way ANOVA

func anova1(x,n,type){
	const CR_TYPE = "N";
	const RB_TYPE = "P";
	
	check1 = stat_checkvartype(x,"either",1);
	check1 = stat_checkvartype(n,"series",0);
	check1 = stat_checkpositiveints(n);
	check1 = stat_checkgroupcnt(x,n);
	check1 = stat_checkanovatype(1,type);

	scalar eqlflg;
	scalar temp;
	
	srx = Series(x);
	snn = Snapshot(n);
	idx = index(srx);

	eqlflg = 1;
	for(j = 1; j < indexsize(snn); j++){
		if(snn[0] != snn[j]){
			eqlflg = 0;
			break;
		}
	}
	if(type == RB_TYPE){
		if(eqlflg == 0){
			printf("Error : Illegal parameter - not support combination parameter !\n");
			abort();
		}
	}

	scalar Na, N1, AS1, G1, X1, A1;
	Na = idx:[1];
	N1 = sum(snn);
	AS1 = sum(srx^2);
	G1 = sum(srx);
	X1 = G1^2 / N1;
	for(j=0; j<Na; j++){
		A1 += sum(srx[j])^2/snn[j];
	}
	if(type == RB_TYPE){
		scalar S1;
		len = idx:[0];
		for(k=0; k<len; k++){
			S1 += sum(srx:[k])^2 / Na;
		}
	}

	SSa = A1 - X1;
	SSt = AS1 - X1;
	DFa = Na - 1;
	DFt = N1 - 1;
	check0 = stat_checkdivision0(DFa,"MSa Value");
	MSa = SSa/DFa;
	if(type == CR_TYPE){
		SSwc = AS1 - A1;
		DFwc = N1 - Na;
		check0 = stat_checkdivision0(DFwc,"MSwc Value");
		MSwc = SSwc / DFwc;
	} else if(type == RB_TYPE){
		SSs = S1 - X1;
		SSres = AS1 - A1 - S1 + X1;
		DFs = snn[0] - 1;
		DFres = DFa * DFs;
		check0 = stat_checkdivision0(DFs,"MSs Value");
		check0 = stat_checkdivision0(DFres,"MSres Value");
		MSs = SSs/DFs;
		MSres = SSres/DFres;
	}

	if(type == CR_TYPE){
		check0 = stat_checkdivision0(MSwc,"F Value");
		Fa = MSa/MSwc;
		Pa = stat_calfcdf(Fa, DFa, DFwc,0);
	} else if(type == RB_TYPE){
		check0 = stat_checkdivision0(MSres,"F Value");
		Fa = MSa/MSres;
		Fs = MSs/MSres;
		Pa = stat_calfcdf(Fa, DFa, DFres,0);
		Ps = stat_calfcdf(Fs, DFs, DFres,0);
	}

	printf("\n");
	printf("ONEWAY ANOVA TABLE\n");
	printf("Source\tSum of Squares\tDf\tMean Square\tF Value\t\tP Value\n");
	printf("A\t%f\t%d\t%f\t%f\t%f\n",SSa,DFa,MSa,Fa,Pa);
	if(type == CR_TYPE){
		printf("WC\t%f\t%d\t%f\n",SSwc,DFwc,MSwc);
	} else if(type == RB_TYPE){
		printf("S\t%f\t%d\t%f\t%f\t%f\n",SSs,DFs,MSs,Fs,Ps);
		printf("RES\t%f\t%d\t%f\n",SSres,DFres,MSres);
	}
	printf("Total\t%f\t%d\n",SSt,DFt);

	series ret[2];
	if(type == CR_TYPE){
		ret[0] = Fa;
		ret[1] = Pa;
	} else if(type == RB_TYPE){
		series ret[2];
		ret[0] = (Fa, Fs);
		ret[1] = (Pa, Ps);
	}
	return ret;
}