/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: secdiff.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */

#define  MOD_NPE_LIBNPEE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "libsatellite.h"
#include "libnpec.h"
#include "libnpee.h"
#include "npeepriv.h"

/*********************************************************************
**  Subroutine of Differentiation				    **
*********************************************************************/

void npe_secondDifferential(npe_param_t  *vParam[], double  **Hess){
  int     i, j;
  double  xi, xj, hi, hj, f_;

  f_=0.0;
  for( i=0; i<(int)NumVarParam; i++ ) {
    xi = vParam[i]->value;
    hi = vParam[i]->span; 
    for( j=0; j<=i; j++ ){ 
      xj = vParam[j]->value;
      hj = vParam[j]->span; 
      if( i!=j ){                        /* calculate df/dxdy */

        vParam[i]->value = xi + hi;
        vParam[j]->value = xj + hj;
        f_  = npe_errorFunc( AllParam );     /* f(xi+hi,x2+hj)*/

        vParam[i]->value = xi - hi;
        vParam[j]->value = xj + hj;
        f_ -= npe_errorFunc( AllParam );     /* -f(xi-hi,x2+hj)*/

        vParam[i]->value = xi + hi;
        vParam[j]->value = xj - hj;
        f_ -= npe_errorFunc( AllParam );     /* -f(xi+hi,x2-hj)*/

        vParam[i]->value = xi - hi;
        vParam[j]->value = xj - hj;
        f_ += npe_errorFunc( AllParam );     /* +f(xi-hi,x2-hj)*/

        Hess[i][j] = f_/(4.0*hi*hj);     /* f''(x)=f_ /(4*hi*hj) */


      }else{                             /* calculate df/dx^2 */

        f_ =-2.0*npe_errorFunc( AllParam );  /* -2*f(xi,x2)*/

        vParam[i]->value = xi + hi;
        f_ += npe_errorFunc( AllParam );     /* +f(xi+hi,x2)*/
      
        vParam[i]->value = xi - hi;
        f_ += npe_errorFunc( AllParam );     /* +f(xi-hi,x2)*/

        Hess[i][j] = f_/(hi*hi);         /* f''(x)=f_ /hi^2 */
      }
      fflush( (FILE *)stdout );
      vParam[i]->value = xi;
      vParam[j]->value = xj;
      Hess[j][i]=Hess[i][j];
    }
  }

}
