/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: npeepriv.h,v 1.1 2004/04/19 17:07:52 orrisroot Exp $ */
/* libnpes - header file of private functions */
#ifndef _LIBNPEE_PRIVATE_H_
#define _LIBNPEE_PRIVATE_H_

#ifdef EXTERN
# undef EXTERN
#endif
#ifdef LIBNPEE_GLOBAL_VARS
# define EXTERN
#else
# define EXTERN extern
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* definition of macro */
#define  square(X)    ((X)*(X))

/* global variables */
/*  nabla f(x) & Direction vector */
EXTERN double       *nablaF;
EXTERN double       *Direction;
/*  Value of Error & Penarty */
EXTERN double        ErrorValue;
EXTERN double        DispValue;
EXTERN double        PenaltyValue;
/* Number of integration */
EXTERN unsigned int  Step;

/* initialization */
/* Read Store File Names - lib/sim/read.c */
int    npe_readStoreFile();
/* Read Data - lib/sim/read2.c */
void   npe_readData();
/* Read Terminal Criterion - lib/sim/term.c */
int    npe_readTermCriterion();

/* finalization */
/* Clean Up Function - lib/sim/clean.c */
void   npe_cleanUp();

/* calculation */
/* Interpolation Function - lib/sim/lsearch.c */
void       npe_interpolation();
/* Display parameters Function - lib/sim/display.c */
void       npe_display_parameters(npe_param_t *param, double errorValue);
/* Subroutine of Differentiate Params - lib/sim/diff.c */
double     npe_differentiate(npe_param_t  *vParam[], double *nablaFx, 
                             double *direction);
/* Subroutine of Differentiation - lib/sim/secdiff.c (not used) */
void       npe_secondDifferential(npe_param_t  *vParam[], double  **Hess);
/* Scale Transformation - lib/sim/scale.c */
int        npe_scaleTrans(npe_param_t **varParam);
/* Store Parameter Histry - lib/sim/store.c */
int        npe_storeParamHist(npe_param_t *Param, int finalFlag);
/* Check terminate criterion - lib/sim/term.c */
npe_bool_t npe_term();

/* Get Simplex Errors - lib/sim/simplex.c */
double  *npe_simplex_get_errors();

/**************************/
/** optimazation methods **/
/**************************/

/* lib/sim/bfgs.c */
int npe_method_bfgs();
/* lib/sim/simplex.c */
int npe_method_simplex();
/* lib/sim/conjprp.c */
int npe_method_conjprp();
/* lib/sim/conjfr.c */
int npe_method_conjfr();
/* lib/sim/ssvm.c */
int npe_method_ssvm();
/* lib/sim/dfp.c */
int npe_method_dfp();

/**************************/
/** linear search methods */
/**************************/

/* lib/sim/golden.c */
void npe_lsearch_golden();
/* lib/sim/cubic.c */
void npe_lsearch_cubic();
/* lib/sim/brent.c */
void npe_lsearch_brent();

#ifdef __cplusplus
}
#endif

#endif /* _LIBNPEE_PRIVATE_H_ */

