/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: type.c,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/*****************************************************
**  type.c                                          **
**  function : converter of type name between value **
*****************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "libnpec.h"
#include "npecpriv.h"

#ifdef __cplusplus
extern "C" {
#endif

static int _npe_check_type(const char *name, const char *str[], int err);

static const char *element_str[] =
  {"method", "lsearch", "model", "penalty", "init", "scale", "term",
   "number", "point", "data", "weight", "result", "history", "xinteg",
   "display", "norm", "all", NULL};
int npe_element_type(const char *name){
  int i;
  if(name == NULL)
    return NPE_ELEMENT_NONE;
  for(i=0; element_str[i] != NULL; i++){
    if(npe_strincmp(element_str[i], name, 3) == 0) break;
  }
  if(element_str[i] == NULL)
    return NPE_ELEMENT_NONE;
  return i;
}

int npe_element_length(int type){
  if(type <= NPE_ELEMENT_NONE || type >= NPE_ELEMENT_TYPESIZE)
    return -1;
  return (int)strlen(element_str[type]);
}

int npe_method_type(const char *name){
  return _npe_check_type(name, npec_method_str, NPE_METHOD_NONE);
}

int npe_lsearch_type(const char *name){
  return _npe_check_type(name, npec_lsearch_str, NPE_LSEARCH_NONE);
}

int npe_model_type(const char *name){
  return _npe_check_type(name, npec_model_str, NPE_MODEL_NONE);
}

int npe_param_flag_type(const char *name){
  return _npe_check_type(name, npec_param_flag_str, NPE_PARAM_FLAG_NONE);
}

int npe_strincmp(const char *s1, const char *s2, size_t n){
  size_t i;
  int l1,l2;
  unsigned char uc1, uc2;
  i = 1;
  do{
    uc1 = (unsigned char)*s1; s1++;
    uc2 = (unsigned char)*s2; s2++;
    l1 = tolower(uc1);
    l2 = tolower(uc2);
    if( n != 0 && n <= i) break;
    i++;
  }while(l1 && (l1 == l2));
  return (l1 - l2);
}

/* private functions */
static int _npe_check_type(const char *name, const char *str[], int err){
  int i;
  if(name == NULL)
    return err;
  for(i=0; str[i] != NULL; i++){
    if(npe_strincmp(str[i], name, 0) == 0)
      break;
  }
  if(str[i] == NULL)
    return err;
  return i;
}

#ifdef __cplusplus
}
#endif
