/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: init.c,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/****************************************************
**  init.c                                         **
**  function : initialization of npe common area   **
****************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libnpec.h"
#include "npecpriv.h"

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************/
/* allocate & initialize npe common memory     */
/* return value:                               */
/*               0: success                    */
/*              -1: npe common not initialized */
/*              -2: out of memory              */
/***********************************************/
npe_common_t *npe_common_new(){
  int i;
  npe_common_t *nc;

  /* memory allocation */
  if((nc = (npe_common_t*)malloc(sizeof(npe_common_t))) == NULL)
    return NULL; /* out of memory */

  nc->store_flag    = NPE_TRUE;
  nc->method_type   = NPE_METHOD_NONE;
  nc->method_name   = NULL;
  nc->lsearch_type  = NPE_LSEARCH_NONE;
  nc->lsearch_name  = NULL;
  nc->lsearch_value = 0.0;
  nc->model_type    = NPE_MODEL_NONE;
  nc->model_name    = NULL;
  nc->model_file    = NULL;
  nc->penalty_file  = NULL;
  nc->init_paramnum = 0;
  nc->estparam      = NULL;
  nc->scale_type    = NPE_SCALE_NONE;
  nc->term_logic    = NULL;
  for(i=0; i<NPE_TERM_CRITESIZE; i++){
    nc->term_setbit[i] = NPE_FALSE;
    nc->term_crite[i]  = 0.0;
  }
  nc->number_value  = 0;
  nc->point_value   = 0;
  nc->data_file     = NULL;
  nc->weight_file   = NULL;
  nc->result_file   = NULL;
  nc->history_file  = NULL;
  nc->history_interval = 0;
  nc->display_type  = NPE_DISPLAY_NONE;
  nc->norm_type     = NPE_NORM_NONE;
  return nc; /* success */
}

/***********************************************/
/* release & finalize npe common memory        */
/* return value:                               */
/*               0: success                    */
/*              -1: npe common not initialized */
/***********************************************/
int npe_common_delete(npe_common_t *nc){
  unsigned int i;
  if(nc == NULL)
    return -1; /* npe common not initialized */
  if(nc->method_name)  free(nc->method_name);
  if(nc->lsearch_name) free(nc->lsearch_name);
  if(nc->model_name)   free(nc->model_name);
  if(nc->model_file)   free(nc->model_file);
  if(nc->penalty_file) free(nc->penalty_file);
  if(nc->estparam){
    for(i=0; i<nc->init_paramnum; i++){
      if(nc->estparam[i].name)
        free(nc->estparam[i].name);
      if(nc->estparam[i].flag_name)
        free(nc->estparam[i].flag_name);
    }
    free(nc->estparam);
  }
  if(nc->term_logic);   free(nc->term_logic);
  if(nc->data_file);    free(nc->data_file);
  if(nc->weight_file);  free(nc->weight_file);
  if(nc->result_file);  free(nc->result_file);
  if(nc->history_file); free(nc->history_file);
  free(nc);
  return 0; /* success */
}

#ifdef __cplusplus
}
#endif
