## NPE sample script file ( USR model )
## contents:
##    sin1.sl       ̃t@C
##    sin1_com.sl   ݒt@C(R}ĥ)
##    sin1.prm      ݒt@C(ݒt@C)
##    sin1.c        f\[Xt@C(1-o̓f)
# 1-o̓f

undef(dpt);undef(A_);
undef(B_);undef(C_);
const dpt = 1000;
const A_  = 2;
const B_  = PI/8;
const C_  = 2;

series y[dpt],wgt[dpt];

#  sin, cosf[^̐
t = (0~(dpt-1))/dpt;
y:[0] = A_*sin(2*PI*t + B_) + C_;

#  d􂳂闐̐
ran0 = nrand(dpt,1,0,0.1);

#  f[^{
y:[0] = y:[0] + ran0;

#  d݃t@C̍쐬
wgt:[0] = (0~(dpt-1))*0 + 1;

#  t@CɊi[
$"sin1.dat" = y;
$"sin1.wgt" = wgt;

# 
inline("sin1_com.sl");

#

#vZ
series result,hist;
npe(result,hist);

#GPMI[v
wopen(1,"A4",0,0);
origin(40,40);
#\
t=(0~999)/1000;
data=$"sin1.dat";
scale("N","F","N","F",0,1,-2,6);
color("red","black");
graph(data:[0],t,0,0,0,0,0);
color("black","black");
graph(result,t,0,0,0,0,0);
title(1,"Time","Amplitude");
axis(1,1,"XY","XY",6,0,0,0,0,0);
frame();
label("I",0,100,8.0,0,"NPE sample")
