/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: setup.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/*******************************************************************
 *
 *		NCS module
 *
 *******************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libsatellite.h"
#include "libnpec.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT npe_common_t *npe_common;

DLLEXPORT const char *SetupCommand(){
  static char *setup_command="NPE_setup";
  return setup_command;
}

DLLEXPORT const char *CleanCommand(){
  static char *clean_command="NPE_cleanup";
  return clean_command;
}

DLLEXPORT int NPE_setup(){
  npe_common = npe_common_new();
  if(npe_common == NULL)
    return 1;
  return 0;
}

DLLEXPORT int NPE_cleanup(){
  npe_common_delete(npe_common);
  return 0;
}

#ifdef __cplusplus
}
#endif
