/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: npepriv.h,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/* private header file npe module */
#ifndef _MOD_NPE_PRIVATE_H_
#define _MOD_NPE_PRIVATE_H_

#ifdef __cplusplus
extern "C" {
#endif

#define NPE_FILETYPE_NONE      -1
#define NPE_FILETYPE_OBJECT     0
#define NPE_FILETYPE_CSOURCE    1
#define NPE_FILETYPE_CXXSOURCE  2
#define NPE_FILETYPE_DLL        3

#define NPE_COMMAND "NPE"

typedef struct _npe_condition_t {
  int         model_file_type;
  int         penalty_file_type;
} npe_condition_t;

/* npemake.cpp */
char *npe_tmpfile_path(const char *tmpdir, const char *fname);
int   npe_make(npe_condition_t *ncond);

/* nperun.cpp */
int npe_run(npe_condition_t *ncond);

/* setup.cpp */
extern npe_common_t *npe_common;

#ifdef __cplusplus
}
#endif

#endif /* _MOD_NPE_PRIVATE_H_ */
