/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: cmodel.cpp,v 1.3 2004/07/27 11:13:13 yoshihiko Exp $ */
/**************************************************
**  cmodel.cpp                                   **
**  command  : cmodel                            **
**  function : set model (C or NCS)              **
**  argument : 1.model type (USR or NCS) USR=C   **
**             2.model name                      **
**************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>

#include  "SL_macro.h"
#include  "SL_cmd.h"

#include "libnpec.h"
#include "npepriv.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_npe_cmodel(){
  int   err;
  int   type;
  char *tname, *fname;

  tname = GetString(0);
  fname = GetString(1);

  /* check argument */
  type = npe_model_type(tname);
  if(type == NPE_MODEL_NONE)
    return 109; /* illegal model type */

  /* modified modelname in WIN32 */
#ifdef WIN32
  char *cp;
  char mdlname[NPE_MAXLINE];
  if(strstr(fname, ".o")) {
    strcpy(mdlname, fname);
	cp = strstr(mdlname, ".o");
	*cp = '\0';
	strcat(mdlname, ".dll");
    /*  set contents */
    err = npe_model_set(npe_common, type, mdlname);
  }
  else {
    /*  set contents */
    err = npe_model_set(npe_common, type, fname);
  }
#else
  /*  set contents */
  err = npe_model_set(npe_common, type, fname);
#endif
  switch(err){
  case -1: return 1;   /* can't open common area */
  case -2: return 2;   /* out of memory */
  case  1: return 109; /* illegal model type */
  case  2: return 110; /* illegal model file name */
  }
  return 0;
}

#ifdef __cplusplus
}
#endif
