/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: cload.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/*****************************************************************
**  cload.cpp                                                   **
**  command  : cload                                            **
**  function : load configuration file for parameter estimation **
**             which is generated by "cstore" command           **
*****************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libnpec.h"
#include "npepriv.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_npe_cload()
{
  int   err;
  char  buf[BUFSIZ];
  char *fname;

  fname = GetString(0);
  if(fname == NULL)
    return 3; /* illegal file name */

  if(npe_common->store_flag == NPE_FALSE){
    printf("Estimation Conditions has been Modified. OK? (y/n) :" );
    if(sl4_getstr(buf, BUFSIZ) != NULL){
      if((buf[0] != 'Y')&&(buf[0] != 'y')){
        printf("Try again.\n" );
        return 0;
      }
    }else{
      printf("Illegal input.\n");
      return 0;
    }
  }
  err = npe_common_load(npe_common, fname);
  if(err != 0)
    return err; /* load fail */

  printf("[%s]=>[NPE Common Area]\n", fname);
  return 0;
}

#ifdef __cplusplus
}
#endif
