/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: cdel.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/*************************************************
**  cdel.cpp                                    **
**  command  : cdel                             **
**  function : delete one estimation condition  **
**             from npe common area.            **
*************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include  <stdio.h>
#include  <stdlib.h>
#include  <ctype.h>
#include  <string.h>

#include  "SL_macro.h"
#include  "SL_cmd.h"

#include "libnpec.h"
#include "npepriv.h"

#ifdef __cplusplus
extern "C" {
#endif

/* private function */
static void _npe_common_init();

/******************** MAIN ********************/
DLLEXPORT int mod_npe_cdel()
{
  int   type;
  char  *str;

  str = GetString(0);
  if(str == NULL)
    return 102; /* illegal element type */

  type = npe_element_type(str);

  switch(type){
  case NPE_ELEMENT_METHOD:
    npe_method_set(npe_common, NPE_METHOD_NONE);
    break;
  case NPE_ELEMENT_LSEARCH:
    npe_lsearch_set(npe_common, NPE_LSEARCH_NONE, 0.0);
    break;
  case NPE_ELEMENT_MODEL:
    npe_model_set(npe_common, NPE_MODEL_NONE, "");
    break;
  case NPE_ELEMENT_PENALTY:
    npe_penalty_set(npe_common, "");
    break;
  case NPE_ELEMENT_INIT:
    npe_init_set(npe_common, 0, 0, 0.0, NPE_PARAM_FLAG_VAR, "", 0);
    break;
  case NPE_ELEMENT_SCALE:
    npe_scale_set(npe_common, NPE_SCALE_NONE);
    break;
  case NPE_ELEMENT_TERM:
    npe_logic_set(npe_common, "");
    break;
  case NPE_ELEMENT_NUMBER:
    npe_number_set(npe_common, 0);
    break;
  case NPE_ELEMENT_POINT:
    npe_point_set(npe_common, 0);
    break;
  case NPE_ELEMENT_DATA:
    npe_data_set(npe_common, "");
    break;
  case NPE_ELEMENT_WEIGHT:
    npe_weight_set(npe_common, "");
    break;
  case NPE_ELEMENT_RESULT:
    npe_result_set(npe_common, "");
    break;
  case NPE_ELEMENT_HISTORY:
    npe_history_set(npe_common, "", 0);
    break;
  case NPE_ELEMENT_DISPLAY:
    npe_display_set(npe_common, NPE_DISPLAY_NONE);
    break;
  case NPE_ELEMENT_NORM:
    npe_norm_set(npe_common, NPE_NORM_NONE);
    break;
  case NPE_ELEMENT_ALL:
    _npe_common_init();
    break;
  default:
    return 102; /* illegal element type */
  }
  return 0;
}

static void _npe_common_init(){
  npe_method_set(npe_common, NPE_METHOD_NONE);
  npe_lsearch_set(npe_common, NPE_LSEARCH_NONE, 0.0);
  npe_model_set(npe_common, NPE_MODEL_NONE, "");
  npe_penalty_set(npe_common, "");
  npe_init_set(npe_common, 0, 0, 0.0, NPE_PARAM_FLAG_VAR, "", 0);
  npe_scale_set(npe_common, NPE_SCALE_NONE);
  npe_logic_set(npe_common, "");
  npe_number_set(npe_common, 0);
  npe_point_set(npe_common, 0);
  npe_data_set(npe_common, "");
  npe_weight_set(npe_common, "");
  npe_result_set(npe_common, "");
  npe_history_set(npe_common, "", 0);
  npe_display_set(npe_common, NPE_DISPLAY_NONE);
  npe_norm_set(npe_common, NPE_NORM_NONE);
}

#ifdef __cplusplus
}
#endif

/* --- end of delblock.c --- */
