/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: shfilter.c,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/*****************************************************************************
  
        Function to append file

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>

#include "libncsc.h"

#define  _MAX_PATH    256

#ifdef __cplusplus
extern "C" {
#endif

int npp_sh_filter(const char *infile, const char *outfile){
  FILE *rfp,*wfp;
  int   FLAG,i;
  char  MODULE[_MAX_PATH];
  char  line[_MAX_PATH];
  char *cptr;

  if((rfp = fopen(infile,"r")) == NULL)
    return 1;
  FLAG = NCS_FALSE;
  while(!feof(rfp)) {
    if(fgets(line, _MAX_PATH, rfp) == NULL)
      break;
    /* check 'type:' exists */
    if((cptr = strstr(line, "type:")) != NULL) {
      cptr+=5;
      if(strlen(cptr)>0) {
        if(strstr(cptr, "NETWORK") != NULL) {
          FLAG = NCS_TRUE;
          break;
        }
      }
    }
    /* check 'module:' exists */
    if((cptr = strstr(line, "module:")) != NULL) {
      cptr+=7;
      /* search sentence */
      strcpy(MODULE,"");
      i=0;
      while(*cptr!='\0') {
        if(*cptr == ';') {
          FLAG = NCS_TRUE;
          break;
        }
        if(*cptr!='\t' && *cptr!= ' ')
          MODULE[i++] = *cptr;
        cptr++;
      }
      MODULE[i] = '\0';
      if(FLAG == NCS_TRUE && strlen(MODULE) > 0) {
        FLAG = NCS_FALSE;
      } else {
        FLAG = NCS_FALSE;
        strcpy(MODULE,"");
      }
      break;
    }

  }
  fclose(rfp);
  /* flag and buffer length check */
  if(FLAG == NCS_FALSE && strlen(MODULE) < 1)
    return 1;
  /* append to outfile */
  if(FLAG == NCS_FALSE && strlen(MODULE) > 0) {
    if((wfp = fopen(outfile,"w")) == NULL) {
      return 1;  /* open error */
    }
    fprintf(wfp,"/***  Network description  ***/\n");
    fprintf(wfp,"type:      NETWORK;\n");
    fprintf(wfp,"module:     SYSTEM;\n");
    fprintf(wfp,"cell:     %s[1];\n",MODULE);
    fprintf(wfp,"connection:\n");
    fprintf(wfp,"          %s[0] < ();\n",MODULE);
    fprintf(wfp,"          end;\n");
    fprintf(wfp,"\n");
    fprintf(wfp,"/*** Single module description  ***/\n");
    fprintf(wfp,"type:      CELL;\n");
    /* append model */
    rfp = fopen(infile,"r");
    while(!feof(rfp)) {
      if(fgets(line, _MAX_PATH, rfp) == NULL)
        break;
      fprintf(wfp,"%s",line);
    }
    fclose(wfp);
    fclose(rfp);
  }
  else {
    /* copy */
    if((wfp = fopen(outfile,"w")) == NULL) {
      return 1;  /* open error */
    }
    rfp = fopen(infile,"r");
    while(!feof(rfp)) {
      if(fgets(line, _MAX_PATH, rfp) == NULL)
        break;
      fprintf(wfp,"%s",line);
    }
    fclose(wfp);
    fclose(rfp);
  }
  return 0;
}

#ifdef __cplusplus
}
#endif
