/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: chklist.c,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/**********************************************************************

  	Function to check library function.

**********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libncsc.h"
#include "chklist.h"

static int search_char_str( char *, char );
static void display_wanning( char * );

int check_lib_func_list( char *func, char *arg ){
  int flag = 0;
  char tempbox[100];
  int dummy_num = 0;

  if( strcmp( func, FUNC1 ) == 0 ){
    if( N_FUNC1 != ( search_char_str( arg, ',' )+1 ) ){
      display_wanning( func );
    }else{
      dummy_num = 5-N_FUNC1;
      flag++;
    }
  }
  if( strcmp( func, FUNC2 ) == 0 ){
    if( N_FUNC2 != ( search_char_str( arg, ',' )+1 ) ){
      display_wanning( func );
    }else{
      dummy_num = 5-N_FUNC2;
      flag++;
    }
  }
  if( strcmp( func, FUNC3 ) == 0 ){
    if( N_FUNC3 != ( search_char_str( arg, ',' )+1 ) ){
      display_wanning( func );
    }else{
      dummy_num = 5-N_FUNC3;
      flag++;
    }
  }
  if( strcmp( func, FUNC4 ) == 0 ){
    if( N_FUNC1 != ( search_char_str( arg, ',' )+1 ) ){
      display_wanning( func );
    }else{
      dummy_num = 5-N_FUNC4;
      flag++;
    }
  }
  
  if( flag == 0 ){
    return( NCS_FALSE );
  }else{
    if( dummy_num > 0 ){
      int i;
      tempbox[0] = '\0';
      i = 0;
      do{
        strcat( tempbox, ", " );
        strcat( tempbox, "0.0" );
        i++;
      }while(i<dummy_num);
      strcat( arg, tempbox);
    }
    return( NCS_TRUE );
  }
}

static int search_char_str( char *str, char chr )
{
  int i = 0;
  char *pointer1, *pointer2;
  
  pointer1 = str;
  while( (pointer2 = strchr( pointer1, chr )) != NULL ){
    pointer1 = pointer2+1;
    i++;
  }
  return( i );
}

static void display_wanning( char *str )
{
  fprintf( stderr, 
	  "Warnning!! : Argument Mismatch in Library Function \"%s\".\n",
	  str );
}
