/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/*****************************************************************************
  
                Functions to Control of Pointer's List
                    for NCS Module to SATELLITE

        $Id: plist.c,v 1.2 2004/09/28 03:58:13 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif  /* HAVE_STDLIB_H */

#define MOD_NCS_LIBNCSS_EXPORTS
#include "libncsc.h"
#include "libncss.h"

#ifdef __cplusplus
extern "C" {
#endif

/* static int    plist_err( int number ); */
static int    plist_remove_cell( PList list );
static PList  plist_get_cell();

static int    err_info = 0; /*  PL_ERROR_NODISP) Not display error         */
                            /*    PL_ERROR_DISP) display error             */
                            /* PL_ERROR_ALLDISP) display error and warning */

/*
 *  Funtion to creat list's cell ( static )
 *  input:  arg --- dummy
 *  output: address of cell of list
 */ 
static PList plist_get_cell()
{
  PList list;
/*   int err; */

  if( ( list = (PList)malloc( sizeof( PList ) ) ) == NULL ){
/*     if( (err = plist_err(1)) != NCS_TRUE ){ */
/*       exit(err); */
/*     }else{ */
      return( NULL );
/*     } */
  }

  list->member = NULL;
  list->next = NULL;
  
  return( list );
}


/*
 *  Function to remove cell (static)
 *  input:  PList list --- root list
 *  output: NCS_TRUE or NCS_FALSE
 */
static int plist_remove_cell( PList list )
{
  /*  free( list ); */

  return( NCS_TRUE );
}

/*
 *  Function to display wrror or warning message (static)
 *  input:  int number --- error number
 *  output: error infomation
 */
/* static int plist_err( int number ) */
/* { */
/*   if( err_info != PL_ERROR_NODISP ){ */
/*     switch( number ){ */
/*      case 1: */
/*       fprintf( stderr, "Error (plist 1):Memory Allocation Error\n" ); */
/*       return( PL_FATAL ); */
/*       break; */
/*      default: */
/*       fprintf( stderr, "Error (plist ?):Error in PList\n" ); */
/*       break; */
/*     } */
/*   } */
/*   return( NCS_TRUE ); */
/* } */

/*
 *  Function to creat list structure
 *  input:  int error level 
 *           --- PL_ERROR_NODISP)  Not display error
 *               PL_ERROR_DISP)    display error            
 *               PL_ERROR_ALLDISP) display error and warning 
 *  output: address of root cell of list
 */ 
DLLEXPORT PList plist_create( int err_level )
{
  PList root;

  if( ( err_level > 1 ) || ( err_level < 0 ) ){
    fprintf( stderr, "Warning (plist): No much error level\n" );
    err_info = 0;
  }else{
    err_info = err_level;
  }

  root = plist_get_cell();
  if(root == NULL) return NULL;

  root->member = (PLMember)NULL;
  root->next = (PList)NULL;
  
  return  root;
}

/*
 *  Function to destroy list structure
 *  input:  PList list --- root list
 *  output: NCS_TRUE or NCS_FALSE
 */ 
DLLEXPORT int plist_destroy( PList list ){
  PLPointer pointer = list, next = list;

  do{
    next = pointer->next;
    if( plist_remove_cell( pointer ) != NCS_TRUE ){
      return( NCS_FALSE );
    }
    pointer = next;
  }while( pointer != NULL );

  return( NCS_TRUE );
}

/*
 *  Function to advance pointer of list
 *  input:  PList current --- root of current list
 *          PLPointer pointer --- pointer of current list
 *  output: advanced pointer of current list
 *          ( if pinter indicate end cell, then it is original pointer )
 */ 
DLLEXPORT PLPointer plist_advance( PList current, PLPointer pointer ){
  if( pointer->next != NULL ){
    return( pointer->next );
  }else{
    return( pointer );
  }
}


/*
 *  Function to retreat pointer of list
 *  input:  PList current --- root of current list
 *          PLPointer pointer --- pointer of current list
 *  output: retreated pointer of current list
 *          ( if pinter indicate first cell, then it is original pointer )
 */ 
DLLEXPORT PLPointer plist_retreat( PList current, PLPointer pointer ){
  PLPointer tmp = current;

  if( current == pointer ){
    return( pointer );
  }
  
  while( tmp->next != pointer ){
    tmp = tmp->next;
  }

  return( tmp );
}

/*
 *  Function to read list's member
 *  input:  PList current --- root of current list
 *          PLPointer pointer --- pointer of current list
 *  output: read data
 */ 
DLLEXPORT PLMember plist_read_data( PList current, PLPointer pointer ){
  return( pointer->member );
}

/*
 *  Function to write data in list's member
 *  input:  PList current --- root of current list
 *          PLPointer pointer --- pointer of current list
 *          PLMember data --- data to write
 *  output: pointer of current list
 */ 
DLLEXPORT PLPointer plist_write_data( PList current, PLPointer pointer,
                                      PLMember data ){
  pointer->member = data;
  return( pointer );
}

/*
 *  Function to insert data in list's member
 *  input:  PList current --- root of current list
 *          PLPointer pointer --- pointer of current list
 *          PLMember data --- data to write
 *  output: pointer of current list
 */ 
DLLEXPORT PLPointer plist_insert( PList current, PLPointer pointer, 
                                  PLMember data ){
  PList cell;
  PLPointer next;

  next = pointer->next;
  cell = plist_get_cell();
  if(cell == NULL) return NULL;

  pointer->next = next;

  cell->next = (PList)pointer->next;
  pointer->next = cell;

  pointer = plist_write_data( current, cell, data );

  return( pointer );
}

/*
 *  Function to delete cell in list structure
 *  input:  PList current --- root of current list
 *          PLPointer pointer --- pointer of current list
 *  output: pointer of current list
 */ 
DLLEXPORT PLPointer plist_delete( PList current, PLPointer pointer ){
  PLPointer ret;

  if( current == pointer ){
    return( pointer );
  }

  ret = plist_retreat( current, pointer );
  ret->next = pointer->next;
  
  plist_remove_cell( pointer );
  
  return(ret);
}

/*
 *  Function to Return to Number of Cell of List Structure
 *  input:  PList current --- root of current list
 *  output: number of cell
 */ 
DLLEXPORT int plist_number_cell( PList current ){
  PLPointer point = current;
  int n = 0;

  while( point->next != NULL ){
    n++;
    point = point->next;
  }

  return( n );
}

/*
 *  Function to Move Pointer to Top
 *  input:  PList current --- root of current list
 *  output: pointer of current list
 */ 
DLLEXPORT PLPointer plist_go_top( PList current ){
  return( current );
}

/*
 *  Function to Move Pointer to End
 *  input:  PList current --- root of current list
 *  output: pointer of current list
 */ 
DLLEXPORT PLPointer plist_go_end( PList current ){
  PLPointer point = current;

  /*  printf( "pointer = %x\n", point );*/
  while( point->next != (struct PLIST   *)NULL ){
    /*  printf( "pointer = %x\n", point );*/
    point = (PLPointer)point->next;
  }

  return( point );
}

/*
 *  Function to Move Pointer to N th
 *  input:  PList current --- root of current list
 *          int   n       --- n th
 *  output: pointer of n th
 */ 
DLLEXPORT PLPointer plist_go_nth( PList current, int n ){
  PLPointer point = current;
  int i;
  
  for( i = 0; i < n; i++ ){
    point = plist_advance( current, point );
  }

  return( point );
}

#ifdef __cplusplus
}
#endif
