/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/*****************************************************************************

                     NCS FUNCTION FOR SIMULATION PROGRAM

    $Id: ncssfunc.cpp,v 1.3 2005/03/01 15:10:09 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_WINDOWS_H
# include <windows.h>  /* for GetComputerName() */
#endif

#include <stdio.h>
#include <string.h>
#include <math.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#include "libsatellite.h"

#define MOD_NCS_LIBNCSS_EXPORTS
#include "libncsc.h"
#include "libncss.h"
#include "ncssdata.h"
#include "ncssdsp.h"

#include "terminal.h"

#ifdef __cplusplus
extern "C" {
#endif

static void ncsf_valset_all(int nt, int *nctbl, 
                            double **mem_ptr, double value);
static void ncsf_prnd(int cnt, double **dptr);

static void ncsf_valset_all(int  nt, int nctbl[], double *mem_ptr[],
                            double value);
static void ncsf_prnd(int prn_index, double *dptr[]);

#ifdef WIN32
static int calc_progress = 0;
#endif

/* global functions */
/*****************************************************************************
FUNCTION  NCSF_SCSET
******************************************************************************
SET SIMULAITON CONDITION

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
UNIX                                          Modifid by S.Hitomi  06/28/1991
*****************************************************************************/

DLLEXPORT void ncsf_scset( int  *dpoint, int *calc_end, int *str_period,
                           double *report_end ){
  long   tmpl;
  double tmpf;

  /* preprocessing */
  tmpf = ncsg_bufstep / ncsg_calstep + 0.5;
  ncsg_bufperiod = (long) tmpf;
  tmpf = ncsg_strstep / ncsg_calstep + 0.5;
  *str_period = (long) tmpf;
  tmpf = ncsg_endtime / ncsg_calstep + 0.5;
  *calc_end = (long) tmpf;

  tmpl = *calc_end + 1;
  *report_end = tmpl;

  tmpl = *calc_end / (*str_period) + 1;
  *dpoint = (int) tmpl;

}


/*****************************************************************************
FUNCTION  NCSF_INITSET
******************************************************************************
INITIALIZE MEMORY

MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

DLLEXPORT void ncsf_initset(){
  ncsf_valset_all( ncsg_ntout, ncsg_ncout, ncsm_outptr, 0. );
  ncsf_valset_all( ncsg_ntxin, ncsg_ncxin, ncsm_xinptr, 0. );
  ncsf_valset_all( ncsg_ntobs, ncsg_ncobs, ncsm_obsptr, 0. );
}


/*****************************************************************************
FUNCTION  NCSF_MONISET
******************************************************************************
SET MONITERING CONSTANTS

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
UNIX                                          Modifid by S.Hitomi  06/28/1991
*****************************************************************************/

DLLEXPORT void ncsf_moniset( char *moni_vflag ){
  if( ncsg_monimode == NCS_MONI_VLONLY ){
    *moni_vflag = NCS_FLAG_ON;
  } else {
    *moni_vflag = NCS_FLAG_OFF;
  }
}


/*****************************************************************************
FUNCTION  NCSF_STARTSIGN
******************************************************************************
INDICATE CALCULATION START SIGN

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

DLLEXPORT void ncsf_startsign(){
  char hostname[128];
#ifdef WIN32
  DWORD size = 128;
  if(GetComputerName(hostname, &size) == FALSE)
    strcpy(hostname, "(unknown)");
#else
  if(gethostname(hostname, 128) != 0)
    strcpy(hostname, "(unknown)");
#endif
  
  printf( "###### NCS on %s ######\n", hostname );
  /* indicating start sign */
  printf( ">> NOW CALCULATING ... WAIT FOR A TIME, PLEASE !! <<" );

#ifndef WIN32
  sl4_term_init(stdin, stdout, stderr);
  sl4_term_cursor_invisible();
#endif
}


/*****************************************************************************
FUNCTION  NCSF_REPOSTART
******************************************************************************
INDICATE CALCULATION PROGRESS REPORT

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

DLLEXPORT void ncsf_repostart(){
  /* indicating calculation progress report */
#ifdef WIN32
  fprintf(stdout, "\n");
  fflush(stdout);
#else
  /* Cursor backward */
  sl4_term_puts("   0.0%% done.");
  sl4_term_cursor_left(7);
#endif
}


/*****************************************************************************
FUNCTION  NCSF_DATAOUT
******************************************************************************
STORE THE RESULTS OF CALCULATION

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
UNIX                                          Modifid by S.Hitomi  06/28/1991
*****************************************************************************/

DLLEXPORT void ncsf_dataout( char *moni_vflag, int index, int strd_cnt ){
/*#ifdef DSPTEC_EXTENSION*/
#if 0
  /* Communication */
  int     i,update,prmnum;
  double  data;
  int    *dataptr,*prmptr;
  int     endfg;
  
  if(g_realtime_mode >= 2) {
    if(MapPointer != NULL) {
      /* data area */
      dataptr = (int *)MapPointer;
      /* check host control */
      endfg = *dataptr++;    /* check force exit */
      if(endfg)
        g_calc_end_flag = 1;
      /* data area */
      *dataptr++ = 1;
      *dataptr++ = index;
      for( i = 0; i < ncsg_nstrd; i++ ){
        /* *dataptr++ = (int)(*ncsg_strdptr[i]); */
        *((double*)dataptr) = *ncsg_strdptr[i];
        dataptr++;
      }
      /* parameter area */
      prmptr = (int*)MapPointer;
      prmptr += 32;
      prmnum = *prmptr++;
      for(i = 0; i <prmnum; i++) {
        update = *prmptr++;
        data = *((double*)prmptr);
        prmptr++;
        if(update) {
          scData[i].prm_val.prm_real = data;
          if (ncsf_prmset_func(&scData[i]) != NCS_SUCCESS) {
            fprintf(stdout, "ncsf_prmset error.\n");
          }
          else
            fprintf(stdout,"%d -> %f\n",i,data);
        }
      }
    }
  }
#endif

  ncsf_strd( ncsg_nstrd, index, ncsg_strdptr );
  if( ( strd_cnt % ncsg_bufperiod ) == 0 ){
    ncsf_StoreData( index, ncsg_nstrd );
  }

  if( *moni_vflag == NCS_FLAG_ON ){
    ncsf_prnd( index, ncsg_vmoniptr );
  }

#ifdef DSPTEC_EXTENSION
  /* output to external by I/O interface */
  if(gScxfpType == 3) {
    if(g_realtime_outport != -1) {
      ncsl_da3305(1,*ncsg_strdptr[g_realtime_outport]);
    }
  }
#endif
}


/*****************************************************************************
FUNCTION  NCSF_REPOPROGRESS
******************************************************************************
INDICATE PROGRESS REPORT

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

DLLEXPORT void ncsf_repoprogress( int calc_cnt, double report_end ){
  long   tmpl;
  double progress;

  /* indicating calculation progress report */
  tmpl = calc_cnt + 1;
  progress = (tmpl / report_end ) * 100.0;

#ifdef WIN32
  {
    for(;calc_progress < (int)(progress*2); calc_progress++){
      if(calc_progress != 0){
        if((calc_progress % 10) == 0){
          fprintf(stdout, "%3d%% ", calc_progress/2);
          if((calc_progress % 50) == 0) fprintf(stdout, "\n");
        }else{
          fprintf(stdout, ".");
        }
        fflush(stdout);
      }
    }
  }
#else
  /* Cursor backward */
  /* TODO corsor 6 char back */
  sl4_term_cursor_left(6);
  fprintf(stdout, " %5.1f", progress);
  fflush(stdout);
#endif
}


/*****************************************************************************
FUNCTION  NCSF_ENDSIGN
******************************************************************************
INDICATE END SIGN

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

DLLEXPORT void ncsf_endsign(){
  /* move cursor to left margin */
  /* TODO move cursor to begin of line */
#ifndef WIN32
  printf("\r"); 
#endif
  /* indicating end sign */
  printf(">> THE CALCULATION HAS FINISHED .............. !! <<\n");
  /* Enable cursor display */
  /* TODO show cursor */
#ifndef WIN32
  sl4_term_cursor_normal();
  sl4_term_quit();
#endif
}


/*****************************************************************************
FUNCTION  NCSF_REPOEND
******************************************************************************
INDICATE CALCULATION PROGRESS REPORT

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

DLLEXPORT void ncsf_repoend(){
  /* indicating calculation progress report */
#ifdef WIN32
  {
    for(;calc_progress < 200; calc_progress++){
      if(calc_progress == 0){
        fprintf(stdout, "\n");
      }else{
        if((calc_progress % 10) == 0){
          fprintf(stdout, "%3d%% ", calc_progress/2);
          if((calc_progress % 50) == 0) fprintf(stdout, "\n");
        }else{
          fprintf(stdout, ".");
        }
      }
      fflush(stdout);
    }
  }
  fprintf(stdout," 100%%\n");
#else
  /* cursor 5 char back */
  sl4_term_cursor_left(5);
  sl4_term_puts("100.0");
#endif
  fflush(stdout);
}

/*****************************************************************************
FUNCTION  NCSF_XINSET_INIT
******************************************************************************
INITIALIZE EXTERNAL INPUT INFORMATION

*****************************************************************************/
#ifdef DSPTEC_EXTENSION
DLLEXPORT void ncsf_xinset_init( int nxinc, xininfo_t *xin_data,
                                 xfpinfo_t *xfp_data ){
  int cnt, xfd_num, func_num;

  for (cnt = 0; cnt < nxinc; cnt++) {
    xfd_num = xin_data[cnt].xfd_number - 1;
    func_num = xfp_data[xfd_num].xf_number - 1;
    if(func_num == 6) {
      // sweep
    }
  }
}
#endif

/*****************************************************************************
FUNCTION  NCSF_XINSET
******************************************************************************
SET EXTERNAL INPUT INFORMATION

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/
DLLEXPORT void ncsf_xinset(int nxinc, xininfo_t *xin_data, 
                           xfpinfo_t *xfp_data, XIN_FUNC xin_func[]){
  int     cnt, xfd_num, func_num;
  double *mem_addr;
  XIN_FUNC func_addr;

  for (cnt = 0; cnt < nxinc; cnt++) {
    mem_addr = xin_data[cnt].comp_addr;
    CN = xin_data[cnt].comp_number;
    xfd_num = xin_data[cnt].xfd_number - 1;
    func_num = xfp_data[xfd_num].xf_number - 1;
    func_addr = xin_func[func_num];
    *mem_addr = (*func_addr)(xfp_data[xfd_num].xf_para[0],
                             xfp_data[xfd_num].xf_para[1],
                             xfp_data[xfd_num].xf_para[2],
                             xfp_data[xfd_num].xf_para[3],
                             xfp_data[xfd_num].xf_para[4]);
    /*debug exinput value*/
    /*fprintf(stdout,"ncsf_xinset : %g\n", *mem_addr);*/
  }
}

/*****************************************************************************
FUNCTION  NCSF_UPDATE
******************************************************************************
UPDATE MEMORY CONTENTS

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

DLLEXPORT void ncsf_update(int nt, int nctbl[], double *out_ptr[],
                           double *tmp_ptr[]){
  register int  type, number;
  double       *to_addr, *from_addr;

  for (type = 0; type < nt; type++) {
    to_addr = out_ptr[type];
    from_addr = tmp_ptr[type];
    for (number = 0; number < nctbl[type]; number++){
      to_addr[number] = from_addr[number];
    }
  }
}

/* local functions */

/*****************************************************************************
FUNCTION  NCSF_VALSET_ALL
******************************************************************************
SET VALUE

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

static void ncsf_valset_all(int  nt, int nctbl[], double *mem_ptr[], 
                            double value){
  int     type, number;
  double *mem_addr;

  for (type = 0; type < nt; type++) {
    mem_addr = mem_ptr[type];
    if(mem_addr!=NULL) {
      for (number = 0; number < nctbl[type]; number++) {
        mem_addr[number] = value;
      }
    }
  }
}


/*****************************************************************************
FUNCTION  NCSF_PRND
******************************************************************************
CRT OUTPUT OF CALCULATION RESULTS

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
UNIX                                          Modifid by S.Hitomi  06/28/1991
*****************************************************************************/

static void ncsf_prnd(int prn_index, double *dptr[]){
  int     cnt;
  double  f_data=0.;
  double  data;

  if ((prn_index % 10) == 0) {
    printf("\n  TIME ");
    for (cnt = 0; cnt < NCS_MONI_NVAR; cnt++) {
      if (dptr[cnt] != NULL) {
        printf("       ");
        printf("BUFF%2d[%2d]", ncsg_vbuff[cnt], ncsg_vbuffdim[cnt]);
      }
    }
    printf("\n");
  }
  printf("%-15.6f", NCS_TIME);
  for (cnt = 0; cnt < NCS_MONI_NVAR; cnt++) {
    if (dptr[cnt] != NULL) {
      data = *dptr[cnt];
      if (data > 1.e+37){
        f_data = 1.e+37;
      }
      if (data < -1.e+37){
        f_data = (-1.e+37);
      }
      if (-1.e+37 <= data && data <= 1.e+37) {
        if (fabs(data) < 1.e-36){
          f_data = 0.;
        }  else {
          f_data = data;
        }
      }
      printf("%-16.6g", f_data);
    }
  }
  printf("\n");
}

#ifdef __cplusplus
}
#endif
